/*
 * Decompiled with CFR 0.152.
 */
package net.a5ho9999.adventureloot.events;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.a5ho9999.adventureloot.AdventureLootMod;
import net.a5ho9999.adventureloot.config.AdventureLootConfig;
import net.a5ho9999.adventureloot.registry.AdventureLootModItem;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.minecraft.class_117;
import net.minecraft.class_141;
import net.minecraft.class_1935;
import net.minecraft.class_219;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_5250;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_9280;
import net.minecraft.class_9320;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class LootTables {
    public static void AddLootBags() {
        AtomicInteger LootTableCount = new AtomicInteger();
        List<String> exclude = AdventureLootMod.Config.TablesToExclude();
        List<String> include = AdventureLootMod.Config.TablesToAdd();
        LootTableEvents.MODIFY.register((registryKey, builder, lootTableSource, wrapperLookup) -> {
            boolean wasAdded = false;
            String keyPath = registryKey.method_29177().method_12832();
            boolean shouldExclude = exclude.stream().anyMatch(pattern -> LootTables.matchesWildcard(keyPath, pattern));
            boolean shouldInclude = include.stream().anyMatch(pattern -> LootTables.matchesWildcard(keyPath, pattern));
            if (keyPath.contains("chests/") && !shouldExclude && AdventureLootMod.Config.chestDrops.Enabled()) {
                LootTableCount.getAndIncrement();
                LootTables.addBagPools(builder, AdventureLootMod.Config.chestDrops);
                wasAdded = true;
            } else if (keyPath.contains("entities/") && !shouldExclude && AdventureLootMod.Config.entityDrops.Enabled()) {
                LootTableCount.getAndIncrement();
                LootTables.addBagPools(builder, AdventureLootMod.Config.entityDrops);
                wasAdded = true;
            } else if (shouldInclude) {
                AdventureLootConfig.DropTypeConfig dropConfig = keyPath.contains("chests/") ? AdventureLootMod.Config.chestDrops : (keyPath.contains("entities/") ? AdventureLootMod.Config.entityDrops : AdventureLootMod.Config.otherDrops);
                LootTables.addBagPools(builder, dropConfig);
                wasAdded = true;
            }
            if (wasAdded) {
                AdventureLootMod.OnDebug("Added Adventure Bags to \"" + keyPath + "\"");
            } else if (shouldExclude) {
                AdventureLootMod.OnDebug("Excluded Adventure Bags from \"" + keyPath + "\"");
            }
        });
        if (LootTableCount.get() == 0) {
            AdventureLootMod.onLog("Waiting for a World to load to modify Loot-tables...");
        } else {
            AdventureLootMod.onLog("Added Adventure Bags to " + LootTableCount.get() + " Loot-tables");
        }
    }

    private static void addBagPools(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_52.class_53 builder, @NotNull AdventureLootConfig.DropTypeConfig dropConfig) {
        class_55.class_56 legendaryBags;
        class_55.class_56 epicBags;
        class_55.class_56 rareBags;
        class_55.class_56 commonBags;
        if (AdventureLootMod.Config.ServerSideOnly()) {
            class_5250 commonName = class_2561.method_43470((String)"\u00a7fCommon Adventure Bag");
            class_5250 rareName = class_2561.method_43470((String)"\u00a7bRare Adventure Bag");
            class_5250 epicName = class_2561.method_43470((String)"\u00a7cEpic Adventure Bag");
            class_5250 LegendaryName = class_2561.method_43470((String)"\u00a75Legendary Adventure Bag");
            class_9280 modelData = new class_9280(List.of(), List.of(), List.of(), List.of(Integer.valueOf(69)));
            commonBags = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)AdventureLootMod.GetServerCommonBag())).apply(class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)1.0f)).method_515()).method_353((class_117.class_118)class_9320.method_57650((class_9331)class_9334.field_49631, (Object)commonName)).method_353((class_117.class_118)class_9320.method_57650((class_9331)class_9334.field_54199, (Object)class_2960.method_60654((String)"minecraft:white_bundle"))).method_353((class_117.class_118)class_9320.method_57650((class_9331)class_9334.field_49637, (Object)modelData));
            rareBags = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)AdventureLootMod.GetServerRareBag())).apply(class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)1.0f)).method_515()).method_353((class_117.class_118)class_9320.method_57650((class_9331)class_9334.field_49631, (Object)rareName)).method_353((class_117.class_118)class_9320.method_57650((class_9331)class_9334.field_54199, (Object)class_2960.method_60654((String)"minecraft:blue_bundle"))).method_353((class_117.class_118)class_9320.method_57650((class_9331)class_9334.field_49637, (Object)modelData));
            epicBags = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)AdventureLootMod.GetServerEpicBag())).apply(class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)1.0f)).method_515()).method_353((class_117.class_118)class_9320.method_57650((class_9331)class_9334.field_49631, (Object)epicName)).method_353((class_117.class_118)class_9320.method_57650((class_9331)class_9334.field_54199, (Object)class_2960.method_60654((String)"minecraft:red_bundle"))).method_353((class_117.class_118)class_9320.method_57650((class_9331)class_9334.field_49637, (Object)modelData));
            legendaryBags = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)AdventureLootMod.GetServerLegendaryBag())).apply(class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)1.0f)).method_515()).method_353((class_117.class_118)class_9320.method_57650((class_9331)class_9334.field_49631, (Object)LegendaryName)).method_353((class_117.class_118)class_9320.method_57650((class_9331)class_9334.field_54199, (Object)class_2960.method_60654((String)"minecraft:purple_bundle"))).method_353((class_117.class_118)class_9320.method_57650((class_9331)class_9334.field_49637, (Object)modelData));
        } else {
            commonBags = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)AdventureLootModItem.CommonAdventureBag)).apply(class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)1.0f)).method_515());
            rareBags = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)AdventureLootModItem.RareAdventureBag)).apply(class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)1.0f)).method_515());
            epicBags = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)AdventureLootModItem.EpicAdventureBag)).apply(class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)1.0f)).method_515());
            legendaryBags = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)AdventureLootModItem.LegendaryAdventureBag)).apply(class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)1.0f)).method_515());
        }
        class_55.class_56 commonPool = LootTables.getLootPoolWithChance(commonBags, dropConfig.CommonChance());
        class_55.class_56 rarePool = LootTables.getLootPoolWithChance(rareBags, dropConfig.RareChance());
        class_55.class_56 epicPool = LootTables.getLootPoolWithChance(epicBags, dropConfig.EpicChance());
        class_55.class_56 legendaryPool = LootTables.getLootPoolWithChance(legendaryBags, dropConfig.LegendaryChance());
        builder.pool(commonPool.method_355());
        builder.pool(rarePool.method_355());
        builder.pool(epicPool.method_355());
        builder.pool(legendaryPool.method_355());
    }

    private static class_55.class_56 getLootPoolWithChance(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_55.class_56 basePool, double chance) {
        return basePool.method_356(class_219.method_932((float)((float)chance)));
    }

    private static boolean matchesWildcard(String path, @NotNull String pattern) {
        if (pattern.equals("*")) {
            return true;
        }
        if (pattern.endsWith("/*")) {
            String prefix = pattern.substring(0, pattern.length() - 1);
            return path.startsWith(prefix);
        }
        if (pattern.startsWith("*") && pattern.endsWith("*")) {
            String contains = pattern.substring(1, pattern.length() - 1);
            return path.contains(contains);
        }
        if (pattern.startsWith("*")) {
            String suffix = pattern.substring(1);
            return path.endsWith(suffix);
        }
        if (pattern.endsWith("*")) {
            String prefix = pattern.substring(0, pattern.length() - 1);
            return path.startsWith(prefix);
        }
        return path.equals(pattern);
    }
}

