/*
 * Decompiled with CFR 0.152.
 */
package net.a5ho9999.adventureloot.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.a5ho9999.adventureloot.AdventureLootMod;
import net.a5ho9999.adventureloot.data.AdventureBagDefaults;
import net.a5ho9999.adventureloot.util.AdventureBag;
import net.a5ho9999.adventureloot.util.FuckingComponentUtils;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9323;
import org.jetbrains.annotations.NotNull;

public class AdventureLootUtil {
    public static List<AdventureBag> GetLoot(class_1937 world, AdventureBagTypes type) {
        boolean usePureDefault = false;
        OptionTypes defaultOption = AdventureLootMod.Config.DefaultOptions();
        if (defaultOption == OptionTypes.Default) {
            usePureDefault = true;
            AdventureLootUtil.Debug("Using Built-in Loot-tables");
        } else if (defaultOption == OptionTypes.Disabled) {
            AdventureLootUtil.Debug("Built-in Loot-tables disabled, using Custom Loot-tables");
        }
        switch (type.ordinal()) {
            case 0: {
                return AdventureLootUtil.GetLoot_v2(world, type, usePureDefault ? AdventureBagDefaults.CommonDefaults : AdventureLootMod.Config.CommonLoot());
            }
            case 1: {
                return AdventureLootUtil.GetLoot_v2(world, type, usePureDefault ? AdventureBagDefaults.RareDefaults : AdventureLootMod.Config.RareLoot());
            }
            case 2: {
                return AdventureLootUtil.GetLoot_v2(world, type, usePureDefault ? AdventureBagDefaults.EpicDefaults : AdventureLootMod.Config.EpicLoot());
            }
            case 3: {
                return AdventureLootUtil.GetLoot_v2(world, type, usePureDefault ? AdventureBagDefaults.LegendaryDefaults : AdventureLootMod.Config.LegendaryLoot());
            }
        }
        return null;
    }

    private static List<AdventureBag> GetLoot_v2(class_1937 world, AdventureBagTypes type, List<String> itemStrings) {
        try {
            ArrayList<AdventureBag> bag = new ArrayList<AdventureBag>();
            ArrayList<String> rawDataList = new ArrayList<String>(itemStrings);
            if (AdventureLootMod.Config.DefaultOptions() == OptionTypes.Extra) {
                switch (type.ordinal()) {
                    case 0: {
                        rawDataList.addAll(AdventureBagDefaults.CommonDefaults);
                        break;
                    }
                    case 1: {
                        rawDataList.addAll(AdventureBagDefaults.RareDefaults);
                        break;
                    }
                    case 2: {
                        rawDataList.addAll(AdventureBagDefaults.EpicDefaults);
                        break;
                    }
                    case 3: {
                        rawDataList.addAll(AdventureBagDefaults.LegendaryDefaults);
                    }
                }
                AdventureLootUtil.Debug("Added Custom Loot-tables to Built-in Loot-tables");
            }
            int entry = 0;
            for (String itemString : rawDataList) {
                ++entry;
                int minAmount = -1;
                int maxAmount = -1;
                String item = "";
                class_2487 nbt = null;
                class_9323 componentMap = null;
                Pattern pattern = Pattern.compile("(\\d+)?(?:-(\\d+))?\\s*([^{]+)(?:\\{(.+)})?");
                Matcher matcher = pattern.matcher(itemString);
                if (matcher.find()) {
                    if (matcher.group(1) != null) {
                        minAmount = Integer.parseInt(matcher.group(1));
                        AdventureLootUtil.Debug("Minimum Amount found, set to " + minAmount);
                    } else {
                        AdventureLootUtil.Debug("No Minimum Amount provided, defaulting to 1");
                    }
                    if (matcher.group(2) != null) {
                        maxAmount = Integer.parseInt(matcher.group(2));
                        AdventureLootUtil.Debug("Maximum Amount found, set to " + maxAmount);
                    } else {
                        maxAmount = minAmount;
                        AdventureLootUtil.Debug("No Maximum Amount provided, defaulting to Minimum Amount");
                    }
                    if (maxAmount < minAmount) {
                        maxAmount = minAmount;
                        AdventureLootUtil.Debug("Maximum Amount was lower than Minimum Amount, reset to Minimum");
                    }
                    item = matcher.group(3).trim();
                    if (matcher.group(4) != null) {
                        AdventureLootUtil.Debug("NBTComponents was found, parsing...");
                        String nbtString = "{" + matcher.group(4) + "}";
                        try {
                            nbt = class_2522.method_67315((String)nbtString);
                            AdventureLootUtil.Debug("Parsed NBTComponents successfully: " + String.valueOf(nbt));
                        }
                        catch (CommandSyntaxException e) {
                            AdventureLootMod.onLog("[NBT Error] Invalid NBT format for " + item + " - " + e.getMessage() + " [Entry " + entry + " - " + type.name() + "] - ENSURE YOU ARE USING 1.20.4 OR BELOW NBT FORMATTING");
                        }
                    }
                }
                if (AdventureLootUtil.isNullOrEmptyOrWhitespace(item)) {
                    AdventureLootMod.onLog("[Null] Invalid Item for " + item + "[Entry " + entry + " - " + type.name() + "]");
                    continue;
                }
                AdventureLootUtil.Debug("Checking Item Registry for provided Item...");
                Optional registryItem = class_7923.field_41178.method_17966(class_2960.method_12829((String)item));
                if (registryItem.isPresent()) {
                    if (nbt != null) {
                        try {
                            componentMap = FuckingComponentUtils.convertToComponentMap(world, ((class_1792)registryItem.get()).method_7854(), nbt);
                            AdventureLootMod.OnDebug("Mapped Components: " + componentMap.toString());
                        }
                        catch (Exception ex) {
                            AdventureLootMod.onLog("[Mapped Component Error] Invalid Component for " + item + " - " + ex.getMessage() + " [Entry " + entry + " - " + type.name() + "] - ENSURE YOU ARE USING 1.20.4 OR BELOW NBT FORMATTING");
                        }
                    }
                    bag.add(new AdventureBag((class_1792)registryItem.get(), minAmount, maxAmount, componentMap));
                    AdventureLootUtil.Debug("Successfully Parsed Item and Generated new Bag Entry");
                    continue;
                }
                AdventureLootMod.onLog("[Not Found] Invalid Item for " + item + "[Entry " + entry + " - " + type.name() + "]");
            }
            return bag;
        }
        catch (Exception ex) {
            AdventureLootMod.onLog("Failed to Get Bag Loot-table using V2, falling back to V1 " + String.valueOf(ex));
            return AdventureLootUtil.GetLoot(type, itemStrings);
        }
    }

    private static List<AdventureBag> GetLoot(AdventureBagTypes type, List<String> itemStrings) {
        ArrayList<AdventureBag> bag = new ArrayList<AdventureBag>();
        ArrayList<String> rawDataList = new ArrayList<String>(itemStrings);
        if (AdventureLootMod.Config.DefaultOptions() == OptionTypes.Extra) {
            switch (type.ordinal()) {
                case 0: {
                    rawDataList.addAll(AdventureBagDefaults.CommonDefaults);
                    break;
                }
                case 1: {
                    rawDataList.addAll(AdventureBagDefaults.RareDefaults);
                    break;
                }
                case 2: {
                    rawDataList.addAll(AdventureBagDefaults.EpicDefaults);
                    break;
                }
                case 3: {
                    rawDataList.addAll(AdventureBagDefaults.LegendaryDefaults);
                }
            }
        }
        int entry = 0;
        for (String itemString : rawDataList) {
            ++entry;
            int minAmount = -1;
            int maxAmount = -1;
            String item = "";
            Pattern pattern = Pattern.compile("(\\d+)?(?:-(\\d+))?\\s*(.*)");
            Matcher matcher = pattern.matcher(itemString);
            if (matcher.find()) {
                if (matcher.group(1) != null) {
                    minAmount = Integer.parseInt(matcher.group(1));
                }
                maxAmount = matcher.group(2) != null ? Integer.parseInt(matcher.group(2)) : minAmount;
                item = matcher.group(3);
            }
            if (AdventureLootUtil.isNullOrEmptyOrWhitespace(item)) {
                AdventureLootMod.onLog("[Null] Invalid Item for " + item + "[Entry " + entry + " - " + type.name() + "]");
                continue;
            }
            Optional registryItem = class_7923.field_41178.method_17966(class_2960.method_12829((String)item));
            if (registryItem.isPresent()) {
                bag.add(new AdventureBag((class_1792)registryItem.get(), minAmount, maxAmount));
                continue;
            }
            AdventureLootMod.onLog("[Not Found] Invalid Item for " + item + "[Entry " + entry + " - " + type.name() + "]");
        }
        return bag;
    }

    public static boolean isNullOrEmptyOrWhitespace(String string) {
        return string == null || string.trim().isEmpty();
    }

    @NotNull
    public static class_1799 getItemStack(List<AdventureBag> lootTable) {
        Random r = new Random();
        AdventureBag randomItem = lootTable.get(r.nextInt(lootTable.size()));
        int amount = 1;
        if (randomItem.minAmount() != -1 && randomItem.item().method_7882() != 1) {
            amount = r.nextInt(Math.min(randomItem.minAmount(), randomItem.item().method_7882()), Math.min(randomItem.maxAmount(), randomItem.item().method_7882()) + 1);
        }
        class_1799 itemStack = new class_1799((class_1935)randomItem.item(), amount);
        if (randomItem.component() != null) {
            itemStack.method_57365(randomItem.component());
        }
        return itemStack;
    }

    public static void Debug(String message) {
        if (AdventureLootMod.Config.Debug()) {
            AdventureLootMod.onLog(message);
        }
    }

    public static enum OptionTypes {
        Default,
        Disabled,
        Extra;

    }

    public static enum AdventureBagTypes {
        Common,
        Rare,
        Epic,
        Legendary;

    }
}

