/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights;

import com.mojang.logging.LogUtils;
import com.uberhelixx.flatlights.FlatLightsClientConfig;
import com.uberhelixx.flatlights.FlatLightsCommonConfig;
import com.uberhelixx.flatlights.client.particle.ModParticles;
import com.uberhelixx.flatlights.client.screen.ModMenuTypes;
import com.uberhelixx.flatlights.common.block.ModBlocks;
import com.uberhelixx.flatlights.common.blockentity.ModBlockEntities;
import com.uberhelixx.flatlights.common.effect.ModEffects;
import com.uberhelixx.flatlights.common.enchantments.ModEnchantments;
import com.uberhelixx.flatlights.common.entity.ModEntityTypes;
import com.uberhelixx.flatlights.common.item.ModItems;
import com.uberhelixx.flatlights.common.item.curio.ModCurios;
import com.uberhelixx.flatlights.common.loot.ModLootModifiers;
import com.uberhelixx.flatlights.common.network.PacketHandler;
import com.uberhelixx.flatlights.common.recipe.ModRecipeTypes;
import com.uberhelixx.flatlights.startup.ClientProxy;
import com.uberhelixx.flatlights.startup.ClientSetup;
import com.uberhelixx.flatlights.startup.IProxy;
import com.uberhelixx.flatlights.startup.ModCreativeTab;
import com.uberhelixx.flatlights.startup.ServerProxy;
import com.uberhelixx.flatlights.startup.registry.ModAttributes;
import com.uberhelixx.flatlights.startup.registry.ModSoundEvents;
import com.uberhelixx.flatlights.util.ColorPairUtils;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="flatlights")
public class FlatLights {
    public static final String MODID = "flatlights";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static IProxy proxy = (IProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);

    public FlatLights() {
        ColorPairUtils.pairUp();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModBlocks.register(modEventBus);
        ModItems.register(modEventBus);
        ModCreativeTab.register(modEventBus);
        ModEntityTypes.register(modEventBus);
        ModSoundEvents.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModRecipeTypes.register(modEventBus);
        ModEffects.register(modEventBus);
        ModEnchantments.register(modEventBus);
        ModCurios.register(modEventBus);
        ModAttributes.register(modEventBus);
        ModLootModifiers.register(modEventBus);
        ModParticles.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)FlatLightsCommonConfig.SPEC, "flatlights-common.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)FlatLightsClientConfig.SPEC, "flatlights-client.toml");
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::doInClient);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        PacketHandler.init();
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    private void doInClient() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerEntityLayers);
    }

    private void preInit(FMLCommonSetupEvent event) {
        proxy.preInit(event);
    }

    private void init(FMLCommonSetupEvent event) {
        proxy.init(event);
    }

    private void postInit(FMLCommonSetupEvent event) {
        proxy.postInit(event);
    }

    public void registerEntityLayers(EntityRenderersEvent.AddLayers event) {
        proxy.registerEntityLayers(event);
    }

    @Mod.EventBusSubscriber(modid="flatlights", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
            ClientSetup.doClientSetup(event);
        }
    }
}

