/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.client.particle;

import java.awt.Color;

public class BasicColorParticleConstructor {
    private Color color;
    private float diameter;
    private float roll;
    private boolean physical;
    private int lifetime;
    private float scaleModifier;

    private static float $default$diameter() {
        return 1.0f;
    }

    private static float $default$roll() {
        return 0.0f;
    }

    private static boolean $default$physical() {
        return false;
    }

    private static int $default$lifetime() {
        return 20;
    }

    private static float $default$scaleModifier() {
        return 1.0f;
    }

    BasicColorParticleConstructor(Color color, float diameter, float roll, boolean physical, int lifetime, float scaleModifier) {
        this.color = color;
        this.diameter = diameter;
        this.roll = roll;
        this.physical = physical;
        this.lifetime = lifetime;
        this.scaleModifier = scaleModifier;
    }

    public static BasicColorParticleConstructorBuilder builder() {
        return new BasicColorParticleConstructorBuilder();
    }

    public Color getColor() {
        return this.color;
    }

    public float getDiameter() {
        return this.diameter;
    }

    public float getRoll() {
        return this.roll;
    }

    public boolean isPhysical() {
        return this.physical;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public float getScaleModifier() {
        return this.scaleModifier;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setDiameter(float diameter) {
        this.diameter = diameter;
    }

    public void setRoll(float roll) {
        this.roll = roll;
    }

    public void setPhysical(boolean physical) {
        this.physical = physical;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public void setScaleModifier(float scaleModifier) {
        this.scaleModifier = scaleModifier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicColorParticleConstructor)) {
            return false;
        }
        BasicColorParticleConstructor other = (BasicColorParticleConstructor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getDiameter(), other.getDiameter()) != 0) {
            return false;
        }
        if (Float.compare(this.getRoll(), other.getRoll()) != 0) {
            return false;
        }
        if (this.isPhysical() != other.isPhysical()) {
            return false;
        }
        if (this.getLifetime() != other.getLifetime()) {
            return false;
        }
        if (Float.compare(this.getScaleModifier(), other.getScaleModifier()) != 0) {
            return false;
        }
        Color this$color = this.getColor();
        Color other$color = other.getColor();
        return !(this$color == null ? other$color != null : !((Object)this$color).equals(other$color));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasicColorParticleConstructor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getDiameter());
        result = result * 59 + Float.floatToIntBits(this.getRoll());
        result = result * 59 + (this.isPhysical() ? 79 : 97);
        result = result * 59 + this.getLifetime();
        result = result * 59 + Float.floatToIntBits(this.getScaleModifier());
        Color $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
        return result;
    }

    public String toString() {
        return "BasicColorParticleConstructor(color=" + this.getColor() + ", diameter=" + this.getDiameter() + ", roll=" + this.getRoll() + ", physical=" + this.isPhysical() + ", lifetime=" + this.getLifetime() + ", scaleModifier=" + this.getScaleModifier() + ")";
    }

    public static class BasicColorParticleConstructorBuilder {
        private boolean diameter$set;
        private float diameter$value;
        private boolean roll$set;
        private float roll$value;
        private boolean physical$set;
        private boolean physical$value;
        private boolean lifetime$set;
        private int lifetime$value;
        private boolean scaleModifier$set;
        private float scaleModifier$value;
        private Color color = new Color(-1, true);

        public BasicColorParticleConstructorBuilder color(int color) {
            this.color = new Color(color, true);
            return this;
        }

        public BasicColorParticleConstructorBuilder color(float r, float g, float b, float a) {
            return this.color(new Color(r, g, b, a).getRGB());
        }

        public BasicColorParticleConstructorBuilder color(float r, float g, float b) {
            return this.color(r, g, b, 1.0f);
        }

        public BasicColorParticleConstructorBuilder color(int r, int g, int b, int a) {
            return this.color((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
        }

        public BasicColorParticleConstructorBuilder color(int r, int g, int b) {
            return this.color(r, g, b, 255);
        }

        BasicColorParticleConstructorBuilder() {
        }

        public BasicColorParticleConstructorBuilder diameter(float diameter) {
            this.diameter$value = diameter;
            this.diameter$set = true;
            return this;
        }

        public BasicColorParticleConstructorBuilder roll(float roll) {
            this.roll$value = roll;
            this.roll$set = true;
            return this;
        }

        public BasicColorParticleConstructorBuilder physical(boolean physical) {
            this.physical$value = physical;
            this.physical$set = true;
            return this;
        }

        public BasicColorParticleConstructorBuilder lifetime(int lifetime) {
            this.lifetime$value = lifetime;
            this.lifetime$set = true;
            return this;
        }

        public BasicColorParticleConstructorBuilder scaleModifier(float scaleModifier) {
            this.scaleModifier$value = scaleModifier;
            this.scaleModifier$set = true;
            return this;
        }

        public BasicColorParticleConstructor build() {
            float diameter$value = this.diameter$value;
            if (!this.diameter$set) {
                diameter$value = BasicColorParticleConstructor.$default$diameter();
            }
            float roll$value = this.roll$value;
            if (!this.roll$set) {
                roll$value = BasicColorParticleConstructor.$default$roll();
            }
            boolean physical$value = this.physical$value;
            if (!this.physical$set) {
                physical$value = BasicColorParticleConstructor.$default$physical();
            }
            int lifetime$value = this.lifetime$value;
            if (!this.lifetime$set) {
                lifetime$value = BasicColorParticleConstructor.$default$lifetime();
            }
            float scaleModifier$value = this.scaleModifier$value;
            if (!this.scaleModifier$set) {
                scaleModifier$value = BasicColorParticleConstructor.$default$scaleModifier();
            }
            return new BasicColorParticleConstructor(this.color, diameter$value, roll$value, physical$value, lifetime$value, scaleModifier$value);
        }

        public String toString() {
            return "BasicColorParticleConstructor.BasicColorParticleConstructorBuilder(color=" + this.color + ", diameter$value=" + this.diameter$value + ", roll$value=" + this.roll$value + ", physical$value=" + this.physical$value + ", lifetime$value=" + this.lifetime$value + ", scaleModifier$value=" + this.scaleModifier$value + ")";
        }
    }
}

