/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.uberhelixx.flatlights.client.particle.BasicColorParticleConstructor;
import com.uberhelixx.flatlights.client.particle.ModParticles;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class BasicColorParticleOptions
implements ParticleOptions {
    private final BasicColorParticleConstructor data;
    public static final Codec<BasicColorParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("color").forGetter(options -> options.getData().getColor().getRGB()), (App)Codec.FLOAT.fieldOf("diameter").forGetter(options -> Float.valueOf(options.getData().getDiameter())), (App)Codec.INT.fieldOf("lifetime").forGetter(options -> options.getData().getLifetime()), (App)Codec.FLOAT.fieldOf("roll").forGetter(options -> Float.valueOf(options.getData().getRoll()))).apply((Applicative)instance, BasicColorParticleOptions::new));
    public static final ParticleOptions.Deserializer<BasicColorParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<BasicColorParticleOptions>(){

        @Nonnull
        public BasicColorParticleOptions fromCommand(@Nonnull ParticleType<BasicColorParticleOptions> particleType, @Nonnull StringReader stringReader) throws CommandSyntaxException {
            stringReader.expect(' ');
            int color = stringReader.readInt();
            stringReader.expect(' ');
            float diameter = stringReader.readFloat();
            stringReader.expect(' ');
            int lifetime = stringReader.readInt();
            stringReader.expect(' ');
            float roll = stringReader.readFloat();
            return new BasicColorParticleOptions(color, diameter, lifetime, roll);
        }

        public BasicColorParticleOptions fromNetwork(@Nonnull ParticleType<BasicColorParticleOptions> type, FriendlyByteBuf buf) {
            int color = buf.readInt();
            float diameter = buf.readFloat();
            int lifetime = buf.readInt();
            float roll = buf.readFloat();
            return new BasicColorParticleOptions(color, diameter, lifetime, roll);
        }
    };

    private BasicColorParticleOptions(int color, float diameter, int lifetime, float roll) {
        this.data = BasicColorParticleConstructor.builder().color(color).diameter(diameter).lifetime(lifetime).roll(roll).build();
    }

    public BasicColorParticleOptions(BasicColorParticleConstructor data) {
        this.data = data;
    }

    @Nonnull
    public ParticleType<BasicColorParticleOptions> m_6012_() {
        return (ParticleType)ModParticles.BASIC_COLOR.get();
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeInt(this.data.getColor().getRGB());
        buf.writeFloat(this.data.getDiameter());
        buf.writeInt(this.data.getLifetime());
        buf.writeFloat(this.data.getRoll());
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %.2f %d %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), this.data.getColor().getRGB(), Float.valueOf(this.data.getDiameter()), this.data.getLifetime(), Float.valueOf(this.data.getRoll()));
    }

    public BasicColorParticleConstructor getData() {
        return this.data;
    }
}

