/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.uberhelixx.flatlights.common.entity.GravityLiftEntity;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GravityLiftRenderer
extends EntityRenderer<GravityLiftEntity> {
    public static final ResourceLocation BEAM = new ResourceLocation("flatlights", "textures/block/gravity_lift/lift.png");
    public static final ResourceLocation LIFT_BASE_MODEL = new ResourceLocation("flatlights", "entity/gravity_lift");
    private static final float BEAM_WIDTH = 0.0625f;

    public GravityLiftRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(GravityLiftEntity pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        GravityLiftRenderer.renderCubeUsingQuads(pEntity, pPartialTick, pPoseStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(GravityLiftEntity gravityLiftEntity) {
        return BEAM;
    }

    public static void renderCubeUsingQuads(GravityLiftEntity gravityLiftBeam, float partialTicks, PoseStack poseStack, MultiBufferSource renderBuffers, int combinedLight) {
        BakedModel liftBaseModel = Minecraft.m_91087_().m_91304_().getModel(LIFT_BASE_MODEL);
        poseStack.m_85836_();
        PoseStack.Pose currentMatrix = poseStack.m_85850_();
        poseStack.m_85837_(-0.5, 0.0, -0.5);
        Color blendColor = Color.WHITE;
        float red = (float)blendColor.getRed() / 255.0f;
        float green = (float)blendColor.getGreen() / 255.0f;
        float blue = (float)blendColor.getBlue() / 255.0f;
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        VertexConsumer vertexBuffer = renderBuffers.m_6299_(RenderType.m_110451_());
        dispatcher.m_110937_().m_111067_(currentMatrix, vertexBuffer, null, liftBaseModel, red, green, blue, combinedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        Vector3d TRANSLATION_OFFSET = new Vector3d(-0.03125, 0.0, -0.03125);
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)(-10 * gravityLiftBeam.f_19797_)));
        poseStack.m_85837_(TRANSLATION_OFFSET.x, TRANSLATION_OFFSET.y, TRANSLATION_OFFSET.z);
        Color BEAM_COLOR = Color.getHSBColor(0.75f, 1.0f, 0.8f);
        if ((double)gravityLiftBeam.f_19797_ > ((double)GravityLiftEntity.SECONDS - 1.5) * 20.0 && gravityLiftBeam.f_19797_ % 5 == 0) {
            BEAM_COLOR = Color.WHITE;
        }
        GravityLiftRenderer.drawCubeQuads(poseStack, renderBuffers, BEAM_COLOR, combinedLight);
        poseStack.m_85849_();
    }

    private static void drawCubeQuads(PoseStack poseStack, MultiBufferSource renderBuffer, Color color, int combinedLight) {
        VertexConsumer vertexBuilderBlockQuads = renderBuffer.m_6299_(RenderType.m_110460_((ResourceLocation)BEAM, (boolean)true));
        Matrix4f matrixPos = poseStack.m_85850_().m_252922_();
        Matrix3f matrixNormal = poseStack.m_85850_().m_252943_();
        Vector2f bottomLeftUV = new Vector2f(0.0f, 4.0f);
        float UVwidth = 1.0f;
        float UVheight = 4.0f;
        float LIFT_HEIGHT = 8.0f;
        Vector3d EAST_FACE_MIDPOINT = new Vector3d(0.0625, 4.0, 0.03125);
        Vector3d WEST_FACE_MIDPOINT = new Vector3d(0.0, 4.0, 0.03125);
        Vector3d NORTH_FACE_MIDPOINT = new Vector3d(0.03125, 4.0, 0.0);
        Vector3d SOUTH_FACE_MIDPOINT = new Vector3d(0.03125, 4.0, 0.0625);
        Vector3d UP_FACE_MIDPOINT = new Vector3d(0.03125, 8.0, 0.03125);
        Vector3d DOWN_FACE_MIDPOINT = new Vector3d(0.03125, 0.0, 0.03125);
        GravityLiftRenderer.addFace(Direction.EAST, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, EAST_FACE_MIDPOINT, 0.0625f, 8.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        GravityLiftRenderer.addFace(Direction.WEST, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, WEST_FACE_MIDPOINT, 0.0625f, 8.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        GravityLiftRenderer.addFace(Direction.NORTH, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, NORTH_FACE_MIDPOINT, 0.0625f, 8.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        GravityLiftRenderer.addFace(Direction.SOUTH, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, SOUTH_FACE_MIDPOINT, 0.0625f, 8.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        GravityLiftRenderer.addFace(Direction.UP, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, UP_FACE_MIDPOINT, 0.0625f, 0.0625f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        GravityLiftRenderer.addFace(Direction.DOWN, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, DOWN_FACE_MIDPOINT, 0.0625f, 0.0625f, bottomLeftUV, UVwidth, UVheight, combinedLight);
    }

    private static void addFace(Direction whichFace, Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer renderBuffer, Color color, Vector3d centrePos, float width, float height, Vector2f bottomLeftUV, float texUwidth, float texVheight, int lightmapValue) {
        Vector3f leftToRightDirection;
        Vector3f bottomToTopDirection = switch (whichFace) {
            case Direction.NORTH -> {
                leftToRightDirection = new Vector3f(-1.0f, 0.0f, 0.0f);
                yield new Vector3f(0.0f, 1.0f, 0.0f);
            }
            case Direction.SOUTH -> {
                leftToRightDirection = new Vector3f(1.0f, 0.0f, 0.0f);
                yield new Vector3f(0.0f, 1.0f, 0.0f);
            }
            case Direction.EAST -> {
                leftToRightDirection = new Vector3f(0.0f, 0.0f, -1.0f);
                yield new Vector3f(0.0f, 1.0f, 0.0f);
            }
            case Direction.WEST -> {
                leftToRightDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                yield new Vector3f(0.0f, 1.0f, 0.0f);
            }
            case Direction.UP -> {
                leftToRightDirection = new Vector3f(-1.0f, 0.0f, 0.0f);
                yield new Vector3f(0.0f, 0.0f, 1.0f);
            }
            case Direction.DOWN -> {
                leftToRightDirection = new Vector3f(1.0f, 0.0f, 0.0f);
                yield new Vector3f(0.0f, 0.0f, 1.0f);
            }
            default -> {
                leftToRightDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                yield new Vector3f(0.0f, 1.0f, 0.0f);
            }
        };
        leftToRightDirection.mul(0.5f * width);
        bottomToTopDirection.mul(0.5f * height);
        Vector3f bottomLeftPos = new Vector3f((float)centrePos.x, (float)centrePos.y, (float)centrePos.z);
        bottomLeftPos.sub((Vector3fc)leftToRightDirection);
        bottomLeftPos.sub((Vector3fc)bottomToTopDirection);
        Vector3f bottomRightPos = new Vector3f((float)centrePos.x, (float)centrePos.y, (float)centrePos.z);
        bottomRightPos.add((Vector3fc)leftToRightDirection);
        bottomRightPos.sub((Vector3fc)bottomToTopDirection);
        Vector3f topRightPos = new Vector3f((float)centrePos.x, (float)centrePos.y, (float)centrePos.z);
        topRightPos.add((Vector3fc)leftToRightDirection);
        topRightPos.add((Vector3fc)bottomToTopDirection);
        Vector3f topLeftPos = new Vector3f((float)centrePos.x, (float)centrePos.y, (float)centrePos.z);
        topLeftPos.sub((Vector3fc)leftToRightDirection);
        topLeftPos.add((Vector3fc)bottomToTopDirection);
        Vector2f bottomLeftUVpos = new Vector2f(bottomLeftUV.x, bottomLeftUV.y);
        Vector2f bottomRightUVpos = new Vector2f(bottomLeftUV.x + texUwidth, bottomLeftUV.y);
        Vector2f topLeftUVpos = new Vector2f(bottomLeftUV.x + texUwidth, bottomLeftUV.y + texVheight);
        Vector2f topRightUVpos = new Vector2f(bottomLeftUV.x, bottomLeftUV.y + texVheight);
        Vector3f normalVector = whichFace.m_253071_();
        GravityLiftRenderer.addQuad(matrixPos, matrixNormal, renderBuffer, bottomLeftPos, bottomRightPos, topRightPos, topLeftPos, bottomLeftUVpos, bottomRightUVpos, topLeftUVpos, topRightUVpos, normalVector, color, lightmapValue);
    }

    private static void addQuad(Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer renderBuffer, Vector3f blpos, Vector3f brpos, Vector3f trpos, Vector3f tlpos, Vector2f blUVpos, Vector2f brUVpos, Vector2f trUVpos, Vector2f tlUVpos, Vector3f normalVector, Color color, int lightmapValue) {
        GravityLiftRenderer.addQuadVertex(matrixPos, matrixNormal, renderBuffer, blpos, blUVpos, normalVector, color, lightmapValue);
        GravityLiftRenderer.addQuadVertex(matrixPos, matrixNormal, renderBuffer, brpos, brUVpos, normalVector, color, lightmapValue);
        GravityLiftRenderer.addQuadVertex(matrixPos, matrixNormal, renderBuffer, trpos, trUVpos, normalVector, color, lightmapValue);
        GravityLiftRenderer.addQuadVertex(matrixPos, matrixNormal, renderBuffer, tlpos, tlUVpos, normalVector, color, lightmapValue);
    }

    private static void addQuadVertex(Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer renderBuffer, Vector3f pos, Vector2f texUV, Vector3f normalVector, Color color, int lightmapValue) {
        renderBuffer.m_252986_(matrixPos, pos.x(), pos.y(), pos.z()).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_7421_(texUV.x, texUV.y).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmapValue).m_252939_(matrixNormal, normalVector.x(), normalVector.y(), normalVector.z()).m_5752_();
    }
}

