/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.uberhelixx.flatlights.common.capability.ModCapabilities;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class RisingHeatEffectRenderer
extends RenderLayer<LivingEntity, EntityModel<LivingEntity>> {
    ResourceLocation HEATED_LAYER = new ResourceLocation("flatlights", "textures/models/power_layers/rising_heat_layer.png");

    public RisingHeatEffectRenderer(RenderLayerParent<LivingEntity, EntityModel<LivingEntity>> pRenderer) {
        super(pRenderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int pPackedLight, LivingEntity livingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (ModCapabilities.getHeatedState(livingEntity).isPresent()) {
            ModCapabilities.getHeatedState(livingEntity).ifPresent(heated -> {
                if (heated.isHeated()) {
                    float tickTime = (float)livingEntity.f_19797_ + pPartialTicks;
                    EntityModel entityModel = this.m_117386_();
                    entityModel.m_6839_((Entity)livingEntity, pLimbSwing, pLimbSwingAmount, pPartialTicks);
                    this.m_117386_().m_102624_(entityModel);
                    VertexConsumer ivertexbuilder = multiBufferSource.m_6299_(RenderType.m_110436_((ResourceLocation)this.layerTexture(), (float)this.layerPosition(tickTime), (float)(tickTime * 0.01f)));
                    entityModel.m_6973_((Entity)livingEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
                    float rgbChannels = 0.5f + 0.35f * Mth.m_14089_((float)(tickTime / 5.0f));
                    entityModel.m_7695_(poseStack, ivertexbuilder, pPackedLight, OverlayTexture.f_118083_, rgbChannels, rgbChannels, rgbChannels, 1.0f);
                }
            });
        }
    }

    private ResourceLocation layerTexture() {
        return this.HEATED_LAYER;
    }

    private float layerPosition(float f) {
        return Mth.m_14031_((float)(f * 0.02f)) * 3.0f;
    }
}

