/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.client.renderer.player;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.uberhelixx.flatlights.common.item.curio.CurioUtils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class DragonSphereRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public static final ResourceLocation INNER_SPHERE = new ResourceLocation("flatlights", "textures/block/inner_sphere/inner_sphere.png");
    public static final ResourceLocation INNER_SPHERE_MODEL = new ResourceLocation("flatlights", "entity/inner_sphere_wrapper");
    public static final ResourceLocation OUTER_SPHERE = new ResourceLocation("flatlights", "textures/block/outer_sphere/outer_sphere.png");
    public static final ResourceLocation OUTER_SPHERE_MODEL = new ResourceLocation("flatlights", "entity/outer_sphere_wrapper");

    public DragonSphereRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> pRenderer) {
        super(pRenderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int pPackedLight, AbstractClientPlayer abstractClientPlayer, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        ItemStack curio;
        boolean playerInfo;
        boolean bl = playerInfo = Minecraft.m_91087_().m_91403_().m_104949_(abstractClientPlayer.m_20148_()) != null;
        if (playerInfo && !abstractClientPlayer.m_20145_() && (curio = CurioUtils.getCurioFromSlot((Player)abstractClientPlayer, "flatlights.curios.cube")) != null) {
            CompoundTag tag = curio.m_41783_();
            boolean toggled = false;
            if (tag != null && tag.m_128441_("flatlights.curioSetToggle")) {
                toggled = tag.m_128471_("flatlights.curioSetToggle");
            }
            double pY_outer_sphere = -1.25 + 0.1 * Math.sin((double)pAgeInTicks * 0.1);
            double pY_inner_sphere = -3.15 + 0.1 * Math.sin((double)pAgeInTicks * 0.1);
            if (CurioUtils.correctSetEffect((Player)abstractClientPlayer, "flatlights.curioset.dragon") && toggled) {
                BakedModel innerSphereModel = Minecraft.m_91087_().m_91304_().getModel(INNER_SPHERE_MODEL);
                poseStack.m_85836_();
                PoseStack.Pose currentMatrix = poseStack.m_85850_();
                float MODEL_SIZE_IN_ORIGINAL_COORDINATES = 1.0f;
                float TARGET_SIZE_WHEN_RENDERED = 0.1f;
                float SCALE_FACTOR = 0.1f;
                poseStack.m_85841_(0.1f, 0.1f, 0.1f);
                poseStack.m_85837_(-5.0, pY_inner_sphere, 5.0);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-1.0f * pAgeInTicks));
                float flicker = (float)(0.1 * Math.sin(pAgeInTicks * 2.0f));
                poseStack.m_85841_(1.0f - flicker, 1.0f - flicker, 1.0f - flicker);
                Color blendColour = Color.WHITE;
                float red = (float)blendColour.getRed() / 255.0f;
                float green = (float)blendColour.getGreen() / 255.0f;
                float blue = (float)blendColour.getBlue() / 255.0f;
                BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                VertexConsumer vertexBuffer = multiBufferSource.m_6299_(RenderType.m_110466_());
                dispatcher.m_110937_().m_111067_(currentMatrix, vertexBuffer, null, innerSphereModel, red, green, blue, pPackedLight, OverlayTexture.f_118083_);
                poseStack.m_85849_();
                BakedModel outerSphereModel = Minecraft.m_91087_().m_91304_().getModel(OUTER_SPHERE_MODEL);
                poseStack.m_85836_();
                PoseStack.Pose outCurrentMatrix = poseStack.m_85850_();
                float OUT_MODEL_SIZE_IN_ORIGINAL_COORDINATES = 1.0f;
                float OUT_TARGET_SIZE_WHEN_RENDERED = 0.25f;
                float OUT_SCALE_FACTOR = 0.25f;
                poseStack.m_85841_(0.25f, 0.25f, 0.25f);
                poseStack.m_85837_(-2.0, pY_outer_sphere, 2.0);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-1.5f * pAgeInTicks));
                Color outBlendColour = Color.MAGENTA;
                float outRed = (float)((double)((float)outBlendColour.getRed() / 255.0f) * Math.cos((double)pAgeInTicks * 0.1));
                float outGreen = (float)outBlendColour.getGreen() / 255.0f;
                float outBlue = (float)outBlendColour.getBlue() / 255.0f;
                BlockRenderDispatcher outDispatcher = Minecraft.m_91087_().m_91289_();
                VertexConsumer outVertexBuffer = multiBufferSource.m_6299_(RenderType.m_110466_());
                outDispatcher.m_110937_().m_111067_(outCurrentMatrix, outVertexBuffer, null, outerSphereModel, outRed, outGreen, outBlue, pPackedLight, OverlayTexture.f_118083_);
                poseStack.m_85849_();
            } else if (CurioUtils.correctSetEffect((Player)abstractClientPlayer, "flatlights.curioset.dragon") && !toggled) {
                BakedModel innerSphereModel = Minecraft.m_91087_().m_91304_().getModel(INNER_SPHERE_MODEL);
                poseStack.m_85836_();
                PoseStack.Pose currentMatrix = poseStack.m_85850_();
                float MODEL_SIZE_IN_ORIGINAL_COORDINATES = 1.0f;
                float TARGET_SIZE_WHEN_RENDERED = 0.1f;
                float SCALE_FACTOR = 0.1f;
                poseStack.m_85841_(0.1f, 0.1f, 0.1f);
                poseStack.m_85837_(-5.0, pY_inner_sphere, 5.0);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-1.0f * pAgeInTicks));
                float flicker = (float)(0.05 * Math.sin((double)pAgeInTicks * 0.1));
                poseStack.m_85841_(1.0f - flicker, 1.0f - flicker, 1.0f - flicker);
                Color blendColour = Color.WHITE;
                float red = (float)blendColour.getRed() / 255.0f;
                float green = (float)blendColour.getGreen() / 255.0f;
                float blue = (float)blendColour.getBlue() / 255.0f;
                BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                VertexConsumer vertexBuffer = multiBufferSource.m_6299_(RenderType.m_110451_());
                dispatcher.m_110937_().m_111067_(currentMatrix, vertexBuffer, null, innerSphereModel, red, green, blue, pPackedLight, OverlayTexture.f_118083_);
                poseStack.m_85849_();
                BakedModel outerSphereModel = Minecraft.m_91087_().m_91304_().getModel(OUTER_SPHERE_MODEL);
                poseStack.m_85836_();
                PoseStack.Pose outCurrentMatrix = poseStack.m_85850_();
                float OUT_MODEL_SIZE_IN_ORIGINAL_COORDINATES = 1.0f;
                float OUT_TARGET_SIZE_WHEN_RENDERED = 0.25f;
                float OUT_SCALE_FACTOR = 0.25f;
                poseStack.m_85841_(0.25f, 0.25f, 0.25f);
                poseStack.m_85837_(-2.0, pY_outer_sphere, 2.0);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-1.5f * pAgeInTicks));
                Color outBlendColour = Color.WHITE;
                float outRed = (float)outBlendColour.getRed() / 255.0f;
                float outGreen = (float)outBlendColour.getGreen() / 255.0f;
                float outBlue = (float)((double)((float)outBlendColour.getBlue() / 255.0f) + 0.5 * Math.cos((double)pAgeInTicks * 0.05));
                BlockRenderDispatcher outDispatcher = Minecraft.m_91087_().m_91289_();
                VertexConsumer outVertexBuffer = multiBufferSource.m_6299_(RenderType.m_110466_());
                outDispatcher.m_110937_().m_111067_(outCurrentMatrix, outVertexBuffer, null, outerSphereModel, outRed, outGreen, outBlue, pPackedLight, OverlayTexture.f_118083_);
                poseStack.m_85849_();
            }
        }
    }
}

