/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.client.renderer.player;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.uberhelixx.flatlights.client.renderer.ModRenderTypes;
import com.uberhelixx.flatlights.common.item.ModItems;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.data.ModelData;

public class PrismaticBladeMk2Renderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    ResourceLocation DAMAGE_LAYER = new ResourceLocation("flatlights", "textures/models/power_layers/mk2_damage_mode_layer.png");
    ResourceLocation BLADE_LAYER = new ResourceLocation("flatlights", "textures/models/power_layers/blade.png");
    public static final ResourceLocation SPHERE_MODEL = new ResourceLocation("flatlights", "entity/void_sphere_wrapper");
    public static final ResourceLocation MK2_PROJECTILE_MODEL = new ResourceLocation("flatlights", "item/prismatic_blademk2");
    public static final ResourceLocation MK2_PROJECTILE = new ResourceLocation("flatlights", "textures/item/prismatic_blademk2/main_blade.png");

    public PrismaticBladeMk2Renderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> pRenderer) {
        super(pRenderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int pPackedLight, AbstractClientPlayer abstractClientPlayer, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        boolean playerInfo;
        Item item;
        boolean notUsing = false;
        Inventory inv = abstractClientPlayer.m_150109_();
        CompoundTag bladeTag = new CompoundTag();
        for (ItemStack itemStack : inv.f_35974_) {
            item = itemStack.m_41720_();
            if (item != ModItems.PRISMATIC_BLADEMK2.get()) continue;
            notUsing = true;
            bladeTag = itemStack.m_41783_() != null ? itemStack.m_41783_() : new CompoundTag();
        }
        if (inv.m_36056_().m_41720_() == ModItems.PRISMATIC_BLADEMK2.get()) {
            notUsing = false;
            bladeTag = inv.m_36056_().m_41783_() != null ? inv.m_36056_().m_41783_() : new CompoundTag();
        }
        for (ItemStack itemStack : inv.f_35976_) {
            item = itemStack.m_41720_();
            if (item != ModItems.PRISMATIC_BLADEMK2.get()) continue;
            notUsing = false;
            bladeTag = itemStack.m_41783_() != null ? itemStack.m_41783_() : new CompoundTag();
        }
        boolean bl = playerInfo = Minecraft.m_91087_().m_91403_().m_104949_(abstractClientPlayer.m_20148_()) != null;
        if (playerInfo && !abstractClientPlayer.m_20145_() && notUsing) {
            poseStack.m_85836_();
            ((PlayerModel)this.m_117386_()).f_102810_.m_104299_(poseStack);
            poseStack.m_85837_(0.13, 1.15, 0.2);
            poseStack.m_85841_(0.8f, -0.8f, -0.8f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(240.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            Minecraft.m_91087_().m_91291_().m_269491_((LivingEntity)abstractClientPlayer, ((Item)ModItems.PRISMATIC_BLADEMK2.get()).m_7968_(), ItemDisplayContext.NONE, false, poseStack, multiBufferSource, abstractClientPlayer.m_9236_(), 0xF000F0, OverlayTexture.f_118083_, abstractClientPlayer.m_19879_());
            poseStack.m_85849_();
        }
        if (bladeTag.m_128441_("flatlights.mode")) {
            int bladeMode = bladeTag.m_128451_("flatlights.mode");
            if (bladeMode == 1) {
                float tickTime = (float)abstractClientPlayer.f_19797_ + pPartialTicks;
                EntityModel playerModel = this.m_117386_();
                playerModel.m_6839_((Entity)abstractClientPlayer, pLimbSwing, pLimbSwingAmount, pPartialTicks);
                ((PlayerModel)this.m_117386_()).m_102624_(playerModel);
                VertexConsumer ivertexbuilder = multiBufferSource.m_6299_(RenderType.m_110436_((ResourceLocation)this.layerTexture(), (float)this.layerPosition(tickTime), (float)(tickTime * 0.01f)));
                playerModel.m_6973_((Entity)abstractClientPlayer, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
                float rgbChannels = 0.5f;
                playerModel.m_7695_(poseStack, ivertexbuilder, pPackedLight, OverlayTexture.f_118083_, (float)((double)rgbChannels + 0.49 * (double)Mth.m_14089_((float)(tickTime / 10.0f))), rgbChannels, rgbChannels, 1.0f);
            } else if (bladeMode == 2) {
                BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                int swords = bladeTag.m_128451_("flatlights.tier");
                this.renderBladeOrbit(poseStack, multiBufferSource, pPackedLight, pAgeInTicks, dispatcher, swords);
            }
        }
    }

    private float layerPosition(float f) {
        return f * 0.015f;
    }

    private ResourceLocation layerTexture() {
        return this.DAMAGE_LAYER;
    }

    private ResourceLocation bladeLayerTexture() {
        return this.BLADE_LAYER;
    }

    private void renderBladeOrbit(PoseStack ms, MultiBufferSource buffers, int pPackedLight, float ageInTicks, BlockRenderDispatcher dispatcher, int swordCount) {
        int i;
        Minecraft mc = Minecraft.m_91087_();
        BakedModel mk2ProjectileModel = mc.m_91304_().getModel(MK2_PROJECTILE_MODEL);
        int totalSwords = swordCount > 0 ? swordCount : 3;
        float radius = 0.65f;
        float speedMulti = 3.0f;
        boolean horizontal = false;
        float scale = 0.65f;
        float[] angles = new float[totalSwords];
        float anglePer = 360.0f / (float)totalSwords;
        float totalAngle = 0.0f;
        for (i = 0; i < angles.length; ++i) {
            angles[i] = totalAngle += anglePer;
        }
        for (i = 0; i < angles.length; ++i) {
            ms.m_85836_();
            ms.m_85841_(scale, -scale, -scale);
            ms.m_252781_(Axis.f_252436_.m_252977_(angles[i] + ageInTicks * speedMulti));
            ms.m_252880_(radius, -0.75f, radius);
            ms.m_85837_(0.0, 0.075 * Math.sin((ageInTicks + (float)(i * 10)) / 5.0f), 0.0);
            if (!horizontal) {
                ms.m_252781_(Axis.f_252436_.m_252977_(45.0f));
                ms.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            } else {
                ms.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            }
            PoseStack.Pose currentPose = ms.m_85850_();
            Color blendColor = Color.BLUE;
            float red = (float)blendColor.getRed() / 255.0f;
            float green = (float)blendColor.getGreen() / 255.0f;
            float blue = (float)blendColor.getBlue() / 255.0f;
            VertexConsumer shaderBuffer = !ModRenderTypes.isOculusPresent() ? buffers.m_6299_(ModRenderTypes.SPACE) : buffers.m_6299_(RenderType.m_110436_((ResourceLocation)this.bladeLayerTexture(), (float)this.layerPosition(ageInTicks), (float)(ageInTicks * 0.01f)));
            dispatcher.m_110937_().renderModel(currentPose, shaderBuffer, null, mk2ProjectileModel, red, green, blue, pPackedLight, OverlayTexture.f_118083_, ModelData.EMPTY, RenderType.m_110458_((ResourceLocation)MK2_PROJECTILE));
            ms.m_85849_();
        }
    }

    private void renderSphereOrbit(PoseStack poseStack, MultiBufferSource multiBufferSource, int pPackedLight, AbstractClientPlayer abstractClientPlayer, float pAgeInTicks, BlockRenderDispatcher dispatcher) {
        BakedModel sphereModel = Minecraft.m_91087_().m_91304_().getModel(SPHERE_MODEL);
        float MODEL_SIZE_IN_ORIGINAL_COORDINATES = 1.0f;
        float TARGET_SIZE_WHEN_RENDERED = 0.1f;
        float SCALE_FACTOR = 0.1f;
        float RADIUS = 5.0f;
        float SPEED_MULTI = 5.0f;
        int BALLS = 3;
        for (int i = 0; i < 3; ++i) {
            poseStack.m_85836_();
            PoseStack.Pose currentMatrix = poseStack.m_85850_();
            poseStack.m_85841_(0.1f, 0.1f, 0.1f);
            float vibe = (float)(1.0 + 0.15 * Math.sin((pAgeInTicks + (float)(i * 10)) / 5.0f));
            poseStack.m_252880_(0.0f, 3.0f, 0.0f);
            poseStack.m_252781_(Axis.f_252393_.m_252977_(120.0f * (float)i));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(pAgeInTicks * 5.0f + (float)(i * 75)));
            poseStack.m_252880_(5.0f, 0.0f, 5.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)(-1 * abstractClientPlayer.f_19797_)));
            poseStack.m_85841_(vibe, vibe, vibe);
            Color blendColour = Color.WHITE;
            float red = (float)blendColour.getRed() / 255.0f;
            float green = (float)blendColour.getGreen() / 255.0f;
            float blue = (float)blendColour.getBlue() / 255.0f;
            VertexConsumer vertexBuffer = multiBufferSource.m_6299_(RenderType.m_110451_());
            dispatcher.m_110937_().m_111067_(currentMatrix, vertexBuffer, null, sphereModel, red, green, blue, pPackedLight, OverlayTexture.f_118083_);
            poseStack.m_85849_();
        }
    }
}

