/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.block.light;

import com.uberhelixx.flatlights.FlatLightsCommonConfig;
import java.util.List;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HorizontalEdgeBlock
extends Block
implements SimpleWaterloggedBlock {
    private final double thickness;
    static final float DESTROY_TIME = 0.4f;
    static final float EXPLOSION_RESISTANCE = 1.0E8f;
    public VoxelShape NORTH;
    public VoxelShape SOUTH;
    public VoxelShape WEST;
    public VoxelShape EAST;
    public VoxelShape NORTH_TOP;
    public VoxelShape SOUTH_TOP;
    public VoxelShape WEST_TOP;
    public VoxelShape EAST_TOP;
    public static final BooleanProperty NORTH_ADJ = BooleanProperty.m_61465_((String)"north_adj");
    public static final BooleanProperty SOUTH_ADJ = BooleanProperty.m_61465_((String)"south_adj");
    public static final BooleanProperty EAST_ADJ = BooleanProperty.m_61465_((String)"east_adj");
    public static final BooleanProperty WEST_ADJ = BooleanProperty.m_61465_((String)"west_adj");
    public static final BooleanProperty PLACED_TOP = BooleanProperty.m_61465_((String)"placed_top");
    public static final IntegerProperty FACING_INDEX = IntegerProperty.m_61631_((String)"facing_index", (int)0, (int)3);

    public HorizontalEdgeBlock(ToIntFunction<BlockState> lightLevel, double thickness) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60955_().m_60991_(HorizontalEdgeBlock::isEmissive).m_60913_(0.4f, 1.0E8f).m_60953_(lightLevel).m_60918_(SoundType.f_56744_));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
        this.thickness = thickness;
        this.WEST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)thickness, (double)thickness, (double)16.0);
        this.EAST = Block.m_49796_((double)(16.0 - thickness), (double)0.0, (double)0.0, (double)16.0, (double)thickness, (double)16.0);
        this.SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)(16.0 - thickness), (double)16.0, (double)thickness, (double)16.0);
        this.NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)thickness, (double)thickness);
        this.SOUTH_TOP = Block.m_49796_((double)0.0, (double)(16.0 - thickness), (double)(16.0 - thickness), (double)16.0, (double)16.0, (double)16.0);
        this.NORTH_TOP = Block.m_49796_((double)0.0, (double)(16.0 - thickness), (double)0.0, (double)16.0, (double)16.0, (double)thickness);
        this.EAST_TOP = Block.m_49796_((double)(16.0 - thickness), (double)(16.0 - thickness), (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        this.WEST_TOP = Block.m_49796_((double)0.0, (double)(16.0 - thickness), (double)0.0, (double)thickness, (double)16.0, (double)16.0);
    }

    private static boolean isEmissive(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        if (((Boolean)FlatLightsCommonConfig.entityDamageableBlocks.get()).booleanValue()) {
            MutableComponent mobDamageableTooltip = Component.m_237113_((String)"Mob Destructible: ").m_130946_("TRUE").m_130940_(ChatFormatting.RED);
            pTooltip.add((Component)mobDamageableTooltip);
        }
        MutableComponent tooltipTextComp = Component.m_237113_((String)"Follows along the side of solid blocks.").m_130940_(ChatFormatting.GRAY);
        pTooltip.add((Component)tooltipTextComp);
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        return (Boolean)FlatLightsCommonConfig.entityDamageableBlocks.get();
    }

    private boolean checkSides(BlockPlaceContext context, Direction direction) {
        BlockPos pos = context.m_8083_().m_121945_(direction);
        return HorizontalEdgeBlock.m_49863_((LevelReader)context.m_43725_(), (BlockPos)pos, (Direction)direction.m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{BlockStateProperties.f_61362_, FACING_INDEX, PLACED_TOP, NORTH_ADJ, SOUTH_ADJ, EAST_ADJ, WEST_ADJ});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level worldIn = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction direction = context.m_43719_();
        boolean waterlogged = worldIn.m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(waterlogged))).m_61124_((Property)FACING_INDEX, (Comparable)Integer.valueOf(context.m_8125_().m_122416_()))).m_61124_((Property)NORTH_ADJ, (Comparable)Boolean.valueOf(this.checkSides(context, Direction.NORTH)))).m_61124_((Property)SOUTH_ADJ, (Comparable)Boolean.valueOf(this.checkSides(context, Direction.SOUTH)))).m_61124_((Property)EAST_ADJ, (Comparable)Boolean.valueOf(this.checkSides(context, Direction.EAST)))).m_61124_((Property)WEST_ADJ, (Comparable)Boolean.valueOf(this.checkSides(context, Direction.WEST)))).m_61124_((Property)PLACED_TOP, (Comparable)Boolean.valueOf(direction == Direction.DOWN || direction != Direction.UP && context.m_43720_().f_82480_ - (double)pos.m_123342_() > 0.5));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShape directionShape;
        int facing = (Integer)pState.m_61143_((Property)FACING_INDEX);
        switch (facing) {
            case 0: {
                directionShape = this.SOUTH;
                if (((Boolean)pState.m_61143_((Property)NORTH_ADJ)).booleanValue()) {
                    directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.NORTH);
                }
                if (((Boolean)pState.m_61143_((Property)EAST_ADJ)).booleanValue()) {
                    directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.EAST);
                }
                if (((Boolean)pState.m_61143_((Property)WEST_ADJ)).booleanValue()) {
                    directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.WEST);
                }
                if (!((Boolean)pState.m_61143_((Property)PLACED_TOP)).booleanValue()) break;
                directionShape = this.SOUTH_TOP;
                if (((Boolean)pState.m_61143_((Property)NORTH_ADJ)).booleanValue()) {
                    directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.NORTH_TOP);
                }
                if (((Boolean)pState.m_61143_((Property)EAST_ADJ)).booleanValue()) {
                    directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.EAST_TOP);
                }
                if (!((Boolean)pState.m_61143_((Property)WEST_ADJ)).booleanValue()) break;
                directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.WEST_TOP);
                break;
            }
            default: {
                directionShape = this.WEST;
                if (((Boolean)pState.m_61143_((Property)NORTH_ADJ)).booleanValue()) {
                    directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.NORTH);
                }
                if (((Boolean)pState.m_61143_((Property)SOUTH_ADJ)).booleanValue()) {
                    directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.SOUTH);
                }
                if (((Boolean)pState.m_61143_((Property)EAST_ADJ)).booleanValue()) {
                    directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.EAST);
                }
                if (!((Boolean)pState.m_61143_((Property)PLACED_TOP)).booleanValue()) break;
                directionShape = this.WEST_TOP;
                if (((Boolean)pState.m_61143_((Property)NORTH_ADJ)).booleanValue()) {
                    directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.NORTH_TOP);
                }
                if (((Boolean)pState.m_61143_((Property)SOUTH_ADJ)).booleanValue()) {
                    directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.SOUTH_TOP);
                }
                if (!((Boolean)pState.m_61143_((Property)EAST_ADJ)).booleanValue()) break;
                directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.EAST_TOP);
                break;
            }
            case 2: {
                directionShape = this.NORTH;
                if (((Boolean)pState.m_61143_((Property)SOUTH_ADJ)).booleanValue()) {
                    directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.SOUTH);
                }
                if (((Boolean)pState.m_61143_((Property)EAST_ADJ)).booleanValue()) {
                    directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.EAST);
                }
                if (((Boolean)pState.m_61143_((Property)WEST_ADJ)).booleanValue()) {
                    directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.WEST);
                }
                if (!((Boolean)pState.m_61143_((Property)PLACED_TOP)).booleanValue()) break;
                directionShape = this.NORTH_TOP;
                if (((Boolean)pState.m_61143_((Property)SOUTH_ADJ)).booleanValue()) {
                    directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.SOUTH_TOP);
                }
                if (((Boolean)pState.m_61143_((Property)EAST_ADJ)).booleanValue()) {
                    directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.EAST_TOP);
                }
                if (!((Boolean)pState.m_61143_((Property)WEST_ADJ)).booleanValue()) break;
                directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.WEST_TOP);
                break;
            }
            case 3: {
                directionShape = this.EAST;
                if (((Boolean)pState.m_61143_((Property)NORTH_ADJ)).booleanValue()) {
                    directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.NORTH);
                }
                if (((Boolean)pState.m_61143_((Property)SOUTH_ADJ)).booleanValue()) {
                    directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.SOUTH);
                }
                if (((Boolean)pState.m_61143_((Property)WEST_ADJ)).booleanValue()) {
                    directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.WEST);
                }
                if (!((Boolean)pState.m_61143_((Property)PLACED_TOP)).booleanValue()) break;
                directionShape = this.EAST_TOP;
                if (((Boolean)pState.m_61143_((Property)NORTH_ADJ)).booleanValue()) {
                    directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.NORTH_TOP);
                }
                if (((Boolean)pState.m_61143_((Property)SOUTH_ADJ)).booleanValue()) {
                    directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.SOUTH_TOP);
                }
                if (!((Boolean)pState.m_61143_((Property)WEST_ADJ)).booleanValue()) break;
                directionShape = Shapes.m_83110_((VoxelShape)directionShape, (VoxelShape)this.WEST_TOP);
            }
        }
        return directionShape;
    }

    public boolean m_7420_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }

    public boolean m_6044_(@Nonnull BlockGetter pLevel, @Nonnull BlockPos pPos, @Nonnull BlockState pState, @Nonnull Fluid pFluid) {
        return true;
    }

    @Nonnull
    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }
}

