/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.capability;

import com.uberhelixx.flatlights.common.capability.EntangledState;
import com.uberhelixx.flatlights.common.capability.IEntangled;
import com.uberhelixx.flatlights.common.capability.ModCapabilities;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntangledStateAttacher {
    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        EntangledStateProvider provider = new EntangledStateProvider();
        event.addCapability(EntangledStateProvider.ID, (ICapabilityProvider)provider);
    }

    public static class EntangledStateProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        public static final ResourceLocation ID = new ResourceLocation("flatlights", "entangled_state");
        private EntangledState entangledState = new EntangledState();
        private final LazyOptional<IEntangled> optionalData = LazyOptional.of(() -> this.entangledState);

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction direction) {
            return ModCapabilities.ENTANGLED_CAPABILITY.orEmpty(capability, this.optionalData);
        }

        void invalidate() {
            this.optionalData.invalidate();
        }

        public CompoundTag serializeNBT() {
            return this.entangledState.serializeNBT();
        }

        public void deserializeNBT(CompoundTag tag) {
            this.entangledState.deserializeNBT(tag);
        }
    }
}

