/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.capability;

import com.uberhelixx.flatlights.common.capability.EntangledStateAttacher;
import com.uberhelixx.flatlights.common.capability.IEntangled;
import com.uberhelixx.flatlights.common.capability.IPlayerTracker;
import com.uberhelixx.flatlights.common.capability.IRisingHeat;
import com.uberhelixx.flatlights.common.capability.PlayerTrackerCap;
import com.uberhelixx.flatlights.common.capability.RisingHeatStateAttacher;
import com.uberhelixx.flatlights.common.effect.ModEffects;
import com.uberhelixx.flatlights.common.network.PacketHandler;
import com.uberhelixx.flatlights.common.network.packets.PacketEntangledUpdate;
import com.uberhelixx.flatlights.common.network.packets.PacketSyncPlayerCap;
import com.uberhelixx.flatlights.util.MiscUtils;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

public class ModCapabilities {
    public static final Capability<IEntangled> ENTANGLED_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IEntangled>(){});
    public static final Capability<IRisingHeat> RISING_HEAT_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IRisingHeat>(){});
    public static final Capability<IPlayerTracker> PLAYER_TRACKER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerTracker>(){});
    public static final Direction DEFAULT_FACING = null;

    public static LazyOptional<IEntangled> getEntangledState(LivingEntity entity) {
        if (entity == null) {
            return LazyOptional.empty();
        }
        return entity.getCapability(ENTANGLED_CAPABILITY);
    }

    public static LazyOptional<IRisingHeat> getHeatedState(LivingEntity entity) {
        if (entity == null) {
            return LazyOptional.empty();
        }
        return entity.getCapability(RISING_HEAT_CAPABILITY);
    }

    public static LazyOptional<IPlayerTracker> getPlayerTracker(Player player) {
        if (player == null) {
            return LazyOptional.empty();
        }
        return player.getCapability(PLAYER_TRACKER_CAPABILITY);
    }

    @Mod.EventBusSubscriber(modid="flatlights")
    public static class CapabilityEvents {
        @SubscribeEvent
        public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof LivingEntity) {
                EntangledStateAttacher.attach(event);
                RisingHeatStateAttacher.attach(event);
            }
        }

        @SubscribeEvent
        public static void registerCapabilities(RegisterCapabilitiesEvent event) {
            event.register(IEntangled.class);
            event.register(IRisingHeat.class);
            event.register(IPlayerTracker.class);
        }

        @SubscribeEvent
        public static void addEntangledEffect(MobEffectEvent.Added event) {
            LivingEntity entity;
            if (event.getEntity().m_21023_((MobEffect)ModEffects.ENTANGLED.get()) && ModCapabilities.getEntangledState(entity = event.getEntity()).isPresent()) {
                ModCapabilities.getEntangledState(entity).ifPresent(entangledState -> {
                    entangledState.setEntangledState(true);
                    MiscUtils.infoLog("[Added potion effect] Changed entangled state to true");
                    if (!entity.m_9236_().m_5776_()) {
                        Supplier<Entity> supplier = () -> entity;
                        PacketHandler.sendToDistributor(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(supplier), new PacketEntangledUpdate(entity.m_19879_(), true));
                    }
                });
            }
        }

        public static void syncPlayerCaps(Player playerIn) {
            IPlayerTracker cap = (IPlayerTracker)ModCapabilities.getPlayerTracker(playerIn).orElse((Object)new PlayerTrackerCap());
            CompoundTag tag = (CompoundTag)cap.serializeNBT();
            if (playerIn instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                PacketHandler.sendToPlayer(new PacketSyncPlayerCap(tag), serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CapabilityEvents.syncPlayerCaps((Player)serverPlayer);
            }
        }

        @SubscribeEvent
        public static void respawnEvent(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CapabilityEvents.syncPlayerCaps((Player)serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerStartTrackingEvent(PlayerEvent.StartTracking event) {
            Player player;
            if (event.getTarget() instanceof Player && (player = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CapabilityEvents.syncPlayerCaps((Player)serverPlayer);
            }
        }

        @SubscribeEvent
        public static void onPlayerDimChangedEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CapabilityEvents.syncPlayerCaps((Player)serverPlayer);
            }
        }

        @SubscribeEvent
        public static void playerClone(PlayerEvent.Clone event) {
            Player oldPlayer = event.getOriginal();
            oldPlayer.reviveCaps();
            ModCapabilities.getPlayerTracker(oldPlayer).ifPresent(oldPlayerTracker -> ModCapabilities.getPlayerTracker(event.getEntity()).ifPresent(newPlayerTracker -> newPlayerTracker.setTracker(oldPlayerTracker.getTracker())));
            ModCapabilities.getPlayerTracker(oldPlayer).ifPresent(oldPlayerTrackerCap -> {
                IPlayerTracker playerTrackerCap = (IPlayerTracker)ModCapabilities.getPlayerTracker(event.getEntity()).orElse((Object)new PlayerTrackerCap());
                CompoundTag tag = (CompoundTag)oldPlayerTrackerCap.serializeNBT();
                playerTrackerCap.deserializeNBT((Tag)tag);
                CapabilityEvents.syncPlayerCaps(event.getEntity());
            });
            event.getOriginal().invalidateCaps();
        }
    }
}

