/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.capability;

import com.uberhelixx.flatlights.common.capability.IPlayerTracker;
import com.uberhelixx.flatlights.common.capability.ModCapabilities;
import com.uberhelixx.flatlights.common.capability.PlayerTrackerCap;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerTrackerCapAttacher {
    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        PlayerTrackerProvider provider = new PlayerTrackerProvider();
        event.addCapability(PlayerTrackerProvider.ID, (ICapabilityProvider)provider);
    }

    public static class PlayerTrackerProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        public static final ResourceLocation ID = new ResourceLocation("flatlights", "player_core_tracker");
        private PlayerTrackerCap playerTrackerCap = new PlayerTrackerCap();
        private final LazyOptional<IPlayerTracker> optionalData = LazyOptional.of(() -> this.playerTrackerCap);

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction direction) {
            return ModCapabilities.PLAYER_TRACKER_CAPABILITY.orEmpty(capability, this.optionalData);
        }

        void invalidate() {
            this.optionalData.invalidate();
        }

        public CompoundTag serializeNBT() {
            return this.playerTrackerCap.serializeNBT();
        }

        public void deserializeNBT(CompoundTag tag) {
            this.playerTrackerCap.deserializeNBT(tag);
        }
    }
}

