/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.capability;

import com.uberhelixx.flatlights.common.capability.IRisingHeat;
import com.uberhelixx.flatlights.common.capability.ModCapabilities;
import com.uberhelixx.flatlights.common.capability.RisingHeatState;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RisingHeatStateAttacher {
    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        RisingHeatStateProvider provider = new RisingHeatStateProvider();
        event.addCapability(RisingHeatStateProvider.ID, (ICapabilityProvider)provider);
    }

    public static class RisingHeatStateProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        public static final ResourceLocation ID = new ResourceLocation("flatlights", "rising_heat_state");
        private RisingHeatState risingHeatState = new RisingHeatState();
        private final LazyOptional<IRisingHeat> optionalData = LazyOptional.of(() -> this.risingHeatState);

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction direction) {
            return ModCapabilities.RISING_HEAT_CAPABILITY.orEmpty(capability, this.optionalData);
        }

        void invalidate() {
            this.optionalData.invalidate();
        }

        public CompoundTag serializeNBT() {
            return this.risingHeatState.serializeNBT();
        }

        public void deserializeNBT(CompoundTag tag) {
            this.risingHeatState.deserializeNBT(tag);
        }
    }
}

