/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.effect;

import com.uberhelixx.flatlights.FlatLightsCommonConfig;
import com.uberhelixx.flatlights.common.capability.ModCapabilities;
import com.uberhelixx.flatlights.common.network.PacketHandler;
import com.uberhelixx.flatlights.common.network.packets.PacketEntangledUpdate;
import com.uberhelixx.flatlights.startup.registry.ModDamageTypes;
import com.uberhelixx.flatlights.util.MiscUtils;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.scores.Scoreboard;
import net.minecraftforge.network.PacketDistributor;

public class EntangledEffect
extends MobEffect {
    private static final String ENTANGLED_TEAM = "flatlights.entangledMobs";

    protected EntangledEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public void m_6742_(LivingEntity pLivingEntity, int pAmplifier) {
        Scoreboard entityScoreboard = pLivingEntity.m_20193_().m_6188_();
        LivingEntity trueSource = pLivingEntity.m_21225_() != null ? pLivingEntity.m_21225_().m_7639_() : pLivingEntity;
        pLivingEntity.f_19802_ = 0;
        int dmgMulti = 1;
        if (pAmplifier > 0) {
            dmgMulti += pAmplifier;
        }
        pLivingEntity.m_6469_((DamageSource)ModDamageTypes.causeEntangledDamage((Entity)trueSource), pLivingEntity.m_21233_() * (0.1f * (float)dmgMulti) * MiscUtils.damagePercentCalc((Integer)FlatLightsCommonConfig.entangledEndDmg.get()));
        if (pLivingEntity.m_5647_() != null && pLivingEntity.m_5647_() == entityScoreboard.m_83489_(ENTANGLED_TEAM)) {
            entityScoreboard.m_6519_(pLivingEntity.m_20149_(), Objects.requireNonNull(entityScoreboard.m_83489_(ENTANGLED_TEAM)));
        }
        if (ModCapabilities.getEntangledState(pLivingEntity).isPresent()) {
            ModCapabilities.getEntangledState(pLivingEntity).ifPresent(entangledState -> {
                entangledState.setEntangledState(false);
                MiscUtils.infoLog("[Entangled Effect] Changed entangled state to false");
                if (!pLivingEntity.m_20193_().m_5776_()) {
                    Supplier<Entity> supplier = () -> pLivingEntity;
                    PacketHandler.sendToDistributor(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(supplier), new PacketEntangledUpdate(pLivingEntity.m_19879_(), false));
                }
            });
        }
        super.m_6742_(pLivingEntity, pAmplifier);
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        return pDuration <= 1;
    }

    public static String getEntangledTeam() {
        return ENTANGLED_TEAM;
    }
}

