/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.enchantments;

import com.google.common.collect.Multimap;
import com.uberhelixx.flatlights.FlatLightsCommonConfig;
import com.uberhelixx.flatlights.common.effect.EntangledEffect;
import com.uberhelixx.flatlights.common.effect.ModEffects;
import com.uberhelixx.flatlights.startup.registry.ModDamageTypes;
import com.uberhelixx.flatlights.util.MiscUtils;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public class QuantumStrikeEnchantment
extends Enchantment {
    protected QuantumStrikeEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.WEAPON, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public int m_6586_() {
        return 5;
    }

    public Component m_44700_(int pLevel) {
        Style color = Style.f_131099_.m_178520_(0x4C0CCC);
        return ((MutableComponent)super.m_44700_(pLevel)).m_130948_(color);
    }

    public void m_7677_(LivingEntity pAttacker, Entity pTarget, int pLevel) {
        super.m_7677_(pAttacker, pTarget, pLevel);
        if (pTarget instanceof LivingEntity) {
            Player player;
            ItemStack weapon = pAttacker.m_21205_();
            double weaponDamage = 1.0;
            Multimap attributes = weapon.m_41638_(EquipmentSlot.MAINHAND);
            MiscUtils.infoLog("[Quantum Strike] Damage attribute from weapon: " + this.getDamageAttribute((Multimap<Attribute, AttributeModifier>)attributes, Attributes.f_22281_));
            MiscUtils.infoLog("[Quantum Strike] Damage addition from sharpness: " + this.getSharpnessDmg(pAttacker));
            double newWeaponDmg = this.getDamageAttribute((Multimap<Attribute, AttributeModifier>)attributes, Attributes.f_22281_) + this.getSharpnessDmg(pAttacker);
            MiscUtils.infoLog("[Quantum Strike] Total Dmg: " + newWeaponDmg);
            weaponDamage += newWeaponDmg;
            if (pAttacker instanceof Player && (player = (Player)pAttacker).m_36403_(0.0f) == 1.0f) {
                pTarget.f_19802_ = 0;
            }
            pTarget.m_6469_((DamageSource)ModDamageTypes.causeQuantumDamage((Entity)pAttacker), (float)(weaponDamage * (double)(1.0f + 0.1f * (float)pLevel)) * MiscUtils.damagePercentCalc((Integer)FlatLightsCommonConfig.quantumPercent.get()));
            ((LivingEntity)pTarget).m_7292_(new MobEffectInstance((MobEffect)ModEffects.ENTANGLED.get(), 600, pLevel));
            ((LivingEntity)pTarget).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 600));
            MiscUtils.addToTeam((LivingEntity)pTarget, EntangledEffect.getEntangledTeam(), ChatFormatting.BLUE);
        }
    }

    private double getDamageAttribute(Multimap<Attribute, AttributeModifier> mapIn, Attribute attributeIn) {
        double amount = 0.0;
        Collection collector = mapIn.get((Object)attributeIn);
        if (!collector.isEmpty()) {
            for (AttributeModifier entry : collector) {
                double entryAmount = entry.m_22218_();
                amount += entryAmount;
                MiscUtils.infoLog("[Quantum Strike] Attack Dmg Attribute Name: " + Attributes.f_22281_.m_22087_());
                MiscUtils.infoLog("[Quantum Strike] Collection Entry Name: " + entry);
            }
        }
        return amount;
    }

    private double getSharpnessDmg(LivingEntity entityIn) {
        double amount = 0.0;
        if (EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44977_, (LivingEntity)entityIn) > 0) {
            amount = 0.5;
            amount += 0.5 * (double)EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44977_, (LivingEntity)entityIn);
        }
        return amount;
    }
}

