/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.entity;

import com.uberhelixx.flatlights.FlatLightsCommonConfig;
import com.uberhelixx.flatlights.common.entity.ModEntityTypes;
import com.uberhelixx.flatlights.common.item.ModItems;
import com.uberhelixx.flatlights.startup.registry.ModSoundEvents;
import com.uberhelixx.flatlights.util.MiscUtils;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class GravityLiftEntity
extends AbstractArrow {
    public static final int SECONDS = FlatLightsCommonConfig.gravityLiftTime.get() != null ? (Integer)FlatLightsCommonConfig.gravityLiftTime.get() : 10;
    int TICK_MULTI = 20;

    protected GravityLiftEntity(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public GravityLiftEntity(Level pLevel) {
        super((EntityType)ModEntityTypes.GRAVITY_LIFT_ENTITY.get(), pLevel);
    }

    public GravityLiftEntity(EntityType<? extends AbstractArrow> pEntityType, LivingEntity livingEntity, Level pLevel) {
        super(pEntityType, livingEntity, pLevel);
    }

    public void m_8119_() {
        this.liftUp();
        if (this.f_19797_ % 20 == 0 && this.m_9236_().m_5776_()) {
            for (int i = 0; i < 360; ++i) {
                if (i % 20 != 0) continue;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123799_, this.m_20185_(), this.m_20186_(), this.m_20189_(), Math.cos(i) * 0.025, 0.125, Math.sin(i) * 0.025);
            }
        }
        if (this.f_19797_ % (5 * this.TICK_MULTI) == 5) {
            float nextFloatPitch = this.m_9236_().f_46441_.m_188501_();
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSoundEvents.GRAVITY_LIFT_HUM.get(), SoundSource.AMBIENT, 0.8f, 1.0f + nextFloatPitch * 0.05f, true);
        }
        if (this.f_19797_ > SECONDS * this.TICK_MULTI) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected ItemStack m_7941_() {
        return ((Item)ModItems.GUN_RAT.get()).m_7968_();
    }

    private void liftUp() {
        float LIFT_SPEED = 0.5f;
        List entities = this.m_9236_().m_45933_(this.m_19749_(), this.m_20191_());
        for (Entity instance : entities) {
            boolean hopOut = false;
            if (instance instanceof Player && instance.m_6047_()) {
                hopOut = true;
            }
            float HEIGHT_BUFFER = 0.375f;
            if (instance.m_20270_((Entity)this) > 7.625f && this.f_19797_ < (SECONDS - 1) * this.TICK_MULTI && !hopOut) {
                instance.m_20334_(instance.m_20184_().m_7096_(), (double)(LIFT_SPEED * 0.0f), instance.m_20184_().m_7094_());
                continue;
            }
            if (instance.m_20270_((Entity)this) > 7.625f && (this.f_19797_ >= (SECONDS - 1) * this.TICK_MULTI || hopOut)) {
                if (hopOut) {
                    MiscUtils.infoLog("[Gravity Lift Entity] Player should be launching out after sneaking in lift.");
                }
                float SPEED_MULTI = 1.75f;
                instance.m_20334_(instance.m_20184_().m_7096_() * ((double)SPEED_MULTI + 1.5), (double)(LIFT_SPEED * SPEED_MULTI), instance.m_20184_().m_7094_() * ((double)SPEED_MULTI + 1.75));
                continue;
            }
            instance.m_20334_(instance.m_20184_().m_7096_(), (double)LIFT_SPEED, instance.m_20184_().m_7094_());
        }
    }
}

