/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.entity;

import com.uberhelixx.flatlights.common.entity.ModEntityTypes;
import com.uberhelixx.flatlights.common.item.tools.PrismaticBladeMk2;
import com.uberhelixx.flatlights.startup.registry.ModDamageTypes;
import com.uberhelixx.flatlights.startup.registry.ModSoundEvents;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.NetworkHooks;

public class Mk2ProjectileEntity
extends AbstractArrow {
    int SECONDS = 5;
    int TICK_MULTI = 20;
    boolean didExpireEffects = false;

    protected Mk2ProjectileEntity(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public Mk2ProjectileEntity(Level pLevel) {
        super((EntityType)ModEntityTypes.MK2_PROJECTILE_ENTITY.get(), pLevel);
    }

    public Mk2ProjectileEntity(EntityType<? extends AbstractArrow> pEntityType, LivingEntity livingEntity, Level pLevel) {
        super(pEntityType, livingEntity, pLevel);
    }

    public void m_8119_() {
        super.m_8119_();
        this.magnetizeEntities();
        double PARTICLE_Y_SCALE = 0.3;
        double PARTICLE_XZ_SCALE = 0.15;
        if (this.f_36703_) {
            if (this.f_19797_ % 20 == 0 && this.m_9236_().m_5776_()) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_235898_, this.m_20185_(), this.m_20186_() + 0.1, this.m_20189_() - 0.25, (this.f_19796_.m_188500_() - 0.5) * PARTICLE_XZ_SCALE, (this.f_19796_.m_188500_() - 0.5) * PARTICLE_Y_SCALE, (this.f_19796_.m_188500_() - 0.5) * PARTICLE_XZ_SCALE);
            }
            if (this.f_19797_ % 20 == 3 && this.m_9236_().m_5776_()) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_235898_, this.m_20185_() + 0.25, this.m_20186_() + 0.7, this.m_20189_(), (this.f_19796_.m_188500_() - 0.5) * PARTICLE_XZ_SCALE, (this.f_19796_.m_188500_() - 0.5) * PARTICLE_Y_SCALE, (this.f_19796_.m_188500_() - 0.5) * PARTICLE_XZ_SCALE);
            }
            if (this.f_19797_ % 20 == 5 && this.m_9236_().m_5776_()) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_235898_, this.m_20185_(), this.m_20186_() + 0.4, this.m_20189_() + 0.25, (this.f_19796_.m_188500_() - 0.5) * PARTICLE_XZ_SCALE, (this.f_19796_.m_188500_() - 0.5) * PARTICLE_Y_SCALE, (this.f_19796_.m_188500_() - 0.5) * PARTICLE_XZ_SCALE);
            }
            if (this.f_19797_ % 20 == 7 && this.m_9236_().m_5776_()) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_235898_, this.m_20185_() - 0.6, this.m_20186_() + 0.25, this.m_20189_(), (this.f_19796_.m_188500_() - 0.5) * PARTICLE_XZ_SCALE, (this.f_19796_.m_188500_() - 0.5) * PARTICLE_Y_SCALE, (this.f_19796_.m_188500_() - 0.5) * PARTICLE_XZ_SCALE);
            }
        } else {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (this.didExpireEffects) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (this.f_36703_ && this.f_36704_ >= this.SECONDS * this.TICK_MULTI) {
            this.fakeExplosion();
            this.didExpireEffects = true;
        }
        if (this.f_19797_ >= this.SECONDS * 2 * this.TICK_MULTI) {
            this.fakeExplosion();
            this.didExpireEffects = true;
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        this.m_36740_((SoundEvent)ModSoundEvents.VOID_FIZZLE.get());
        this.m_36762_(true);
        super.m_5790_(pResult);
        Entity projSpawner = this.m_19749_();
        if (projSpawner instanceof Player) {
            Player shooter = (Player)projSpawner;
            if (!pResult.m_82443_().m_7306_(projSpawner)) {
                float projectileDmg = PrismaticBladeMk2.calcProjectileDmg(shooter);
                this.m_36781_(projectileDmg);
                pResult.m_82443_().m_6469_((DamageSource)ModDamageTypes.causeQuantumDamage((Entity)shooter), projectileDmg);
                this.fakeExplosion();
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected boolean m_142470_(Player pPlayer) {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected ItemStack m_7941_() {
        return Items.f_42415_.m_7968_();
    }

    protected void m_8060_(BlockHitResult pResult) {
        this.m_36740_(SoundEvents.f_12515_);
        super.m_8060_(pResult);
    }

    private void magnetizeEntities() {
        float MAG_RADIUS = 1.75f;
        double MAG_STRENGTH = 0.05;
        if (this.m_19749_() != null) {
            Entity projSpawner = this.m_19749_();
            float projectileDmg = 1.0f;
            if (projSpawner instanceof Player) {
                Player shooter = (Player)projSpawner;
                projectileDmg = PrismaticBladeMk2.calcProjectileDmg(shooter);
            }
            List entities = this.m_9236_().m_45933_(this.m_19749_(), this.m_20191_().m_82400_((double)MAG_RADIUS));
            for (Entity instance : entities) {
                if (!(instance instanceof LivingEntity) || instance.m_7306_(this.m_19749_())) continue;
                if ((double)instance.m_20270_((Entity)this) <= 1.0) {
                    instance.m_6469_((DamageSource)ModDamageTypes.causeQuantumDamage(this.m_19749_()), projectileDmg);
                }
                if (this.m_20185_() > instance.m_20185_() && instance.m_20184_().m_7096_() < 1.0) {
                    instance.m_20334_(instance.m_20184_().m_7096_() + MAG_STRENGTH, instance.m_20184_().m_7098_(), instance.m_20184_().m_7094_());
                } else if (this.m_20185_() < instance.m_20185_() && instance.m_20184_().m_7096_() > -1.0) {
                    instance.m_20334_(instance.m_20184_().m_7096_() - MAG_STRENGTH, instance.m_20184_().m_7098_(), instance.m_20184_().m_7094_());
                }
                if (this.m_20186_() > instance.m_20186_() && instance.m_20184_().m_7098_() < 1.0) {
                    instance.m_20334_(instance.m_20184_().m_7096_(), instance.m_20184_().m_7098_() + MAG_STRENGTH, instance.m_20184_().m_7094_());
                } else if (this.m_20186_() < instance.m_20186_() && instance.m_20184_().m_7098_() > -1.0) {
                    instance.m_20334_(instance.m_20184_().m_7096_(), instance.m_20184_().m_7098_() - MAG_STRENGTH, instance.m_20184_().m_7094_());
                }
                if (this.m_20189_() > instance.m_20189_() && instance.m_20184_().m_7094_() < 1.0) {
                    instance.m_20334_(instance.m_20184_().m_7096_(), instance.m_20184_().m_7098_(), instance.m_20184_().m_7094_() + MAG_STRENGTH);
                    continue;
                }
                if (!(this.m_20189_() < instance.m_20189_()) || !(instance.m_20184_().m_7094_() > -1.0)) continue;
                instance.m_20334_(instance.m_20184_().m_7096_(), instance.m_20184_().m_7098_(), instance.m_20184_().m_7094_() - MAG_STRENGTH);
            }
        }
    }

    private void fakeExplosion() {
        this.m_9236_().m_245803_((Entity)this, this.m_20183_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f + this.m_9236_().m_213780_().m_188501_() * 0.05f);
        for (int i = 0; i < 2; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_235902_, this.m_20185_() + 1.5 * this.f_19796_.m_188500_(), this.m_20186_() + 1.5 * this.f_19796_.m_188500_(), this.m_20189_() + 1.5 * this.f_19796_.m_188500_(), this.f_19796_.m_188500_() - 0.5, this.f_19796_.m_188500_() - 0.5, this.f_19796_.m_188500_() - 0.5);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_235902_, this.m_20185_() - 1.5 * this.f_19796_.m_188500_(), this.m_20186_() + 1.5 * this.f_19796_.m_188500_(), this.m_20189_() - 1.5 * this.f_19796_.m_188500_(), this.f_19796_.m_188500_() - 0.5, this.f_19796_.m_188500_() - 0.5, this.f_19796_.m_188500_() - 0.5);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_235902_, this.m_20185_() + 1.5 * this.f_19796_.m_188500_(), this.m_20186_() - 1.5 * this.f_19796_.m_188500_(), this.m_20189_() + 1.5 * this.f_19796_.m_188500_(), this.f_19796_.m_188500_() - 0.5, this.f_19796_.m_188500_() - 0.5, this.f_19796_.m_188500_() - 0.5);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_235902_, this.m_20185_() - 1.5 * this.f_19796_.m_188500_(), this.m_20186_() - 1.5 * this.f_19796_.m_188500_(), this.m_20189_() - 1.5 * this.f_19796_.m_188500_(), this.f_19796_.m_188500_() - 0.5, this.f_19796_.m_188500_() - 0.5, this.f_19796_.m_188500_() - 0.5);
        }
        Entity owner = this.m_19749_();
        if (owner instanceof Player) {
            Player player = (Player)owner;
            List entities = this.m_9236_().m_45933_((Entity)player, this.m_20191_().m_82400_(2.0));
            for (Entity entity : entities) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity mob = (LivingEntity)entity;
                mob.m_6469_((DamageSource)ModDamageTypes.causeQuantumDamage((Entity)player), 5.0f);
            }
        }
    }
}

