/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.entity;

import com.uberhelixx.flatlights.FlatLightsCommonConfig;
import com.uberhelixx.flatlights.common.entity.ModEntityTypes;
import com.uberhelixx.flatlights.common.item.ModItems;
import com.uberhelixx.flatlights.startup.registry.ModDamageTypes;
import com.uberhelixx.flatlights.startup.registry.ModSoundEvents;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class PortableBlackHoleEntity
extends AbstractArrow {
    int SECONDS = 7;
    int TICK_MULTI = 20;

    protected PortableBlackHoleEntity(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public PortableBlackHoleEntity(Level pLevel) {
        super((EntityType)ModEntityTypes.PORTABLE_BLACK_HOLE_ENTITY.get(), pLevel);
    }

    public PortableBlackHoleEntity(EntityType<? extends AbstractArrow> pEntityType, LivingEntity livingEntity, Level pLevel) {
        super(pEntityType, livingEntity, pLevel);
    }

    public void m_8119_() {
        this.damageInRadius();
        double PARTICLE_Y_OFFSET = 0.65;
        if (this.f_19797_ % 20 == 0 && this.m_9236_().m_5776_()) {
            double PARTICLE_SPEED_MULTI = 0.75;
            for (int i = 0; i < 5; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123799_, this.m_20185_(), this.m_20186_() + PARTICLE_Y_OFFSET, this.m_20189_(), (this.f_19796_.m_188500_() - 0.5) * PARTICLE_SPEED_MULTI, (this.f_19796_.m_188500_() - 0.5) * PARTICLE_SPEED_MULTI, (this.f_19796_.m_188500_() - 0.5) * PARTICLE_SPEED_MULTI);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123799_, this.m_20185_(), this.m_20186_() + PARTICLE_Y_OFFSET, this.m_20189_(), (this.f_19796_.m_188500_() - 0.5) * PARTICLE_SPEED_MULTI, (this.f_19796_.m_188500_() - 0.5) * PARTICLE_SPEED_MULTI, (this.f_19796_.m_188500_() - 0.5) * PARTICLE_SPEED_MULTI);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123799_, this.m_20185_(), this.m_20186_() + PARTICLE_Y_OFFSET, this.m_20189_(), (this.f_19796_.m_188500_() - 0.5) * PARTICLE_SPEED_MULTI, (this.f_19796_.m_188500_() - 0.5) * PARTICLE_SPEED_MULTI, (this.f_19796_.m_188500_() - 0.5) * PARTICLE_SPEED_MULTI);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123799_, this.m_20185_(), this.m_20186_() + PARTICLE_Y_OFFSET, this.m_20189_(), (this.f_19796_.m_188500_() - 0.5) * PARTICLE_SPEED_MULTI, (this.f_19796_.m_188500_() - 0.5) * PARTICLE_SPEED_MULTI, (this.f_19796_.m_188500_() - 0.5) * PARTICLE_SPEED_MULTI);
            }
        }
        if (this.f_19797_ % (this.SECONDS * this.TICK_MULTI) == 5) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSoundEvents.VOID_HUM.get(), SoundSource.AMBIENT, 0.55f, 1.0f + this.m_9236_().f_46441_.m_188501_() * 0.05f, true);
        }
        if (this.f_19797_ > this.SECONDS * this.TICK_MULTI) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            for (int i = 0; i < 360; ++i) {
                if (i % 10 != 0) continue;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123799_, this.m_20185_(), this.m_20186_() + PARTICLE_Y_OFFSET, this.m_20189_(), Math.cos(i) * 0.5, 0.0, Math.sin(i) * 0.5);
            }
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSoundEvents.VOID_FIZZLE.get(), SoundSource.AMBIENT, 1.0f, 1.0f + this.m_9236_().f_46441_.m_188501_() * 0.05f, true);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected ItemStack m_7941_() {
        return ((Item)ModItems.GUN_RAT.get()).m_7968_();
    }

    private void damageInRadius() {
        float PROJECTILE_DMG = 1.5f;
        if (FlatLightsCommonConfig.portableBlackHoleDamage.get() != null) {
            PROJECTILE_DMG = ((Double)FlatLightsCommonConfig.portableBlackHoleDamage.get()).floatValue();
        }
        float SUCC_RADIUS = 4.0f;
        double SUCC_POWER = 0.2;
        if (FlatLightsCommonConfig.portableBlackHoleSuckPower.get() != null) {
            SUCC_POWER = (Double)FlatLightsCommonConfig.portableBlackHoleSuckPower.get();
        }
        Entity projSpawner = this.m_19749_();
        List entities = this.m_9236_().m_45933_(this.m_19749_(), this.m_20191_().m_82400_((double)SUCC_RADIUS));
        for (Entity instance : entities) {
            if (!(instance instanceof LivingEntity)) continue;
            if ((double)instance.m_20270_((Entity)this) <= 1.25 && projSpawner != null) {
                instance.m_6469_((DamageSource)ModDamageTypes.causeQuantumDamage(projSpawner), PROJECTILE_DMG);
                continue;
            }
            if (this.m_20185_() > instance.m_20185_() && instance.m_20184_().m_7096_() < 1.0) {
                instance.m_20334_(instance.m_20184_().m_7096_() + SUCC_POWER, instance.m_20184_().m_7098_(), instance.m_20184_().m_7094_());
            } else if (this.m_20185_() < instance.m_20185_() && instance.m_20184_().m_7096_() > -1.0) {
                instance.m_20334_(instance.m_20184_().m_7096_() - SUCC_POWER, instance.m_20184_().m_7098_(), instance.m_20184_().m_7094_());
            }
            if (this.m_20186_() > instance.m_20186_() && instance.m_20184_().m_7098_() < 1.0) {
                instance.m_20334_(instance.m_20184_().m_7096_(), instance.m_20184_().m_7098_() + SUCC_POWER, instance.m_20184_().m_7094_());
            } else if (this.m_20186_() < instance.m_20186_() && instance.m_20184_().m_7098_() > -1.0) {
                instance.m_20334_(instance.m_20184_().m_7096_(), instance.m_20184_().m_7098_() - SUCC_POWER, instance.m_20184_().m_7094_());
            }
            if (this.m_20189_() > instance.m_20189_() && instance.m_20184_().m_7094_() < 1.0) {
                instance.m_20334_(instance.m_20184_().m_7096_(), instance.m_20184_().m_7098_(), instance.m_20184_().m_7094_() + SUCC_POWER);
                continue;
            }
            if (!(this.m_20189_() < instance.m_20189_()) || !(instance.m_20184_().m_7094_() > -1.0)) continue;
            instance.m_20334_(instance.m_20184_().m_7096_(), instance.m_20184_().m_7098_(), instance.m_20184_().m_7094_() - SUCC_POWER);
        }
    }
}

