/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.event;

import com.uberhelixx.flatlights.FlatLightsCommonConfig;
import com.uberhelixx.flatlights.common.item.ModItems;
import com.uberhelixx.flatlights.common.item.armor.BaseArmorItem;
import com.uberhelixx.flatlights.common.item.armor.PrismaticChestplate;
import com.uberhelixx.flatlights.common.item.armor.PrismaticHelm;
import com.uberhelixx.flatlights.util.MiscUtils;
import java.util.Objects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="flatlights", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ArmorEvents {
    @SubscribeEvent
    public static void DamageReduction(LivingHurtEvent event) {
        Player player;
        LivingEntity livingEntity;
        if (!event.getSource().m_269533_(DamageTypeTags.f_268738_) && (livingEntity = event.getEntity()) instanceof Player && (BaseArmorItem.wearingBoots(player = (Player)livingEntity) || BaseArmorItem.wearingLegs(player) || BaseArmorItem.wearingChest(player) || BaseArmorItem.wearingHelm(player))) {
            int armorTotal = player.m_21230_();
            float totalReduction = (float)((double)armorTotal * ((Double)FlatLightsCommonConfig.reductionPerPoint.get() / 100.0));
            float reductionRatioCap = (float)((Integer)FlatLightsCommonConfig.armorDamageReduction.get()).intValue() / 100.0f;
            float reductionRatio = Mth.m_14036_((float)totalReduction, (float)0.0f, (float)reductionRatioCap);
            float reducedDamage = event.getAmount() * (1.0f - reductionRatio);
            if (((Boolean)FlatLightsCommonConfig.multilayerReduction.get()).booleanValue()) {
                reducedDamage = event.getAmount();
                if (BaseArmorItem.wearingBoots(player)) {
                    reducedDamage *= 1.0f - reductionRatio;
                }
                if (BaseArmorItem.wearingLegs(player)) {
                    reducedDamage *= 1.0f - reductionRatio;
                }
                if (BaseArmorItem.wearingChest(player)) {
                    reducedDamage *= 1.0f - reductionRatio;
                }
                if (BaseArmorItem.wearingHelm(player)) {
                    reducedDamage *= 1.0f - reductionRatio;
                }
            }
            MiscUtils.infoLog("[Prismatic Armor] Reduced damage is now " + reducedDamage);
            event.setAmount(reducedDamage);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void negateFallDamage(LivingHurtEvent event) {
        DamageSource dmgSrc = event.getSource();
        if (event.getEntity() instanceof Player && BaseArmorItem.wearingBoots((Player)event.getEntity()) && dmgSrc.m_276093_(DamageTypes.f_268671_)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void chestplateEquip(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getSlot() == EquipmentSlot.CHEST) {
                if (event.getFrom().equals(event.getTo(), false)) {
                    return;
                }
                if (event.getTo().m_41720_() instanceof PrismaticChestplate) {
                    PrismaticChestplate.onEquip(player);
                } else if (event.getFrom().m_41720_() instanceof PrismaticChestplate) {
                    PrismaticChestplate.onUnequip(player);
                }
            }
        }
    }

    @SubscribeEvent
    public static void playerTickChestplate(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!(!(player.m_150109_().m_36052_(2).m_41720_() instanceof PrismaticChestplate) || player.m_150110_().f_35935_ || player.m_150110_().f_35936_ || player.m_7500_() || player.m_5833_())) {
            PrismaticChestplate.onEquip(player);
        }
    }

    @SubscribeEvent
    public static void helmetEquip(LivingEquipmentChangeEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        boolean hasNightVis = !Objects.equals(player.m_21124_(MobEffects.f_19611_), null);
        boolean hasWaterBreath = !Objects.equals(player.m_21124_(MobEffects.f_19608_), null);
        if (event.getSlot() == EquipmentSlot.HEAD) {
            if (event.getFrom() == event.getTo() && event.getFrom().m_41720_() == ModItems.PRISMATIC_HELMET.get()) {
                return;
            }
            if (event.getTo().m_41720_() == ModItems.PRISMATIC_HELMET.get()) {
                PrismaticHelm.onEquip((Player)event.getEntity(), hasNightVis, hasWaterBreath);
            } else {
                PrismaticHelm.onUnequip((Player)event.getEntity(), hasNightVis, hasWaterBreath);
            }
        }
    }
}

