/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.event;

import com.uberhelixx.flatlights.FlatLightsCommonConfig;
import com.uberhelixx.flatlights.startup.registry.ModAttributes;
import java.util.ArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="flatlights")
public class AttributeEvents {
    private static final String ITEM_MARKER = "flatlights.marker";

    private static boolean checkAttribute(Player playerIn, Attribute attributeIn) {
        return playerIn.m_21051_(attributeIn) != null && playerIn.m_21051_(attributeIn).m_22135_() > 0.0;
    }

    @SubscribeEvent
    public static void dodgeChance(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            double dodge = 0.0;
            if (AttributeEvents.checkAttribute(player, (Attribute)ModAttributes.DODGE_CHANCE.get())) {
                dodge = player.m_21051_((Attribute)ModAttributes.DODGE_CHANCE.get()).m_22135_() / 100.0;
            }
            if (player.m_9236_().m_213780_().m_188500_() <= dodge && dodge > 0.0) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void xpBoost(PlayerXpEvent.XpChange event) {
        int baseXp = event.getAmount();
        Player player = event.getEntity();
        double xpBoost = 0.0;
        if (AttributeEvents.checkAttribute(player, (Attribute)ModAttributes.XP_BOOST.get())) {
            xpBoost = player.m_21051_((Attribute)ModAttributes.XP_BOOST.get()).m_22135_();
            int boostedXp = baseXp + Math.round((float)xpBoost);
            event.setAmount(boostedXp);
        }
    }

    public static void xpOrbBoost(PlayerXpEvent.PickupXp event) {
        event.setCanceled(true);
        double x = event.getOrb().m_20185_();
        double y = event.getOrb().m_20186_();
        double z = event.getOrb().m_20189_();
        Level world = event.getOrb().m_9236_();
        Player player = event.getEntity();
        double xpBoost = 0.0;
        if (AttributeEvents.checkAttribute(player, (Attribute)ModAttributes.XP_BOOST.get())) {
            xpBoost = player.m_21051_((Attribute)ModAttributes.XP_BOOST.get()).m_22135_();
            int addedXp = (int)Math.round(xpBoost) + event.getOrb().m_20801_();
            ExperienceOrb newOrb = new ExperienceOrb(world, x, y, z, addedXp);
            event.getOrb().m_142687_(Entity.RemovalReason.DISCARDED);
            world.m_7967_((Entity)newOrb);
        }
    }

    @SubscribeEvent
    public static void healingBoost(LivingHealEvent event) {
        Player player;
        float baseHeal = event.getAmount();
        double healBoost = 0.0;
        Player player2 = player = event.getEntity() instanceof Player ? (Player)event.getEntity() : null;
        if (player != null && AttributeEvents.checkAttribute(player, (Attribute)ModAttributes.HEALING_BOOST.get())) {
            healBoost = player.m_21051_((Attribute)ModAttributes.HEALING_BOOST.get()).m_22135_();
            event.setAmount((float)((double)baseHeal + healBoost));
        }
    }

    @SubscribeEvent
    public static void markBaseLoot(LivingDeathEvent event) {
        if (event.getEntity() instanceof Player) {
            return;
        }
        event.getEntity().m_20158_().forEach(itemStack -> {
            if (!itemStack.m_41619_()) {
                itemStack.m_41784_().m_128379_(ITEM_MARKER, true);
            }
        });
    }

    @SubscribeEvent
    public static void lootRollIncrease(LivingDropsEvent event) {
        if (event.getEntity() instanceof Player) {
            return;
        }
        LivingEntity mob = event.getEntity();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!event.getDrops().isEmpty() && AttributeEvents.checkAttribute(player, (Attribute)ModAttributes.LOOT_ROLL_AMOUNT.get()) && AttributeEvents.checkAttribute(player, (Attribute)ModAttributes.LOOT_ROLL_CHANCE.get())) {
                int bonusLootRolls = Mth.m_14045_((int)Math.round((float)player.m_21051_((Attribute)ModAttributes.LOOT_ROLL_AMOUNT.get()).m_22135_()), (int)0, (int)((Integer)FlatLightsCommonConfig.maxLootRolls.get()));
                double bonusRollChance = Mth.m_14008_((double)(player.m_21051_((Attribute)ModAttributes.LOOT_ROLL_CHANCE.get()).m_22135_() / 100.0), (double)0.0, (double)((Double)FlatLightsCommonConfig.maxLootRollChance.get() / 100.0));
                if (player.m_9236_().m_213780_().m_188500_() <= bonusRollChance) {
                    player.m_9236_().m_6263_(null, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 3.0f, (2.0f + player.m_9236_().m_213780_().m_188501_() * 0.3f) * 0.99f);
                    ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), 3, 0.0, 0.0, 0.0, 0.0);
                    ArrayList newDrops = new ArrayList(event.getDrops());
                    for (ItemEntity item : newDrops) {
                        if (item.m_32055_().m_41782_() && item.m_32055_().m_41783_().m_128441_(ITEM_MARKER)) continue;
                        for (int i = 0; i < bonusLootRolls; ++i) {
                            event.getDrops().add(new ItemEntity(player.m_9236_(), item.m_20185_(), item.m_20186_(), item.m_20189_(), item.m_32055_().m_41777_()));
                        }
                    }
                    double mv1 = 0.1;
                    double mvxz = 0.3;
                    for (ItemEntity item : event.getDrops()) {
                        if (item.m_32055_().m_41720_().isDamageable(item.m_32055_())) continue;
                        item.m_6034_(mob.m_20185_(), mob.m_20186_(), mob.m_20189_());
                        double rando = mob.m_9236_().m_213780_().m_188500_();
                        item.m_20334_(-mv1 + rando * mvxz, mv1 + rando * 0.4, -mv1 + rando * mvxz);
                    }
                }
            }
        }
        event.getDrops().stream().forEach(entry -> {
            ItemStack stack = entry.m_32055_();
            if (stack.m_41782_()) {
                assert (stack.m_41783_() != null);
                if (stack.m_41783_().m_128441_(ITEM_MARKER)) {
                    stack.m_41783_().m_128473_(ITEM_MARKER);
                    if (stack.m_41783_().m_128456_()) {
                        stack.m_41751_(null);
                    }
                }
            }
            entry.m_32045_(stack);
        });
    }
}

