/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.event;

import com.google.common.collect.Multimap;
import com.uberhelixx.flatlights.FlatLightsCommonConfig;
import com.uberhelixx.flatlights.common.effect.EntangledEffect;
import com.uberhelixx.flatlights.common.effect.ModEffects;
import com.uberhelixx.flatlights.common.enchantments.ModEnchantments;
import com.uberhelixx.flatlights.startup.registry.ModDamageTypes;
import com.uberhelixx.flatlights.util.MiscUtils;
import com.uberhelixx.flatlights.util.ParticleHelper;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="flatlights", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EnchantmentEvents {
    protected static final UUID LIFTED_TRUCK_ARMOR = UUID.fromString("2e8190a1-c663-42d9-8921-1251d45c3efa");

    @SubscribeEvent
    public static void entangleDmg(LivingHurtEvent event) {
        LivingEntity attacker;
        LivingEntity target = event.getEntity();
        LivingEntity livingEntity = attacker = event.getSource().m_7639_() instanceof LivingEntity ? (LivingEntity)event.getSource().m_7639_() : null;
        if (attacker == null) {
            return;
        }
        double searchRadius = (Double)FlatLightsCommonConfig.entangledRange.get();
        if (!event.getSource().m_276093_(ModDamageTypes.ENTANGLED) && target.m_21023_((MobEffect)ModEffects.ENTANGLED.get())) {
            List entities = target.m_9236_().m_45933_((Entity)target, target.m_20191_().m_82377_(searchRadius, searchRadius, searchRadius));
            for (Entity instance : entities) {
                if (instance == target || !(instance instanceof LivingEntity) || !((LivingEntity)instance).m_21023_((MobEffect)ModEffects.ENTANGLED.get())) continue;
                MiscUtils.infoLog("[Quantum Strike Enchant] Entangled mob: " + instance.m_7755_());
                instance.f_19802_ = 0;
                instance.m_6469_((DamageSource)ModDamageTypes.causeEntangledDamage((Entity)attacker), event.getAmount() * MiscUtils.damagePercentCalc((Integer)FlatLightsCommonConfig.entangledPercent.get()));
                instance.f_19802_ = 20;
            }
        }
    }

    @SubscribeEvent
    public static void removeFromEntangledTeam(LivingDeathEvent event) {
        LivingEntity entityIn = event.getEntity();
        Scoreboard scoreboard = entityIn.m_9236_().m_6188_();
        if (entityIn.m_5647_() != null && entityIn.m_5647_() == scoreboard.m_83489_(EntangledEffect.getEntangledTeam())) {
            scoreboard.m_6519_(entityIn.m_20149_(), scoreboard.m_83489_(EntangledEffect.getEntangledTeam()));
        }
    }

    @SubscribeEvent
    public static void blackhandKnockback(LivingKnockBackEvent event) {
        LivingEntity user = event.getEntity().m_271686_();
        ItemStack weapon = null;
        if (user != null) {
            weapon = user.m_21205_();
        }
        if (weapon != null && EnchantmentHelper.m_44836_((Enchantment)((Enchantment)ModEnchantments.BLACKHAND.get()), (LivingEntity)user) > 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void xpDropMultiplier(LivingExperienceDropEvent event) {
        Player user = event.getAttackingPlayer();
        int baseXpAmount = event.getDroppedExperience();
        if (user == null) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            return;
        }
        if (event.getEntity() instanceof Player && event.getEntity().m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
            return;
        }
        Level world = user.m_9236_();
        int level = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)ModEnchantments.FLASH_OF_BRILLIANCE.get()), (LivingEntity)user);
        if (level != 0) {
            double chanceCap = (Double)FlatLightsCommonConfig.fobChanceCap.get();
            double activeChance = (double)level * 0.05;
            if (Math.random() <= Math.min(activeChance, chanceCap)) {
                event.setDroppedExperience(10 * baseXpAmount);
                world.m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11932_, SoundSource.NEUTRAL, 5.0f, 1.0f);
                MiscUtils.infoLog("[Flash of Brilliance] Triggered XP multiplier.");
                MiscUtils.infoLog("[Flash of Brilliance] Base XP value: " + baseXpAmount + " | New XP value: " + baseXpAmount * 10);
            }
        }
    }

    @SubscribeEvent
    public static void liftedPickupTruckArmor(LivingEquipmentChangeEvent event) {
        LivingEntity entity = event.getEntity();
        Iterable armorPieces = entity.m_6168_();
        AttributeInstance armor = entity.m_21051_(Attributes.f_22284_);
        if (armor != null) {
            armor.m_22120_(LIFTED_TRUCK_ARMOR);
        }
        double totalArmor = 0.0;
        for (ItemStack armorPart : armorPieces) {
            if (!(EnchantmentEvents.whatArmorSlot(armorPart) != EquipmentSlot.MAINHAND & armorPart.m_41793_()) || EnchantmentHelper.m_44836_((Enchantment)((Enchantment)ModEnchantments.LIFTED_PICKUP_TRUCK.get()), (LivingEntity)entity) <= 0) continue;
            Multimap oldMap = armorPart.m_41638_(EnchantmentEvents.whatArmorSlot(armorPart));
            Collection initialArmorValues = oldMap.get((Object)Attributes.f_22284_);
            for (AttributeModifier armorPoints : initialArmorValues) {
                totalArmor += armorPoints.m_22218_();
            }
            MiscUtils.infoLog("[Lifted Pickup Truck ARMOR] Cursed Armor Total: " + totalArmor);
        }
        if (totalArmor > 0.0 && armor != null) {
            armor.m_22118_(new AttributeModifier(LIFTED_TRUCK_ARMOR, "Lifted Truck Armor Modifier", totalArmor, AttributeModifier.Operation.ADDITION));
            MiscUtils.infoLog("[Lifted Pickup Truck ARMOR] Cursed Armor Added: " + totalArmor);
        }
    }

    private static EquipmentSlot whatArmorSlot(ItemStack item) {
        Item item2 = item.m_41720_();
        if (item2 instanceof ArmorItem) {
            ArmorItem armorPiece = (ArmorItem)item2;
            return armorPiece.m_40402_();
        }
        return EquipmentSlot.MAINHAND;
    }

    @SubscribeEvent
    public static void liftedPickupTruckDmg(LivingHurtEvent event) {
        float DMG_MULTIPLIER = 3.0f;
        LivingEntity target = event.getEntity();
        AttributeInstance armor = target.m_21051_(Attributes.f_22284_);
        if (armor != null && armor.m_22111_(LIFTED_TRUCK_ARMOR) != null && Objects.requireNonNull(armor.m_22111_(LIFTED_TRUCK_ARMOR)).m_22218_() > 0.0) {
            MiscUtils.infoLog("[Lifted Pickup Truck DAMAGE] Initial Damage: " + event.getAmount());
            MiscUtils.infoLog("[Lifted Pickup Truck DAMAGE] New Damage: " + event.getAmount() * DMG_MULTIPLIER);
            event.setAmount(event.getAmount() * DMG_MULTIPLIER);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void damageSourceConversion(LivingHurtEvent event) {
        LivingEntity target = event.getEntity();
        float damageAmount = event.getAmount();
        Entity attacker = event.getSource().m_7639_();
        if (!event.getSource().m_276093_(ModDamageTypes.PHYSICAL) && EnchantmentHelper.m_44836_((Enchantment)((Enchantment)ModEnchantments.NEUTRALIZER.get()), (LivingEntity)target) > 0) {
            MiscUtils.infoLog("[Neutralizer] Neutralizer enchantment triggered");
            MiscUtils.infoLog("[Neutralizer] Initial un-neutralized damage: " + damageAmount);
            event.setCanceled(true);
            EnchantmentEvents.doPhysDmg(target, attacker, damageAmount);
        }
    }

    private static void doPhysDmg(LivingEntity target, Entity attacker, float damageAmount) {
        MiscUtils.infoLog("[Neutralizer] Doing physical damage");
        target.f_19802_ = 0;
        if (attacker != null) {
            target.m_6469_((DamageSource)ModDamageTypes.causePhysicalDamage(attacker), damageAmount);
        } else {
            target.m_6469_((DamageSource)ModDamageTypes.causePhysicalDamage((Entity)target), damageAmount);
        }
    }

    @SubscribeEvent
    public static void arrowPulseDmgMiss(ProjectileImpactEvent event) {
        HitResult.Type hitResult = event.getRayTraceResult().m_6662_();
        Projectile projectile = event.getProjectile();
        if (projectile instanceof Arrow) {
            Arrow arrow = (Arrow)projectile;
            if (!hitResult.equals((Object)HitResult.Type.ENTITY)) {
                Entity entity;
                double searchRadius = (Double)FlatLightsCommonConfig.pulsingArrowRadius.get();
                if (arrow.m_19749_() != null && (entity = arrow.m_19749_()) instanceof LivingEntity) {
                    LivingEntity shooter = (LivingEntity)entity;
                    MiscUtils.infoLog("[Pulsing Arrow Damage Miss] Shooter of arrow: " + shooter.m_7755_());
                    int pulseLevel = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)ModEnchantments.PULSINGARROW.get()), (LivingEntity)shooter);
                    if (pulseLevel != 0) {
                        List entities = arrow.m_9236_().m_45933_((Entity)arrow, arrow.m_20191_().m_82377_(searchRadius, searchRadius, searchRadius));
                        for (Entity instance : entities) {
                            if (!(instance instanceof LivingEntity) || instance.m_7306_((Entity)arrow) || instance.m_7306_((Entity)shooter)) continue;
                            double arrowDamage = arrow.m_36789_();
                            float pulseDamage = (float)(2.0 * arrowDamage * (double)pulseLevel * (double)MiscUtils.damagePercentCalc((Integer)FlatLightsCommonConfig.pulsingPercent.get()));
                            instance.m_6469_((DamageSource)ModDamageTypes.causeIndirectPhysicalDamage((Entity)arrow, (Entity)shooter), pulseDamage);
                            MiscUtils.infoLog("[Pulsing Arrow Damage Miss] Pulse damaged mob: " + instance.m_7755_());
                            MiscUtils.infoLog("[Pulsing Arrow Damage Miss] Arrow damage: " + arrowDamage);
                            MiscUtils.infoLog("[Pulsing Arrow Damage Miss] Initial pulse damage: " + pulseDamage);
                        }
                        float[] hsbVals = Color.RGBtoHSB(36, 217, 153, null);
                        ParticleOptions pulseParticle = ParticleHelper.constructSimpleSpark(Color.getHSBColor(hsbVals[0], hsbVals[1], hsbVals[2]), 0.3f, 3, 1.0f);
                        ParticleHelper.createBall(pulseParticle, event.getRayTraceResult().m_82450_(), event.getEntity().m_9236_(), 3, 0.8f);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void arrowPulseDmgHit(LivingHurtEvent event) {
        LivingEntity shooter;
        LivingEntity livingEntity = shooter = event.getSource().m_7639_() instanceof LivingEntity ? (LivingEntity)event.getSource().m_7639_() : null;
        if (shooter == null) {
            return;
        }
        Entity arrow = event.getSource().m_7640_();
        DamageSource source = event.getSource();
        LivingEntity hitEntity = event.getEntity();
        int pulseLevel = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)ModEnchantments.PULSINGARROW.get()), (LivingEntity)shooter);
        MiscUtils.infoLog("[Pulsing Arrow Damage Hit] Source Entity: " + shooter);
        MiscUtils.infoLog("[Pulsing Arrow Damage Hit] Arrow: " + arrow);
        if (source.m_276093_(DamageTypes.f_268739_) && pulseLevel > 0) {
            double searchRadius = (Double)FlatLightsCommonConfig.pulsingArrowRadius.get();
            List entities = hitEntity.m_9236_().m_45933_((Entity)hitEntity, hitEntity.m_20191_().m_82377_(searchRadius, searchRadius, searchRadius));
            for (Entity instance : entities) {
                if (!(instance instanceof LivingEntity) || instance.m_7306_((Entity)hitEntity) || instance.m_7306_((Entity)shooter)) continue;
                double arrowDamage = event.getAmount();
                float pulseDamage = (float)(2.0 * arrowDamage * (double)pulseLevel * (double)MiscUtils.damagePercentCalc((Integer)FlatLightsCommonConfig.pulsingPercent.get()));
                instance.m_6469_((DamageSource)ModDamageTypes.causeIndirectPhysicalDamage(arrow, (Entity)shooter), pulseDamage);
                MiscUtils.infoLog("[Pulsing Arrow Damage HIT] Pulse damaged mob: " + instance.m_7755_());
                MiscUtils.infoLog("[Pulsing Arrow Damage HIT] Arrow damage: " + arrowDamage);
                MiscUtils.infoLog("[Pulsing Arrow Damage HIT] Initial pulse damage: " + pulseDamage);
            }
            if (hitEntity.m_9236_().m_5776_()) {
                MiscUtils.infoLog("[Pulsing Arrow Damage HIT] Trying particle spawn.");
                float[] hsbVals = Color.RGBtoHSB(36, 217, 153, null);
                ParticleOptions pulseParticle = ParticleHelper.constructSimpleSpark(Color.getHSBColor(hsbVals[0], hsbVals[1], hsbVals[2]), 0.3f, 3, 1.0f);
                Vec3 loc = new Vec3(hitEntity.m_20185_(), hitEntity.m_20186_() + (double)hitEntity.m_20206_(), hitEntity.m_20189_());
                ParticleHelper.createBall(pulseParticle, loc, hitEntity.m_9236_(), 3, 0.8f);
                Level level = hitEntity.m_9236_();
            }
        }
    }

    @SubscribeEvent
    public static void shimmerOverload(AnvilUpdateEvent event) {
        Integer currentEnchLevel;
        Enchantment enchantment;
        if (Objects.requireNonNull(event.getPlayer()).m_9236_().m_5776_()) {
            return;
        }
        ItemStack inputItem = event.getLeft();
        ItemStack enchantedBook = event.getRight();
        if (inputItem == null || enchantedBook == null || enchantedBook.m_41720_() != Items.f_42690_) {
            return;
        }
        Map itemMap = EnchantmentHelper.m_44831_((ItemStack)inputItem);
        Map bookMap = EnchantmentHelper.m_44831_((ItemStack)enchantedBook);
        HashMap<Enchantment, Integer> outputMap = new HashMap<Enchantment, Integer>(itemMap);
        boolean shimmerlvl2Only = false;
        if (bookMap.containsKey(ModEnchantments.SHIMMER2.get())) {
            boolean bl = shimmerlvl2Only = (Integer)bookMap.get(ModEnchantments.SHIMMER2.get()) == 2;
        }
        if (bookMap.isEmpty() || !shimmerlvl2Only || bookMap.size() != 1 || Math.random() <= 0.99999) {
            return;
        }
        for (Map.Entry bookEnchEntry : bookMap.entrySet()) {
            enchantment = (Enchantment)bookEnchEntry.getKey();
            if (enchantment == null) continue;
            currentEnchLevel = (Integer)itemMap.get(bookEnchEntry.getKey());
            Integer addValue = (Integer)bookEnchEntry.getValue();
            if (currentEnchLevel != null) continue;
            outputMap.put((Enchantment)bookEnchEntry.getKey(), addValue + 10);
        }
        for (Map.Entry existingEnch : itemMap.entrySet()) {
            enchantment = (Enchantment)existingEnch.getKey();
            if (enchantment == null) continue;
            currentEnchLevel = (Integer)existingEnch.getValue();
            if (currentEnchLevel >= enchantment.m_6586_() * (Integer)FlatLightsCommonConfig.enchantMultiplierCap.get()) {
                outputMap.put((Enchantment)existingEnch.getKey(), currentEnchLevel);
                continue;
            }
            outputMap.put((Enchantment)existingEnch.getKey(), currentEnchLevel + 10);
        }
        ItemStack enchantedItem = inputItem.m_41777_();
        EnchantmentHelper.m_44865_(outputMap, (ItemStack)enchantedItem);
        event.setOutput(enchantedItem);
    }

    @SubscribeEvent
    public static void fragmentationDamage(LivingDamageEvent event) {
        LivingEntity hitEntity = event.getEntity();
        Level world = hitEntity.m_9236_();
        int fragLevel = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)ModEnchantments.FRAGMENTATION.get()), (LivingEntity)hitEntity);
        if (fragLevel > 0) {
            float damageCap = hitEntity.m_21233_() / (float)(fragLevel + 1);
            MiscUtils.infoLog("[Fragmentation Hit] Fragmentation Level: " + fragLevel);
            MiscUtils.infoLog("[Fragmentation Hit] Incoming Damage: " + event.getAmount());
            MiscUtils.infoLog("[Fragmentation Hit] Fragmentation HP Cap: " + damageCap);
            if (event.getAmount() > damageCap) {
                MiscUtils.infoLog("[Fragmentation Hit] Fragmentation threshold exceeded");
                hitEntity.m_5496_(SoundEvents.f_12513_, 0.4f, 0.3f / (hitEntity.m_9236_().f_46441_.m_188501_() * 0.4f + 0.8f));
                event.setAmount(damageCap);
            }
        }
    }
}

