/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.event;

import com.uberhelixx.flatlights.FlatLightsClientConfig;
import com.uberhelixx.flatlights.common.item.ModItems;
import com.uberhelixx.flatlights.common.item.tools.PrismaticBladeMk2;
import com.uberhelixx.flatlights.common.network.PacketHandler;
import com.uberhelixx.flatlights.common.network.packets.PacketWriteNbt;
import com.uberhelixx.flatlights.util.MiscUtils;
import java.util.Iterator;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="flatlights", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PrismaticBladeMk2Events {
    @SubscribeEvent
    public static void droppedItem(ItemTossEvent event) {
        ItemEntity itemDrop = event.getEntity();
        ItemStack item = itemDrop.m_32055_();
        Player player = event.getPlayer();
        if (!(item.m_41720_() instanceof PrismaticBladeMk2)) {
            return;
        }
        if (MiscUtils.uuidCheck(player.m_20148_())) {
            itemDrop.m_32061_();
        }
        itemDrop.m_149678_();
        itemDrop.m_20331_(true);
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        CompoundTag persistent;
        Player playerIn = event.getEntity();
        if (!MiscUtils.uuidCheck(playerIn.m_20148_())) {
            return;
        }
        CompoundTag data = playerIn.getPersistentData();
        if (!data.m_128441_("PlayerPersisted")) {
            persistent = new CompoundTag();
            data.m_128365_("PlayerPersisted", (Tag)persistent);
        } else {
            persistent = data.m_128469_("PlayerPersisted");
        }
        if (persistent.m_128441_("flatlights.has_sword")) {
            boolean alreadyHave = false;
            for (int i = 0; i < playerIn.m_150109_().f_35974_.size(); ++i) {
                ItemStack stack = (ItemStack)playerIn.m_150109_().f_35974_.get(i);
                if (!(stack.m_41720_() instanceof PrismaticBladeMk2)) continue;
                alreadyHave = true;
            }
            persistent.m_128379_("flatlights.has_sword", alreadyHave);
        }
        if (!persistent.m_128441_("flatlights.has_sword") || !persistent.m_128471_("flatlights.has_sword")) {
            persistent.m_128379_("flatlights.has_sword", true);
            playerIn.m_150109_().m_36054_(new ItemStack((ItemLike)ModItems.PRISMATIC_BLADEMK2.get()));
        }
        if (!persistent.m_128441_("flatlights.core_tracker")) {
            persistent.m_128405_("flatlights.core_tracker", 0);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePlayerCloneEvent(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Player player = event.getEntity();
        Player oldPlayer = event.getOriginal();
        if (player.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
            return;
        }
        for (int i = 0; i < oldPlayer.m_150109_().f_35974_.size(); ++i) {
            ItemStack stack = (ItemStack)oldPlayer.m_150109_().f_35974_.get(i);
            if (!(stack.m_41720_() instanceof PrismaticBladeMk2) || !PrismaticBladeMk2Events.addToPlayerInventory(player, stack)) continue;
            oldPlayer.m_150109_().f_35974_.set(i, (Object)ItemStack.f_41583_);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePlayerDropsEvent(LivingDropsEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (player.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
                return;
            }
            if (!MiscUtils.uuidCheck(player.m_20148_())) {
                return;
            }
            Iterator iter = event.getDrops().iterator();
            while (iter.hasNext()) {
                ItemStack stack = ((ItemEntity)iter.next()).m_32055_();
                if (!(stack.m_41720_() instanceof PrismaticBladeMk2) || !PrismaticBladeMk2Events.addToPlayerInventory(player, stack)) continue;
                iter.remove();
            }
        }
    }

    private static boolean addToPlayerInventory(Player player, ItemStack stack) {
        if (stack.m_41619_() || player == null) {
            return false;
        }
        Inventory inv = player.m_150109_();
        for (int i = 0; i < inv.f_35974_.size(); ++i) {
            if (!((ItemStack)inv.f_35974_.get(i)).m_41619_()) continue;
            inv.f_35974_.set(i, (Object)stack.m_41777_());
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void killMobs(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Entity killer = event.getSource().m_7639_();
        if (killer instanceof Player) {
            Player player = (Player)killer;
            if (entity instanceof LivingEntity) {
                LivingEntity mob = entity;
                Level level = player.m_9236_();
                ItemStack tool = player.m_21205_();
                if (!(tool.m_41720_() instanceof PrismaticBladeMk2)) {
                    return;
                }
                CompoundTag tag = tool.m_41784_();
                if (tag.m_128456_() || !PrismaticBladeMk2.hasBladeTags(tag)) {
                    tag = PrismaticBladeMk2.putFreshTags(tag);
                    tool.m_41751_(tag);
                    if (player.m_9236_().m_5776_()) {
                        PacketHandler.sendToServer(new PacketWriteNbt(tag, tool));
                    }
                }
                int oldCurrCores = tag.m_128451_("flatlights.curr_cores");
                int oldCurrTier = tag.m_128451_("flatlights.tier");
                int totalCores = tag.m_128451_("flatlights.total_cores");
                int gainedCores = Math.max(Math.round(mob.m_21233_() / 20.0f), 1);
                int newCurrCores = oldCurrCores + gainedCores;
                int bladeIter = oldCurrTier;
                int coreCheckCount = newCurrCores;
                MiscUtils.infoLog("[core math] gainedCores = " + gainedCores);
                MiscUtils.infoLog("[core math] oldCurrCores = " + oldCurrCores);
                MiscUtils.infoLog("[core math] newCurrCores = " + newCurrCores);
                while (bladeIter > 1) {
                    coreCheckCount += --bladeIter * 1000;
                }
                MiscUtils.infoLog("[core math] old totalCores = " + totalCores);
                MiscUtils.infoLog("[core math] coreCheckCount = " + coreCheckCount);
                if (totalCores != coreCheckCount) {
                    totalCores = coreCheckCount;
                }
                int playerTracker = 0;
                if (PrismaticBladeMk2.hasCoreTracker(player)) {
                    playerTracker = PrismaticBladeMk2.getPlayerCores(player);
                    MiscUtils.infoLog("[core math] playerCoreCount = " + playerTracker);
                    if (playerTracker < totalCores) {
                        MiscUtils.infoLog("[core math] playerTracker <= totalCores");
                        PrismaticBladeMk2.setPlayerCores(player, totalCores);
                    } else {
                        MiscUtils.infoLog("[core math] playerTracker > totalCores");
                        int coreDiff = playerTracker - totalCores;
                        newCurrCores = oldCurrCores + (gainedCores += coreDiff);
                        MiscUtils.infoLog("[core math] coreDiff = " + coreDiff);
                        MiscUtils.infoLog("[core math] gainedCores = " + gainedCores);
                        MiscUtils.infoLog("[core math] newCurrCores = " + newCurrCores);
                    }
                }
                String coreGainText = " core.";
                if (newCurrCores - oldCurrCores > 1) {
                    coreGainText = " cores.";
                }
                Component mobName = mob.m_7755_();
                MutableComponent killMessage = Component.m_237113_((String)("You have slain a " + mobName + " and gained ")).m_7220_((Component)Component.m_237113_((String)String.valueOf(newCurrCores - oldCurrCores)).m_130940_(ChatFormatting.LIGHT_PURPLE)).m_7220_((Component)Component.m_237113_((String)coreGainText));
                if (((Boolean)FlatLightsClientConfig.coreNoti.get()).booleanValue() && player.m_9236_().m_5776_()) {
                    player.m_5661_((Component)killMessage, true);
                }
                int newTier = oldCurrTier;
                while (newCurrCores > oldCurrTier * 1000 && newTier < 7) {
                    newCurrCores -= oldCurrTier * 1000;
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11891_, SoundSource.PLAYERS, 0.2f, (1.0f + level.m_213780_().m_188501_() * 0.3f) * 0.99f);
                    oldCurrTier = ++newTier;
                }
                MiscUtils.infoLog("[core math END] totalCores + gainedCores = " + totalCores);
                MiscUtils.infoLog("[core math END] newCurrCores = " + newCurrCores);
                tag.m_128405_("flatlights.total_cores", totalCores);
                tag.m_128405_("flatlights.curr_cores", newCurrCores);
                tag.m_128405_("flatlights.tier", newTier);
                tool.m_41751_(tag);
                if (player.m_9236_().m_5776_()) {
                    PacketHandler.sendToServer(new PacketWriteNbt(tag, tool));
                }
            }
        }
    }
}

