/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.item;

import com.uberhelixx.flatlights.FlatLightsCommonConfig;
import com.uberhelixx.flatlights.common.entity.GravityLiftEntity;
import com.uberhelixx.flatlights.common.entity.GravityLiftProjectileEntity;
import com.uberhelixx.flatlights.util.TooltipHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GravityLiftItem
extends Item {
    public static int COOLDOWN_SECONDS = 5;

    public GravityLiftItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemstack = pPlayer.m_21120_(pUsedHand);
        pLevel.m_6263_((Player)null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11857_, SoundSource.NEUTRAL, 0.5f, 0.4f / (pLevel.f_46441_.m_188501_() * 0.4f + 0.8f));
        int TICK_MULTIPLIER = 20;
        pPlayer.m_36335_().m_41524_((Item)this, this.getCooldownSeconds() * TICK_MULTIPLIER);
        if (!pLevel.m_5776_()) {
            GravityLiftProjectileEntity gravityLiftProjectileEntity = new GravityLiftProjectileEntity((LivingEntity)pPlayer, pLevel);
            gravityLiftProjectileEntity.m_37251_((Entity)pPlayer, pPlayer.m_146909_(), pPlayer.m_146908_(), 0.0f, 0.4f, 0.0f);
            gravityLiftProjectileEntity.m_5602_((Entity)pPlayer);
            pLevel.m_7967_((Entity)gravityLiftProjectileEntity);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (Screen.m_96638_()) {
            TooltipHelper.formatUsage(pTooltipComponents, "tooltip.flatlights.gravity_lift_use");
        } else {
            MutableComponent cd = Component.m_237113_((String)("" + this.getCooldownSeconds())).m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)"s").m_130940_(ChatFormatting.WHITE));
            TooltipHelper.labelBrackets(pTooltipComponents, "Lift Cooldown", null, (Component)cd);
            MutableComponent lifetime = Component.m_237113_((String)("" + GravityLiftEntity.SECONDS)).m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)"s").m_130940_(ChatFormatting.WHITE));
            TooltipHelper.labelBrackets(pTooltipComponents, "Lift Lifetime", null, (Component)lifetime);
            TooltipHelper.shiftHint(pTooltipComponents);
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public int getCooldownSeconds() {
        if (FlatLightsCommonConfig.gravityLiftCooldown.get() != null) {
            return (Integer)FlatLightsCommonConfig.gravityLiftCooldown.get();
        }
        return COOLDOWN_SECONDS;
    }
}

