/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.item.armor;

import com.google.common.collect.ImmutableMap;
import com.uberhelixx.flatlights.FlatLightsCommonConfig;
import com.uberhelixx.flatlights.common.item.armor.ModArmorMaterial;
import com.uberhelixx.flatlights.util.ClientUtils;
import com.uberhelixx.flatlights.util.TooltipHelper;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BaseArmorItem
extends ArmorItem {
    private static final Map<ArmorMaterial, MobEffect> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put((Object)ModArmorMaterial.PRISMATIC, (Object)MobEffects.f_19618_).build();

    public BaseArmorItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        Player player;
        Player player2 = player = pEntity instanceof Player ? (Player)pEntity : null;
        if (!pLevel.m_5776_() && player != null && this.hasFullArmor(player)) {
            this.evaluateArmorEffects(player);
        }
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        TooltipHelper.labelBrackets(pTooltipComponents, "Set Effect", null, "Saturation", Style.f_131099_.m_131140_(ChatFormatting.GOLD));
        MutableComponent dmgReduceComponent = Component.m_237113_((String)(FlatLightsCommonConfig.armorDamageReduction.get() + "%")).m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)" bonus damage reduction when full set is equipped."));
        if (ClientUtils.getPlayer() != null) {
            int armorTotal = ClientUtils.getPlayer().m_21230_();
            float totalReduction = (float)((double)armorTotal * ((Double)FlatLightsCommonConfig.reductionPerPoint.get() / 100.0));
            float reductionRatioCap = (float)((Integer)FlatLightsCommonConfig.armorDamageReduction.get()).intValue() / 100.0f;
            float reductionRatio = Mth.m_14036_((float)totalReduction, (float)0.0f, (float)reductionRatioCap);
            DecimalFormat formatting = new DecimalFormat("#.##");
            formatting.setRoundingMode(RoundingMode.FLOOR);
            dmgReduceComponent = reductionRatio >= reductionRatioCap ? Component.m_237113_((String)formatting.format(reductionRatio * 100.0f)).m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)"/").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)(FlatLightsCommonConfig.armorDamageReduction.get() + "%")).m_130940_(ChatFormatting.GREEN)) : Component.m_237113_((String)formatting.format(reductionRatio * 100.0f)).m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237113_((String)"/").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)(FlatLightsCommonConfig.armorDamageReduction.get() + "%")).m_130940_(ChatFormatting.GREEN));
        }
        TooltipHelper.labelBrackets(pTooltipComponents, "Damage Reduction", null, (Component)dmgReduceComponent);
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public boolean m_8120_(ItemStack pStack) {
        return true;
    }

    void evaluateArmorEffects(Player player) {
        for (Map.Entry<ArmorMaterial, MobEffect> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            ArmorMaterial mapArmorMaterial = entry.getKey();
            MobEffect mapStatusEffect = entry.getValue();
            if (!BaseArmorItem.hasCorrectArmorSet(mapArmorMaterial, player)) continue;
            this.addStatusEffectForMaterial(player, mapArmorMaterial, mapStatusEffect);
        }
    }

    private void addStatusEffectForMaterial(Player player, ArmorMaterial mapArmorMaterial, MobEffect mapStatusEffect) {
        boolean hasPlayerEffect;
        boolean bl = hasPlayerEffect = !Objects.equals(player.m_21124_(mapStatusEffect), null);
        if (BaseArmorItem.hasCorrectArmorSet(mapArmorMaterial, player) && !hasPlayerEffect) {
            player.m_7292_(new MobEffectInstance(mapStatusEffect, 400, 0, true, false));
        }
    }

    public boolean hasFullArmor(Player player) {
        ItemStack boots = (ItemStack)player.m_150109_().f_35975_.get(0);
        ItemStack leggings = (ItemStack)player.m_150109_().f_35975_.get(1);
        ItemStack chestplate = (ItemStack)player.m_150109_().f_35975_.get(2);
        ItemStack helmet = (ItemStack)player.m_150109_().f_35975_.get(3);
        return !helmet.m_41619_() && !chestplate.m_41619_() && !leggings.m_41619_() && !boots.m_41619_();
    }

    public static boolean hasCorrectArmorSet(ArmorMaterial material, Player player) {
        ArmorItem boots = (ArmorItem)((ItemStack)player.m_150109_().f_35975_.get(0)).m_41720_();
        ArmorItem leggings = (ArmorItem)((ItemStack)player.m_150109_().f_35975_.get(1)).m_41720_();
        ArmorItem chestplate = (ArmorItem)((ItemStack)player.m_150109_().f_35975_.get(2)).m_41720_();
        ArmorItem helmet = (ArmorItem)((ItemStack)player.m_150109_().f_35975_.get(3)).m_41720_();
        return helmet.m_40401_() == material && chestplate.m_40401_() == material && leggings.m_40401_() == material && boots.m_40401_() == material;
    }

    public static boolean wearingHelm(Player player) {
        Item hatSlotItem;
        if (!((ItemStack)player.m_150109_().f_35975_.get(3)).m_41619_() && (hatSlotItem = ((ItemStack)player.m_150109_().f_35975_.get(3)).m_41720_()) instanceof ArmorItem) {
            ArmorItem helmet = (ArmorItem)hatSlotItem;
            return helmet.m_40401_() == ModArmorMaterial.PRISMATIC;
        }
        return false;
    }

    public static boolean wearingChest(Player player) {
        Item chestSlotItem;
        if (!((ItemStack)player.m_150109_().f_35975_.get(2)).m_41619_() && (chestSlotItem = ((ItemStack)player.m_150109_().f_35975_.get(2)).m_41720_()) instanceof ArmorItem) {
            ArmorItem chestplate = (ArmorItem)chestSlotItem;
            return chestplate.m_40401_() == ModArmorMaterial.PRISMATIC;
        }
        return false;
    }

    public static boolean wearingLegs(Player player) {
        Item pantsSlotItem;
        if (!((ItemStack)player.m_150109_().f_35975_.get(1)).m_41619_() && (pantsSlotItem = ((ItemStack)player.m_150109_().f_35975_.get(1)).m_41720_()) instanceof ArmorItem) {
            ArmorItem leggings = (ArmorItem)pantsSlotItem;
            return leggings.m_40401_() == ModArmorMaterial.PRISMATIC;
        }
        return false;
    }

    public static boolean wearingBoots(Player player) {
        Item bootsSlotItem;
        if (!((ItemStack)player.m_150109_().f_35975_.get(0)).m_41619_() && (bootsSlotItem = ((ItemStack)player.m_150109_().f_35975_.get(0)).m_41720_()) instanceof ArmorItem) {
            ArmorItem boots = (ArmorItem)bootsSlotItem;
            return boots.m_40401_() == ModArmorMaterial.PRISMATIC;
        }
        return false;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return super.damageItem(stack, 0, entity, onBroken);
    }
}

