/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.item.armor;

import com.uberhelixx.flatlights.common.item.ModItems;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public enum ModArmorMaterial implements ArmorMaterial
{
    PRISMATIC("prismatic", 40, new int[]{5, 12, 8, 5}, 30, SoundEvents.f_11679_, 5.0f, 0.25f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PRISMATIC_INGOT.get()}));

    private final String name;
    private final int durabilityMultiplier;
    private final int[] protectionAmounts;
    private final int enchantmentValue;
    private final SoundEvent equipSound;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<Ingredient> repairIngredient;
    private static final int[] BASE_DURABILITY;

    private ModArmorMaterial(String name, int durabilityMultiplier, int[] protectionAmounts, int enchantmentValue, SoundEvent equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.protectionAmounts = protectionAmounts;
        this.enchantmentValue = enchantmentValue;
        this.equipSound = equipSound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = repairIngredient;
    }

    public int m_266425_(ArmorItem.Type type) {
        return BASE_DURABILITY[type.ordinal()] * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.protectionAmounts[type.ordinal()];
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.equipSound;
    }

    public Ingredient m_6230_() {
        return this.repairIngredient.get();
    }

    public String m_6082_() {
        return "flatlights:" + this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        BASE_DURABILITY = new int[]{13, 15, 16, 11};
    }
}

