/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.item.curio;

import com.uberhelixx.flatlights.FlatLights;
import com.uberhelixx.flatlights.common.item.curio.BaseCurio;
import com.uberhelixx.flatlights.common.item.curio.CurioSetNames;
import com.uberhelixx.flatlights.common.item.curio.CurioTier;
import com.uberhelixx.flatlights.util.ClientUtils;
import com.uberhelixx.flatlights.util.MiscUtils;
import com.uberhelixx.flatlights.util.TooltipHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CurioUtils {
    public static final String TIER = "flatlights.curiotier";
    public static final String SET = "flatlights.curioset";
    public static final String CUBE_SLOT_ID = "flatlights.curios.cube";
    public static final String PRISM_SLOT_ID = "flatlights.curios.prism";
    public static final String SPHERE_SLOT_ID = "flatlights.curios.sphere";
    public static final String GROWTH_CAP = "flatlights.curioGrowthCap";
    public static final String GROWTH_TRACKER = "flatlights.curioGrowthTracker";
    public static final String SET_EFFECT_TOGGLE = "flatlights.curioSetToggle";
    public static final int DEFAULT_GROWTH_CAP = 1000;
    public static final float COMMON_CHANCE = 45.0f;
    public static final float RARE_CHANCE = 30.0f;
    public static final float EPIC_CHANCE = 15.0f;
    public static final float LEGENDARY_CHANCE = 9.0f;
    public static final float GROWTH_CHANCE = 1.0f;

    public static float rollCurioTier(Player playerIn) {
        float nextRoll = playerIn.m_9236_().m_213780_().m_188501_() * 100.0f;
        if (MiscUtils.uuidCheck(playerIn.m_20148_())) {
            nextRoll = Mth.m_14036_((float)(nextRoll + 20.0f), (float)0.0f, (float)nextRoll);
        }
        if (nextRoll < 45.0f) {
            return CurioTier.getModel(CurioTier.COMMON);
        }
        if (nextRoll < 75.0f) {
            return CurioTier.getModel(CurioTier.RARE);
        }
        if (nextRoll < 90.0f) {
            return CurioTier.getModel(CurioTier.EPIC);
        }
        if (nextRoll < 99.0f) {
            return CurioTier.getModel(CurioTier.LEGENDARY);
        }
        return CurioTier.getModel(CurioTier.GROWTH);
    }

    public static void setCurioNbt(Player playerIn, InteractionHand handIn, String setIn, @Nullable Float tierIn, @Nullable Integer growthCapIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        CompoundTag newTag = stack.m_41784_();
        if (!CurioUtils.rollCheck(newTag)) {
            float curioTier = tierIn != null ? tierIn.floatValue() : CurioUtils.rollCurioTier(playerIn);
            newTag.m_128350_(TIER, curioTier);
            newTag.m_128359_(SET, setIn);
            if (curioTier == CurioTier.getModel(CurioTier.GROWTH)) {
                int growthCap = growthCapIn != null ? growthCapIn : 1000;
                newTag.m_128405_(GROWTH_TRACKER, 0);
                newTag.m_128405_(GROWTH_CAP, growthCap);
            }
            stack.m_41751_(newTag);
        }
    }

    public static boolean rollCheck(CompoundTag itemTag) {
        if (itemTag == null) {
            return false;
        }
        return !itemTag.m_128456_() || itemTag.m_128441_(TIER) || itemTag.m_128441_(SET);
    }

    public static void getTierTooltip(ItemStack curio, List<Component> tooltipIn) {
        CompoundTag tag = curio.m_41783_();
        if (tag != null && tag.m_128441_(TIER)) {
            CurioTier curioTier = CurioUtils.getCurioTier(curio);
            String tierName = CurioTier.getName(curioTier);
            Style tierColor = CurioTier.getStyle(curioTier);
            TooltipHelper.labelBrackets(tooltipIn, "Tier", null, tierName, tierColor);
        } else {
            MiscUtils.infoLog("[Base Curio] Somehow we failed to put a tier on this curio???");
            TooltipHelper.labelBrackets(tooltipIn, "Tier", null, "Bugged Item", Style.f_131099_.m_131140_(ChatFormatting.RED));
        }
    }

    public static void getSetTooltip(ItemStack curio, List<Component> tooltipIn) {
        CompoundTag tag = curio.m_41783_();
        if (curio.m_41783_() != null && curio.m_41783_().m_128441_(SET)) {
            String setTranslationText = tag.m_128461_(SET);
            String setName = Component.m_237115_((String)setTranslationText).getString();
            TooltipHelper.labelBrackets(tooltipIn, "Set", null, setName, Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA));
        } else {
            MiscUtils.infoLog("[Base Curio] Somehow we failed to put a set on this curio???");
            TooltipHelper.labelBrackets(tooltipIn, "Tier", null, "Bugged Item", Style.f_131099_.m_131140_(ChatFormatting.RED));
        }
    }

    public static void getGrowthTooltip(ItemStack curio, boolean showCap, List<Component> tooltipIn) {
        CompoundTag tag = curio.m_41783_();
        if (curio.m_41783_() != null && curio.m_41783_().m_128441_(GROWTH_TRACKER)) {
            int growthTracker = tag.m_128451_(GROWTH_TRACKER);
            int growthCap = tag.m_128451_(GROWTH_CAP);
            float growthPercent = (float)growthTracker / (float)growthCap;
            Style colorProgress = Style.f_131099_.m_131140_(ChatFormatting.RED);
            if ((double)growthPercent > 0.33 && (double)growthPercent <= 0.66) {
                colorProgress = Style.f_131099_.m_131140_(ChatFormatting.YELLOW);
            } else if ((double)growthPercent > 0.66) {
                colorProgress = Style.f_131099_.m_131140_(ChatFormatting.GREEN);
            }
            MutableComponent formattedTracker = Component.m_237113_((String)String.valueOf(growthTracker)).m_130948_(colorProgress).m_7220_((Component)Component.m_237113_((String)"/").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)String.valueOf(growthCap)).m_130940_(ChatFormatting.GREEN));
            if (!showCap) {
                formattedTracker = Component.m_237113_((String)String.valueOf(growthTracker)).m_130948_(colorProgress);
            }
            TooltipHelper.labelBrackets(tooltipIn, "Progress", null, (Component)formattedTracker);
        } else {
            MiscUtils.infoLog("[Base Curio] Why are we calling this for a non growth type curio???");
            TooltipHelper.labelBrackets(tooltipIn, "Progress", null, "Bugged Item", Style.f_131099_.m_131140_(ChatFormatting.RED));
        }
    }

    public static void getSetEffectTooltip(ItemStack curio, List<Component> tooltipIn) {
        CompoundTag tag = curio.m_41783_();
        String setEffect = "Nothing";
        Style color = Style.f_131099_.m_131140_(ChatFormatting.LIGHT_PURPLE);
        if (tag != null && !tag.m_128456_()) {
            if (tag.m_128441_(SET_EFFECT_TOGGLE)) {
                color = tag.m_128471_(SET_EFFECT_TOGGLE) && CurioUtils.canTriggerSetEffect(ClientUtils.getPlayer()) ? Style.f_131099_.m_131140_(ChatFormatting.GREEN) : Style.f_131099_.m_131140_(ChatFormatting.RED);
            }
            setEffect = Component.m_237115_((String)CurioSetNames.getEffect(CurioSetNames.getName(curio))).getString();
        }
        TooltipHelper.labelBrackets(tooltipIn, "Set Effect", null, setEffect, color);
    }

    public static void getSetDescriptionTooltip(ItemStack curio, List<Component> tooltipIn) {
        CompoundTag tag = curio.m_41783_();
        String setEffect = "Nothing";
        Style color = Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE);
        if (tag != null && !tag.m_128456_()) {
            setEffect = Component.m_237115_((String)CurioSetNames.getDescription(CurioSetNames.getName(curio))).getString();
        }
        TooltipHelper.labelBrackets(tooltipIn, "Effect Description", null, setEffect, color);
    }

    public static CurioTier getCurioTier(ItemStack curio) {
        CompoundTag tag = curio.m_41783_();
        if (tag != null && tag.m_128441_(TIER)) {
            float curioTier = tag.m_128457_(TIER);
            if (curioTier == CurioTier.getModel(CurioTier.COMMON)) {
                return CurioTier.COMMON;
            }
            if (curioTier == CurioTier.getModel(CurioTier.RARE)) {
                return CurioTier.RARE;
            }
            if (curioTier == CurioTier.getModel(CurioTier.EPIC)) {
                return CurioTier.EPIC;
            }
            if (curioTier == CurioTier.getModel(CurioTier.LEGENDARY)) {
                return CurioTier.LEGENDARY;
            }
            if (curioTier == CurioTier.getModel(CurioTier.GROWTH)) {
                return CurioTier.GROWTH;
            }
        }
        MiscUtils.infoLog("[Base Curio] No matching tier value.");
        return CurioTier.ERROR;
    }

    public static float getTierMultiplier(ItemStack curio) {
        CurioTier curioTier = CurioUtils.getCurioTier(curio);
        return CurioTier.getMultiplier(curioTier);
    }

    public static List<ItemStack> getWornCurios(Player playerIn) {
        int slotIndex;
        Map<String, ICurioStacksHandler> curioSlots = CurioUtils.getWornCurioSlots(playerIn);
        if (curioSlots.isEmpty()) {
            return null;
        }
        ArrayList<ItemStack> curioList = new ArrayList<ItemStack>();
        for (slotIndex = 0; slotIndex < curioSlots.get(CUBE_SLOT_ID).getSlots(); ++slotIndex) {
            curioList.add(curioSlots.get(CUBE_SLOT_ID).getStacks().getStackInSlot(slotIndex));
        }
        for (slotIndex = 0; slotIndex < curioSlots.get(PRISM_SLOT_ID).getSlots(); ++slotIndex) {
            curioList.add(curioSlots.get(PRISM_SLOT_ID).getStacks().getStackInSlot(slotIndex));
        }
        for (slotIndex = 0; slotIndex < curioSlots.get(SPHERE_SLOT_ID).getSlots(); ++slotIndex) {
            curioList.add(curioSlots.get(SPHERE_SLOT_ID).getStacks().getStackInSlot(slotIndex));
        }
        return curioList;
    }

    public static Map<String, ICurioStacksHandler> getWornCurioSlots(Player playerIn) {
        HashMap<String, ICurioStacksHandler> curioInv = new HashMap<String, ICurioStacksHandler>();
        try {
            CuriosApi.getCuriosInventory((LivingEntity)playerIn).ifPresent(curiosInventory -> {
                Map curios = curiosInventory.getCurios();
                curioInv.put(CUBE_SLOT_ID, (ICurioStacksHandler)curios.get(CUBE_SLOT_ID));
                curioInv.put(PRISM_SLOT_ID, (ICurioStacksHandler)curios.get(PRISM_SLOT_ID));
                curioInv.put(SPHERE_SLOT_ID, (ICurioStacksHandler)curios.get(SPHERE_SLOT_ID));
            });
        }
        catch (Exception e) {
            FlatLights.LOGGER.error("[CurioUtils#getWornCurioSlots] Could not get curio inventory from player. Returning empty map.");
        }
        return curioInv;
    }

    public static boolean canTriggerSetEffect(Player playerIn) {
        String cubeSet = null;
        String prismSet = null;
        String sphereSet = null;
        Map<String, ICurioStacksHandler> curios = CurioUtils.getWornCurioSlots(playerIn);
        if (curios.isEmpty()) {
            return false;
        }
        if (curios.get(CUBE_SLOT_ID).getSlots() == 1 && curios.get(PRISM_SLOT_ID).getSlots() == 1 && curios.get(SPHERE_SLOT_ID).getSlots() == 1) {
            ItemStack sphere;
            ItemStack prism;
            ItemStack cube = curios.get(CUBE_SLOT_ID).getStacks().getStackInSlot(0);
            if (cube.m_41783_() != null && cube.m_41783_().m_128441_(SET)) {
                cubeSet = cube.m_41783_().m_128461_(SET);
            }
            if ((prism = curios.get(PRISM_SLOT_ID).getStacks().getStackInSlot(0)).m_41783_() != null && prism.m_41783_().m_128441_(SET)) {
                prismSet = prism.m_41783_().m_128461_(SET);
            }
            if ((sphere = curios.get(SPHERE_SLOT_ID).getStacks().getStackInSlot(0)).m_41783_() != null && sphere.m_41783_().m_128441_(SET)) {
                sphereSet = sphere.m_41783_().m_128461_(SET);
            }
        }
        if (cubeSet == null || prismSet == null || sphereSet == null) {
            return false;
        }
        return cubeSet.equals(prismSet) && cubeSet.equals(sphereSet);
    }

    public static String getSetEffect(Player playerIn) {
        String setName = null;
        if (CurioUtils.canTriggerSetEffect(playerIn)) {
            List<ItemStack> curios = CurioUtils.getWornCurios(playerIn);
            assert (curios != null);
            CompoundTag firstCurioTag = curios.get(0).m_41783_();
            setName = firstCurioTag != null ? firstCurioTag.m_128461_(SET) : null;
        }
        return setName;
    }

    public static boolean correctSetEffect(Player playerIn, String curioSetIn) {
        return CurioUtils.getSetEffect(playerIn) != null && CurioUtils.getSetEffect(playerIn).equals(curioSetIn) && CurioUtils.canTriggerSetEffect(playerIn);
    }

    public static int getGrowthTracker(ItemStack curio) {
        CompoundTag tag = curio.m_41783_();
        if (tag == null || tag.m_128456_()) {
            return 0;
        }
        if (CurioUtils.getCurioTier(curio) == CurioTier.GROWTH && tag.m_128441_(GROWTH_TRACKER) && tag.m_128441_(GROWTH_CAP)) {
            return tag.m_128451_(GROWTH_TRACKER);
        }
        return 0;
    }

    public static void addSetToggle(ItemStack curio) {
        CompoundTag tag = curio.m_41783_();
        if (tag != null && !tag.m_128456_()) {
            tag.m_128379_(SET_EFFECT_TOGGLE, false);
        }
    }

    public static void toggleSetEffect(ItemStack curioIn, Player playerIn) {
        if (!playerIn.m_9236_().m_5776_() && curioIn.m_41720_() instanceof BaseCurio) {
            if (CurioUtils.canTriggerSetEffect(playerIn)) {
                boolean active = curioIn.m_41784_().m_128441_(SET_EFFECT_TOGGLE) && curioIn.m_41784_().m_128471_(SET_EFFECT_TOGGLE);
                curioIn.m_41784_().m_128379_(SET_EFFECT_TOGGLE, !active);
                MutableComponent toggleMsg = Component.m_237113_((String)"Toggled curio effect ").m_7220_((Component)Component.m_237113_((String)"on.").m_130940_(ChatFormatting.GREEN));
                MiscUtils.modeSwitchSound(playerIn, !active);
                if (active) {
                    toggleMsg = Component.m_237113_((String)"Toggled curio effect ").m_7220_((Component)Component.m_237113_((String)"off.").m_130940_(ChatFormatting.RED));
                }
                playerIn.m_5661_((Component)toggleMsg, true);
            } else {
                MutableComponent toggleMsg = Component.m_237113_((String)"Cannot toggle curio set effect.");
                playerIn.m_5661_((Component)toggleMsg, true);
            }
        }
    }

    public static ItemStack getCurioFromSlot(Player playerIn, String slotIn) {
        Map<String, ICurioStacksHandler> curioSlots = CurioUtils.getWornCurioSlots(playerIn);
        if (curioSlots.isEmpty()) {
            return null;
        }
        ItemStack curio = null;
        for (int slotIndex = 0; slotIndex < curioSlots.get(slotIn).getSlots(); ++slotIndex) {
            curio = curioSlots.get(slotIn).getStacks().getStackInSlot(slotIndex);
        }
        return curio;
    }

    public static Player getPlayer(SlotContext context) {
        return context.entity() instanceof Player ? (Player)context.entity() : null;
    }
}

