/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.item.curio.dragon;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.uberhelixx.flatlights.FlatLightsCommonConfig;
import com.uberhelixx.flatlights.common.item.curio.BaseCurio;
import com.uberhelixx.flatlights.common.item.curio.CurioTier;
import com.uberhelixx.flatlights.common.item.curio.CurioUtils;
import com.uberhelixx.flatlights.common.network.PacketHandler;
import com.uberhelixx.flatlights.common.network.packets.PacketWriteNbt;
import com.uberhelixx.flatlights.startup.registry.ModDamageTypes;
import com.uberhelixx.flatlights.util.MiscUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class DragonCube
extends BaseCurio {
    protected static final UUID CUBE_ARMOR = new UUID(3497987723158374L, 9234012374839481L);
    protected static final UUID CUBE_TOUGHNESS = new UUID(1023798772315837L, 4474784559228915L);
    protected static final UUID CUBE_HEALTH = new UUID(4924895473291239L, 1923784738292572L);

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        CompoundTag stackTags = stack.m_41783_();
        if (stackTags == null || !CurioUtils.rollCheck(stackTags)) {
            CurioUtils.setCurioNbt(pPlayer, pUsedHand, "flatlights.curioset.dragon", null, null);
            CurioUtils.addSetToggle(stack);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CompoundTag tag = stack.m_41783_();
            if (tag != null && !tag.m_128456_() && CurioUtils.correctSetEffect(player, "flatlights.curioset.dragon") && tag.m_128441_("flatlights.curioSetToggle") && tag.m_128471_("flatlights.curioSetToggle")) {
                int growthProgress = CurioUtils.getGrowthTracker(stack);
                double baseRadius = (Double)FlatLightsCommonConfig.dragonSetRadius.get() > 0.0 ? (Double)FlatLightsCommonConfig.dragonSetRadius.get() : 6.0;
                double maxRadius = (Double)FlatLightsCommonConfig.dragonSetRadiusMax.get() >= baseRadius ? (Double)FlatLightsCommonConfig.dragonSetRadiusMax.get() : 32.0;
                double expansionRadius = Mth.m_14008_((double)((double)growthProgress + baseRadius), (double)baseRadius, (double)maxRadius);
                List entities = player.m_9236_().m_45933_((Entity)player, player.m_20191_().m_82400_(expansionRadius));
                for (Entity entity : entities) {
                    if (!(entity instanceof LivingEntity)) continue;
                    float distance = player.m_20270_(entity);
                    float percentMod = 1.0f - (float)((double)distance / expansionRadius);
                    float dmg = Math.max(player.m_21233_() - ((LivingEntity)entity).m_21233_(), 0.0f) * percentMod;
                    if (!(dmg > 0.0f)) continue;
                    entity.m_6469_((DamageSource)ModDamageTypes.causeEntangledDamage((Entity)player), dmg);
                }
            }
        }
        super.curioTick(slotContext, stack);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap oldMap = super.getAttributeModifiers(slotContext, uuid, stack);
        ArrayListMultimap newMap = ArrayListMultimap.create();
        CurioTier tier = null;
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("flatlights.curiotier")) {
            tier = CurioUtils.getCurioTier(stack);
        }
        if (tier != null) {
            double basePower = CurioUtils.getTierMultiplier(stack);
            double growthModifier = 0.0;
            double armorBase = 4.0;
            double toughnessBase = 4.0;
            double healthBase = 4.0;
            if (tier == CurioTier.GROWTH) {
                Player player;
                growthModifier = 1.0;
                Player player2 = player = slotContext.entity() instanceof Player ? (Player)slotContext.entity() : null;
                if (player != null) {
                    int coresFromPlayer = this.getCoresFromPlayer(player);
                    int cores = 0;
                    if (stack.m_41783_().m_128441_("flatlights.curioGrowthTracker")) {
                        int growthTracker = stack.m_41783_().m_128451_("flatlights.curioGrowthTracker");
                        if (growthTracker < coresFromPlayer) {
                            CompoundTag tag = stack.m_41783_();
                            tag.m_128405_("flatlights.curioGrowthTracker", coresFromPlayer);
                            if (player.m_9236_().m_5776_()) {
                                PacketHandler.sendToServer(new PacketWriteNbt(tag, stack));
                            }
                            cores = coresFromPlayer;
                        } else {
                            cores = growthTracker;
                        }
                    }
                    growthModifier = (double)cores * 0.01;
                }
            }
            newMap.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(CUBE_ARMOR, "Cube Armor Modifier", armorBase * basePower + growthModifier, AttributeModifier.Operation.ADDITION));
            newMap.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(CUBE_TOUGHNESS, "Cube Toughness Modifier", toughnessBase * basePower + growthModifier, AttributeModifier.Operation.ADDITION));
            newMap.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(CUBE_HEALTH, "Cube Health Modifier", healthBase * basePower + growthModifier, AttributeModifier.Operation.ADDITION));
            for (Attribute attribute : oldMap.keySet()) {
                newMap.putAll((Object)attribute, (Iterable)oldMap.get((Object)attribute));
            }
            return newMap;
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }

    public int getCoresFromPlayer(Player playerIn) {
        CompoundTag data = playerIn.getPersistentData();
        if (!MiscUtils.uuidCheck(playerIn.m_20148_())) {
            return 0;
        }
        if (!data.m_128441_("PlayerPersisted")) {
            return 0;
        }
        CompoundTag persistent = data.m_128469_("PlayerPersisted");
        if (persistent.m_128441_("flatlights.core_tracker")) {
            return persistent.m_128451_("flatlights.core_tracker");
        }
        return 0;
    }
}

