/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.item.curio.dragon;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.uberhelixx.flatlights.common.item.curio.BaseCurio;
import com.uberhelixx.flatlights.common.item.curio.CurioTier;
import com.uberhelixx.flatlights.common.item.curio.CurioUtils;
import com.uberhelixx.flatlights.common.network.PacketHandler;
import com.uberhelixx.flatlights.common.network.packets.PacketWriteNbt;
import com.uberhelixx.flatlights.util.MiscUtils;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class DragonPrism
extends BaseCurio {
    protected static final UUID PRISM_ATTACK = new UUID(3478945378634578L, 5934297823478934L);
    protected static final UUID PRISM_ATK_SPEED = new UUID(7895645902437454L, 3458723478923478L);

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        CompoundTag stackTags = stack.m_41783_();
        if (stackTags == null || !CurioUtils.rollCheck(stackTags)) {
            CurioUtils.setCurioNbt(pPlayer, pUsedHand, "flatlights.curioset.dragon", null, null);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap oldMap = super.getAttributeModifiers(slotContext, uuid, stack);
        ArrayListMultimap newMap = ArrayListMultimap.create();
        CurioTier tier = null;
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("flatlights.curiotier")) {
            tier = CurioUtils.getCurioTier(stack);
        }
        if (tier != null) {
            double basePower = CurioUtils.getTierMultiplier(stack);
            double growthModifier = 0.0;
            double attackBase = 2.0;
            double speedBase = 1.0;
            if (tier == CurioTier.GROWTH) {
                Player player;
                growthModifier = 1.0;
                Player player2 = player = slotContext.entity() instanceof Player ? (Player)slotContext.entity() : null;
                if (player != null) {
                    int coresFromPlayer = this.getCoresFromPlayer(player);
                    int cores = 0;
                    if (stack.m_41783_().m_128441_("flatlights.curioGrowthTracker")) {
                        int growthTracker = stack.m_41783_().m_128451_("flatlights.curioGrowthTracker");
                        if (growthTracker < coresFromPlayer) {
                            CompoundTag tag = stack.m_41783_();
                            tag.m_128405_("flatlights.curioGrowthTracker", coresFromPlayer);
                            if (player.m_9236_().m_5776_()) {
                                PacketHandler.sendToServer(new PacketWriteNbt(tag, stack));
                            }
                            cores = coresFromPlayer;
                        } else {
                            cores = growthTracker;
                        }
                    }
                    growthModifier = (double)cores * 0.01;
                }
            }
            newMap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(PRISM_ATTACK, "Prism Attack Modifier", attackBase * basePower + growthModifier, AttributeModifier.Operation.ADDITION));
            newMap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(PRISM_ATK_SPEED, "Prism Attack Speed Modifier", speedBase * basePower + growthModifier, AttributeModifier.Operation.ADDITION));
            for (Attribute attribute : oldMap.keySet()) {
                newMap.putAll((Object)attribute, (Iterable)oldMap.get((Object)attribute));
            }
            return newMap;
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }

    public int getCoresFromPlayer(Player playerIn) {
        CompoundTag data = playerIn.getPersistentData();
        if (!MiscUtils.uuidCheck(playerIn.m_20148_())) {
            return 0;
        }
        if (!data.m_128441_("PlayerPersisted")) {
            return 0;
        }
        CompoundTag persistent = data.m_128469_("PlayerPersisted");
        if (persistent.m_128441_("flatlights.core_tracker")) {
            return persistent.m_128451_("flatlights.core_tracker");
        }
        return 0;
    }
}

