/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.item.curio.shore;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.uberhelixx.flatlights.FlatLightsCommonConfig;
import com.uberhelixx.flatlights.common.item.curio.BaseCurio;
import com.uberhelixx.flatlights.common.item.curio.CurioTier;
import com.uberhelixx.flatlights.common.item.curio.CurioUtils;
import com.uberhelixx.flatlights.util.MiscUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import top.theillusivec4.curios.api.SlotContext;

public class ShoreCube
extends BaseCurio {
    protected static final UUID CUBE_ARMOR = new UUID(3749575636224749L, 1958534741473475L);
    protected static final UUID CUBE_TOUGHNESS = new UUID(5841692614492857L, 5830972419212842L);
    protected static final UUID CUBE_SWIM = new UUID(2039453239714276L, 9371506232647184L);

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        CompoundTag stackTags = stack.m_41783_();
        if (!CurioUtils.rollCheck(stackTags)) {
            CurioUtils.setCurioNbt(pPlayer, pUsedHand, "flatlights.curioset.shore", null, null);
            CurioUtils.addSetToggle(stack);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CompoundTag tag = stack.m_41783_();
            if (tag != null && !tag.m_128456_() && CurioUtils.correctSetEffect(player, "flatlights.curioset.shore") && tag.m_128441_("flatlights.curioSetToggle") && tag.m_128471_("flatlights.curioSetToggle")) {
                int growthProgress = CurioUtils.getGrowthTracker(stack);
                double baseRadius = (Double)FlatLightsCommonConfig.shoreSetRadius.get() > 0.0 ? (Double)FlatLightsCommonConfig.shoreSetRadius.get() : 16.0;
                double maxRadius = (Double)FlatLightsCommonConfig.shoreSetRadiusMax.get() >= baseRadius ? (Double)FlatLightsCommonConfig.shoreSetRadiusMax.get() : 32.0;
                double expansionRadius = Mth.m_14008_((double)((double)growthProgress + baseRadius), (double)baseRadius, (double)maxRadius);
                List entities = player.m_9236_().m_45933_((Entity)player, player.m_20191_().m_82400_(expansionRadius));
                for (Entity entity : entities) {
                    if (!(entity instanceof LivingEntity) || !entity.m_20069_() && !player.m_9236_().m_46471_()) continue;
                    MiscUtils.infoLog("[Shore Cube] trying to slow nearby entities");
                    float distance = player.m_20270_(entity);
                    float percentMod = 1.0f - (float)((double)distance / expansionRadius);
                    if ((double)percentMod >= 0.75) {
                        ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 600, 3, false, true));
                        continue;
                    }
                    if ((double)percentMod >= 0.5) {
                        ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 600, 2, false, true));
                        continue;
                    }
                    if ((double)percentMod >= 0.25) {
                        ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 600, 1, false, true));
                        continue;
                    }
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 600, 0, false, true));
                }
            }
        }
        super.curioTick(slotContext, stack);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap oldMap = super.getAttributeModifiers(slotContext, uuid, stack);
        ArrayListMultimap newMap = ArrayListMultimap.create();
        CurioTier tier = null;
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("flatlights.curiotier")) {
            tier = CurioUtils.getCurioTier(stack);
        }
        if (tier != null) {
            double basePower = CurioUtils.getTierMultiplier(stack);
            double growthModifier = 0.0;
            double armorBase = 4.0;
            double toughnessBase = 6.0;
            double swimBase = 1.5;
            if (tier == CurioTier.GROWTH) {
                growthModifier = 1.0;
                Player player = CurioUtils.getPlayer(slotContext);
                if (player != null) {
                    int cores = 0;
                    if (stack.m_41783_().m_128441_("flatlights.curioGrowthTracker")) {
                        cores = stack.m_41783_().m_128451_("flatlights.curioGrowthTracker");
                    }
                    growthModifier = (double)cores * 0.01;
                }
            }
            newMap.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(CUBE_ARMOR, "Cube Armor Modifier", armorBase * basePower + growthModifier, AttributeModifier.Operation.ADDITION));
            newMap.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(CUBE_TOUGHNESS, "Cube Toughness Modifier", toughnessBase * basePower + growthModifier, AttributeModifier.Operation.ADDITION));
            newMap.put((Object)((Attribute)ForgeMod.SWIM_SPEED.get()), (Object)new AttributeModifier(CUBE_SWIM, "Cube Swim Modifier", swimBase * basePower + growthModifier / 4.0, AttributeModifier.Operation.ADDITION));
            for (Attribute attribute : oldMap.keySet()) {
                newMap.putAll((Object)attribute, (Iterable)oldMap.get((Object)attribute));
            }
            return newMap;
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }
}

