/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.item.curio.shore;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.uberhelixx.flatlights.common.item.curio.BaseCurio;
import com.uberhelixx.flatlights.common.item.curio.CurioTier;
import com.uberhelixx.flatlights.common.item.curio.CurioUtils;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import top.theillusivec4.curios.api.SlotContext;

public class ShorePrism
extends BaseCurio {
    protected static final UUID PRISM_ATTACK = new UUID(5739475192359384L, 8492059172948392L);
    protected static final UUID PRISM_REACH_B = new UUID(9274837592187482L, 7893264938749288L);
    protected static final UUID PRISM_REACH_E = new UUID(8593616598346722L, 1927465828737546L);

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        CompoundTag stackTags = stack.m_41783_();
        if (!CurioUtils.rollCheck(stackTags)) {
            CurioUtils.setCurioNbt(pPlayer, pUsedHand, "flatlights.curioset.shore", null, null);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap oldMap = super.getAttributeModifiers(slotContext, uuid, stack);
        ArrayListMultimap newMap = ArrayListMultimap.create();
        CurioTier tier = null;
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("flatlights.curiotier")) {
            tier = CurioUtils.getCurioTier(stack);
        }
        if (tier != null) {
            double basePower = CurioUtils.getTierMultiplier(stack);
            double growthModifier = 0.0;
            double attackBase = 2.0;
            double reachBase = 1.0;
            if (tier == CurioTier.GROWTH) {
                growthModifier = 1.0;
                Player player = CurioUtils.getPlayer(slotContext);
                if (player != null) {
                    int cores = 0;
                    if (stack.m_41783_().m_128441_("flatlights.curioGrowthTracker")) {
                        cores = stack.m_41783_().m_128451_("flatlights.curioGrowthTracker");
                    }
                    growthModifier = (double)cores * 0.01;
                }
            }
            newMap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(PRISM_ATTACK, "Prism Attack Modifier", attackBase * basePower + growthModifier, AttributeModifier.Operation.ADDITION));
            newMap.put((Object)((Attribute)ForgeMod.BLOCK_REACH.get()), (Object)new AttributeModifier(PRISM_REACH_B, "Prism Block Reach Modifier", reachBase * basePower + growthModifier / 2.0, AttributeModifier.Operation.ADDITION));
            newMap.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(PRISM_REACH_E, "Prism Entity Reach Modifier", reachBase * basePower + growthModifier / 2.0, AttributeModifier.Operation.ADDITION));
            for (Attribute attribute : oldMap.keySet()) {
                newMap.putAll((Object)attribute, (Iterable)oldMap.get((Object)attribute));
            }
            return newMap;
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }
}

