/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.item.curio.shore;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.uberhelixx.flatlights.common.item.curio.BaseCurio;
import com.uberhelixx.flatlights.common.item.curio.CurioTier;
import com.uberhelixx.flatlights.common.item.curio.CurioUtils;
import com.uberhelixx.flatlights.startup.registry.ModAttributes;
import com.uberhelixx.flatlights.util.TooltipHelper;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;

public class ShoreSphere
extends BaseCurio {
    protected static final UUID SPHERE_DODGE = new UUID(8349240592831593L, 1748593285403285L);

    @Override
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        if (pStack.m_41783_() != null && !pStack.m_41783_().m_128456_() && !Screen.m_96638_()) {
            TooltipHelper.potionAttribute("Water Breathing", pTooltipComponents);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        CompoundTag stackTags = stack.m_41783_();
        if (!CurioUtils.rollCheck(stackTags)) {
            CurioUtils.setCurioNbt(pPlayer, pUsedHand, "flatlights.curioset.shore", null, null);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player = CurioUtils.getPlayer(slotContext);
        if (player != null && !ShoreSphere.hasWaterBreathing(player)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, Integer.MAX_VALUE, 0, true, false));
        }
        super.curioTick(slotContext, stack);
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        Player player = CurioUtils.getPlayer(slotContext);
        if (player != null) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, Integer.MAX_VALUE, 0, true, false));
        }
        super.onEquip(slotContext, prevStack, stack);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        Player player = CurioUtils.getPlayer(slotContext);
        if (player != null && ShoreSphere.hasWaterBreathing(player)) {
            player.m_21195_(MobEffects.f_19608_);
        }
        super.onUnequip(slotContext, newStack, stack);
    }

    private static boolean hasWaterBreathing(Player playerIn) {
        return !Objects.equals(playerIn.m_21124_(MobEffects.f_19608_), null);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap oldMap = super.getAttributeModifiers(slotContext, uuid, stack);
        ArrayListMultimap newMap = ArrayListMultimap.create();
        CurioTier tier = null;
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("flatlights.curiotier")) {
            tier = CurioUtils.getCurioTier(stack);
        }
        if (tier != null) {
            double basePower = CurioUtils.getTierMultiplier(stack);
            double growthModifier = 0.0;
            double dodgeBase = 8.0;
            if (tier == CurioTier.GROWTH) {
                growthModifier = 1.0;
                Player player = CurioUtils.getPlayer(slotContext);
                if (player != null) {
                    int cores = 0;
                    if (stack.m_41783_().m_128441_("flatlights.curioGrowthTracker")) {
                        cores = stack.m_41783_().m_128451_("flatlights.curioGrowthTracker");
                    }
                    growthModifier = (double)cores * 0.01;
                }
            }
            newMap.put((Object)((Attribute)ModAttributes.DODGE_CHANCE.get()), (Object)new AttributeModifier(SPHERE_DODGE, "Sphere Dodge Modifier", dodgeBase * basePower + growthModifier, AttributeModifier.Operation.ADDITION));
            for (Attribute attribute : oldMap.keySet()) {
                newMap.putAll((Object)attribute, (Iterable)oldMap.get((Object)attribute));
            }
            return newMap;
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }
}

