/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.item.curio.sun;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.uberhelixx.flatlights.FlatLightsCommonConfig;
import com.uberhelixx.flatlights.common.capability.ModCapabilities;
import com.uberhelixx.flatlights.common.item.curio.BaseCurio;
import com.uberhelixx.flatlights.common.item.curio.CurioTier;
import com.uberhelixx.flatlights.common.item.curio.CurioUtils;
import com.uberhelixx.flatlights.common.network.PacketHandler;
import com.uberhelixx.flatlights.common.network.packets.PacketRisingHeatUpdate;
import com.uberhelixx.flatlights.util.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.SlotContext;

public class SunCube
extends BaseCurio {
    protected static final UUID CUBE_ARMOR = new UUID(9357120593765298L, 4859356201958437L);
    protected static final UUID CUBE_HEALTH = new UUID(5783937593494583L, 1848239348948943L);

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        CompoundTag stackTags = stack.m_41783_();
        if (!CurioUtils.rollCheck(stackTags)) {
            CurioUtils.setCurioNbt(pPlayer, pUsedHand, "flatlights.curioset.sun", null, null);
            CurioUtils.addSetToggle(stack);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CompoundTag tag = stack.m_41783_();
            if (tag != null && !tag.m_128456_() && CurioUtils.correctSetEffect(player, "flatlights.curioset.sun") && tag.m_128441_("flatlights.curioSetToggle")) {
                int growthProgress = CurioUtils.getGrowthTracker(stack);
                double baseRadius = (Double)FlatLightsCommonConfig.sunSetRadius.get() > 0.0 ? (Double)FlatLightsCommonConfig.sunSetRadius.get() : 8.0;
                double maxRadius = (Double)FlatLightsCommonConfig.sunSetRadiusMax.get() >= baseRadius ? (Double)FlatLightsCommonConfig.sunSetRadiusMax.get() : 32.0;
                double expansionRadius = Mth.m_14008_((double)((double)growthProgress + baseRadius), (double)baseRadius, (double)maxRadius);
                List entities = player.m_9236_().m_45933_((Entity)player, player.m_20191_().m_82400_(expansionRadius + 1.0));
                for (Entity entity : entities) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity le = (LivingEntity)entity;
                    float distance = player.m_20270_((Entity)le);
                    boolean otherEffectUsers = false;
                    List surroundingPlayers = player.m_9236_().m_45933_((Entity)player, le.m_20191_().m_82400_(maxRadius + 1.0));
                    surroundingPlayers.removeIf(nextEntity -> !(nextEntity instanceof Player));
                    ArrayList<Player> activeSunEffectPlayers = new ArrayList<Player>();
                    for (Entity nextEntity2 : surroundingPlayers) {
                        CompoundTag checkPlayerTag;
                        Player playerToCheck;
                        ItemStack cubeCurio;
                        if (nextEntity2.equals((Object)player) || nextEntity2.equals((Object)le) || (cubeCurio = CurioUtils.getCurioFromSlot(playerToCheck = (Player)nextEntity2, "flatlights.curios.cube")) == null || (checkPlayerTag = cubeCurio.m_41782_() ? cubeCurio.m_41783_() : null) == null || !CurioUtils.correctSetEffect(playerToCheck, "flatlights.curioset.sun") || !checkPlayerTag.m_128441_("flatlights.curioSetToggle") || !checkPlayerTag.m_128471_("flatlights.curioSetToggle")) continue;
                        activeSunEffectPlayers.add(playerToCheck);
                    }
                    if (!activeSunEffectPlayers.isEmpty()) {
                        for (Player nextPlayer : activeSunEffectPlayers) {
                            double nextPlayerExpansionRadius;
                            ItemStack cubeCurio = CurioUtils.getCurioFromSlot(nextPlayer, "flatlights.curios.cube");
                            if (cubeCurio == null) continue;
                            int nextPlayerGrowthTracker = CurioUtils.getGrowthTracker(cubeCurio);
                            if (nextPlayerGrowthTracker > growthProgress) {
                                otherEffectUsers = true;
                                continue;
                            }
                            float nextPlayerDistance = nextPlayer.m_20270_((Entity)le);
                            if (!((double)nextPlayerDistance < (nextPlayerExpansionRadius = Mth.m_14008_((double)((double)nextPlayerGrowthTracker + baseRadius), (double)baseRadius, (double)maxRadius)))) continue;
                            otherEffectUsers = true;
                        }
                    }
                    if (ModCapabilities.getHeatedState(le).isPresent() && (double)distance < expansionRadius && tag.m_128471_("flatlights.curioSetToggle")) {
                        ModCapabilities.getHeatedState(le).ifPresent(heatedState -> {
                            if (!heatedState.isHeated()) {
                                heatedState.setHeatState(true);
                                MiscUtils.infoLog("[sun set effect] changed heat state to true");
                                if (!le.m_9236_().m_5776_()) {
                                    Supplier<Entity> supplier = () -> le;
                                    PacketHandler.sendToDistributor(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(supplier), new PacketRisingHeatUpdate(le.m_19879_(), true));
                                }
                            }
                        });
                    }
                    if (!ModCapabilities.getHeatedState(le).isPresent() || !((double)distance > expansionRadius && tag.m_128471_("flatlights.curioSetToggle")) && tag.m_128471_("flatlights.curioSetToggle") || otherEffectUsers) continue;
                    ModCapabilities.getHeatedState(le).ifPresent(heatedState -> {
                        if (heatedState.isHeated()) {
                            heatedState.setHeatState(false);
                            MiscUtils.infoLog("[sun set effect] changed heat state to false");
                            if (!le.m_9236_().m_5776_()) {
                                Supplier<Entity> supplier = () -> le;
                                PacketHandler.sendToDistributor(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(supplier), new PacketRisingHeatUpdate(le.m_19879_(), false));
                            }
                        }
                    });
                }
            }
        }
        super.curioTick(slotContext, stack);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap oldMap = super.getAttributeModifiers(slotContext, uuid, stack);
        ArrayListMultimap newMap = ArrayListMultimap.create();
        CurioTier tier = null;
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("flatlights.curiotier")) {
            tier = CurioUtils.getCurioTier(stack);
        }
        if (tier != null) {
            double basePower = CurioUtils.getTierMultiplier(stack);
            double growthModifier = 0.0;
            double armorBase = 4.0;
            double healthBase = 8.0;
            if (tier == CurioTier.GROWTH) {
                growthModifier = 1.0;
                Player player = CurioUtils.getPlayer(slotContext);
                if (player != null) {
                    int cores = 0;
                    if (stack.m_41783_().m_128441_("flatlights.curioGrowthTracker")) {
                        cores = stack.m_41783_().m_128451_("flatlights.curioGrowthTracker");
                    }
                    growthModifier = (double)cores * 0.01;
                }
            }
            newMap.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(CUBE_ARMOR, "Cube Armor Modifier", armorBase * basePower + growthModifier, AttributeModifier.Operation.ADDITION));
            newMap.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(CUBE_HEALTH, "Cube Health Modifier", healthBase * basePower + growthModifier, AttributeModifier.Operation.ADDITION));
            for (Attribute attribute : oldMap.keySet()) {
                newMap.putAll((Object)attribute, (Iterable)oldMap.get((Object)attribute));
            }
            return newMap;
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }
}

