/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.item.curio.sun;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.uberhelixx.flatlights.common.item.curio.BaseCurio;
import com.uberhelixx.flatlights.common.item.curio.CurioTier;
import com.uberhelixx.flatlights.common.item.curio.CurioUtils;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class SunPrism
extends BaseCurio {
    protected static final UUID PRISM_ATTACK = new UUID(4962834571068493L, 206739874329103L);

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        CompoundTag stackTags = stack.m_41783_();
        if (!CurioUtils.rollCheck(stackTags)) {
            CurioUtils.setCurioNbt(pPlayer, pUsedHand, "flatlights.curioset.sun", null, null);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap oldMap = super.getAttributeModifiers(slotContext, uuid, stack);
        ArrayListMultimap newMap = ArrayListMultimap.create();
        CurioTier tier = null;
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("flatlights.curiotier")) {
            tier = CurioUtils.getCurioTier(stack);
        }
        if (tier != null) {
            double basePower = CurioUtils.getTierMultiplier(stack);
            double growthModifier = 0.0;
            double attackBase = 4.0;
            if (tier == CurioTier.GROWTH) {
                growthModifier = 1.0;
                Player player = CurioUtils.getPlayer(slotContext);
                if (player != null) {
                    int cores = 0;
                    if (stack.m_41783_().m_128441_("flatlights.curioGrowthTracker")) {
                        cores = stack.m_41783_().m_128451_("flatlights.curioGrowthTracker");
                    }
                    growthModifier = (double)cores * 0.01;
                }
            }
            newMap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(PRISM_ATTACK, "Prism Attack Modifier", attackBase * basePower + growthModifier, AttributeModifier.Operation.ADDITION));
            for (Attribute attribute : oldMap.keySet()) {
                newMap.putAll((Object)attribute, (Iterable)oldMap.get((Object)attribute));
            }
            return newMap;
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }
}

