/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.item.tools;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.uberhelixx.flatlights.common.entity.Mk2ProjectileEntity;
import com.uberhelixx.flatlights.common.entity.ModEntityTypes;
import com.uberhelixx.flatlights.common.item.IMultiModeItem;
import com.uberhelixx.flatlights.common.network.PacketHandler;
import com.uberhelixx.flatlights.common.network.packets.PacketWriteNbt;
import com.uberhelixx.flatlights.startup.registry.ModDamageTypes;
import com.uberhelixx.flatlights.startup.registry.ModSoundEvents;
import com.uberhelixx.flatlights.util.ClientUtils;
import com.uberhelixx.flatlights.util.MiscUtils;
import com.uberhelixx.flatlights.util.TooltipHelper;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class PrismaticBladeMk2
extends SwordItem
implements IMultiModeItem {
    public static final int DEFAULT_MODE = 0;
    public static final int DMG_MODE = 1;
    public static final int AURA_MODE = 2;
    public static final int SPEAR_MODE = 3;
    public static final int TOTAL_TIERS = 7;
    public static final int TIER_MULTIPLIER = 1000;
    public static final int REACH_DISTANCE = 4;
    protected static final UUID E_REACH_MOD = new UUID(8395284197621950L, 9827436454129586L);
    protected static final UUID B_REACH_MOD = new UUID(3944721983778684L, 1834462839823474L);
    protected static final UUID CORE_DMG_MOD = new UUID(1292398942389764L, 5934782334298182L);

    public PrismaticBladeMk2(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        if (pState.m_60800_((BlockGetter)pLevel, pPos) != 0.0f) {
            pStack.m_41622_(0, pEntityLiving, livingEntity -> livingEntity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_8120_(ItemStack pStack) {
        return true;
    }

    public boolean m_41475_() {
        return true;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (Screen.m_96638_()) {
            if (ClientUtils.getPlayer() != null && !MiscUtils.uuidCheck(ClientUtils.getPlayer().m_20148_())) {
                TooltipHelper.formatUsage(pTooltipComponents, "tooltip.flatlights.prismatic_blademk2_default");
            } else {
                TooltipHelper.formatUsage(pTooltipComponents, "tooltip.flatlights.prismatic_blademk2_shift");
            }
        } else {
            if (ClientUtils.getPlayer() != null && MiscUtils.uuidCheck(ClientUtils.getPlayer().m_20148_()) && pStack.m_41782_() && pStack.m_41783_() != null) {
                if (pStack.m_41783_().m_128441_("flatlights.curr_cores")) {
                    PrismaticBladeMk2.getTierData(pStack, pTooltipComponents);
                    PrismaticBladeMk2.getCoreData(pStack, pTooltipComponents);
                }
                if (pStack.m_41783_().m_128441_("flatlights.mode")) {
                    PrismaticBladeMk2.getSwordState(pStack, pTooltipComponents);
                }
            }
            TooltipHelper.shiftHint(pTooltipComponents);
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public boolean m_5812_(ItemStack pStack) {
        return super.m_5812_(pStack) || pStack.m_41782_() && pStack.m_41783_().m_128441_("flatlights.mode") && pStack.m_41783_().m_128451_("flatlights.mode") > 0;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack pStack = pPlayer.m_21120_(pUsedHand);
        if (MiscUtils.uuidCheck(pPlayer.m_20148_()) && pStack.m_41783_() != null && pStack.m_41783_().m_128441_("flatlights.mode") && !pPlayer.m_6047_()) {
            CompoundTag tag = pStack.m_41783_();
            int mode = tag.m_128451_("flatlights.mode");
            if (mode == 1) {
                this.doDash(pPlayer.m_9236_(), pPlayer);
            }
            if (mode == 3) {
                pPlayer.m_6672_(pUsedHand);
                return InteractionResultHolder.m_19096_((Object)pStack);
            }
            if (mode == 0) {
                pPlayer.m_6672_(pUsedHand);
                return InteractionResultHolder.m_19096_((Object)pStack);
            }
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public int m_8105_(ItemStack pStack) {
        if (pStack.m_41783_() != null && pStack.m_41783_().m_128441_("flatlights.mode")) {
            int mode = pStack.m_41783_().m_128451_("flatlights.mode");
            if (mode == 3) {
                return 72000;
            }
            if (mode == 0) {
                return 72000;
            }
        }
        return super.m_8105_(pStack);
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        if (pStack.m_41782_() && pStack.m_41783_() != null && pStack.m_41783_().m_128441_("flatlights.mode") && pStack.m_41783_().m_128451_("flatlights.mode") == 3 && pLivingEntity instanceof Player) {
            Player playerEntity = (Player)pLivingEntity;
            int timeUsed = this.m_8105_(pStack) - pTimeCharged;
            if (timeUsed >= 2) {
                int riptideModifier;
                int n = riptideModifier = EnchantmentHelper.m_44932_((ItemStack)pStack) > 0 ? EnchantmentHelper.m_44932_((ItemStack)pStack) + 4 : 4;
                if (!pLevel.m_5776_()) {
                    pStack.m_41622_(0, (LivingEntity)playerEntity, player -> player.m_21190_(playerEntity.m_7655_()));
                }
                float yaw = playerEntity.m_146908_();
                float pitch = playerEntity.m_146909_();
                float xDir = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
                float yDir = -Mth.m_14031_((float)(pitch * ((float)Math.PI / 180)));
                float zDir = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
                float f4 = Mth.m_14116_((float)(xDir * xDir + yDir * yDir + zDir * zDir));
                float f5 = 3.0f * ((1.0f + (float)riptideModifier) / 4.0f);
                playerEntity.m_5997_((double)(xDir *= f5 / f4), (double)(yDir *= f5 / f4), (double)(zDir *= f5 / f4));
                playerEntity.m_204079_(15);
                if (playerEntity.m_20096_()) {
                    playerEntity.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                }
                SoundEvent soundEvent = SoundEvents.f_12519_;
                pLevel.m_6269_(null, (Entity)playerEntity, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        super.m_5551_(pStack, pLevel, pLivingEntity, pTimeCharged);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        double reachModifier;
        Multimap oldMap = super.getAttributeModifiers(slot, stack);
        ArrayListMultimap newMap = ArrayListMultimap.create();
        CompoundTag tag = stack.m_41783_();
        double attackModifier = tag != null && tag.m_128441_("flatlights.total_cores") ? (double)tag.m_128451_("flatlights.total_cores") * 0.001 : 0.0;
        double d = reachModifier = tag != null && tag.m_128441_("flatlights.mode") && tag.m_128451_("flatlights.mode") == 3 ? 4.0 : 0.0;
        if (slot == EquipmentSlot.MAINHAND) {
            newMap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(CORE_DMG_MOD, "Core Count Modifier", attackModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
            newMap.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(E_REACH_MOD, "E Reach Modifier", reachModifier, AttributeModifier.Operation.ADDITION));
            newMap.put((Object)((Attribute)ForgeMod.BLOCK_REACH.get()), (Object)new AttributeModifier(B_REACH_MOD, "B Reach Modifier", reachModifier, AttributeModifier.Operation.ADDITION));
        }
        for (Attribute attribute : oldMap.keySet()) {
            newMap.putAll((Object)attribute, (Iterable)oldMap.get((Object)attribute));
        }
        return newMap;
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pStack.m_41622_(0, pAttacker, livingEntity -> livingEntity.m_21166_(EquipmentSlot.MAINHAND));
        Level pLevel = pAttacker.m_9236_();
        if (MiscUtils.uuidCheck(pAttacker.m_20148_())) {
            pTarget.f_19802_ = 0;
            if (pStack.m_41783_() != null) {
                int damageBonus = 1;
                int tier = pStack.m_41783_().m_128451_("flatlights.tier");
                if (pStack.m_41783_().m_128451_("flatlights.mode") == 1) {
                    damageBonus = Math.max(pStack.m_41783_().m_128451_("flatlights.total_cores"), 1);
                }
                if (pStack.m_41783_().m_128451_("flatlights.mode") == 1) {
                    this.doSlash(pLevel, pTarget, pAttacker, damageBonus, tier);
                }
            }
        } else {
            if (pAttacker instanceof Player) {
                Player player = (Player)pAttacker;
                MutableComponent fail = Component.m_237113_((String)"This item does not belong to you.");
                player.m_5661_((Component)fail, false);
                pLevel.m_6263_(null, pTarget.m_20185_(), pTarget.m_20186_(), pTarget.m_20189_(), (SoundEvent)ModSoundEvents.SQUEAK.get(), SoundSource.PLAYERS, 0.5f, (1.0f + pLevel.m_213780_().m_188501_() * 0.3f) * 0.99f);
            }
            pTarget.m_5634_(pTarget.m_21233_());
            return false;
        }
        pTarget.f_19802_ = 0;
        return true;
    }

    @Override
    public int getNumModes(ItemStack stack) {
        return 4;
    }

    @Override
    public void onModeChange(Player pPlayer, ItemStack pStack) {
        if (MiscUtils.uuidCheck(pPlayer.m_20148_())) {
            CompoundTag tag = pStack.m_41784_();
            if (tag.m_128456_() || !PrismaticBladeMk2.hasBladeTags(tag)) {
                tag = PrismaticBladeMk2.putFreshTags(tag);
                pStack.m_41751_(tag);
                if (pPlayer.m_9236_().m_5776_()) {
                    PacketHandler.sendToServer(new PacketWriteNbt(tag, pStack));
                }
            } else {
                int bladeMode = tag.m_128451_("flatlights.mode");
                MutableComponent toggleText = bladeMode == 1 ? Component.m_237113_((String)"Mode Cycled: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)"[").m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)"Annihilation").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.AQUA)) : (bladeMode == 2 ? Component.m_237113_((String)"Mode Cycled: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)"[").m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)"Soul Sword").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.AQUA)) : (bladeMode == 3 ? Component.m_237113_((String)"Mode Cycled: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)"[").m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)"Spear").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.AQUA)) : Component.m_237113_((String)"Mode Cycled: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)"[").m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)"Inactive").m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.AQUA))));
                if (!pPlayer.m_9236_().m_5776_()) {
                    pPlayer.m_5661_((Component)toggleText, true);
                    MiscUtils.modeSwitchSound(pPlayer, bladeMode != 3);
                }
            }
        }
    }

    private void doSlash(Level levelIn, LivingEntity targetIn, LivingEntity attackerIn, int damageBonusIn, int tierIn) {
        targetIn.f_19802_ = 0;
        targetIn.m_6469_((DamageSource)ModDamageTypes.causeQuantumDamage((Entity)attackerIn), (float)damageBonusIn * ((float)tierIn / 7.0f));
        targetIn.f_19802_ = 0;
        levelIn.m_6263_(null, targetIn.m_20185_(), targetIn.m_20186_(), targetIn.m_20189_(), SoundEvents.f_11669_, SoundSource.PLAYERS, 0.1f, (1.0f + levelIn.m_213780_().m_188501_() * 0.3f) * 0.99f);
    }

    private void doDash(Level levelIn, Player playerIn) {
        Vec3 look = playerIn.m_20154_();
        levelIn.m_6263_(playerIn, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_11874_, SoundSource.PLAYERS, 0.75f, 1.5f + levelIn.m_213780_().m_188501_() * 0.05f);
        double dashFactor = 2.0;
        playerIn.m_20256_(look.m_82541_().m_82542_(dashFactor, dashFactor, dashFactor));
    }

    public static void shootProjectile(Level levelIn, Player player, BlockPos pos) {
        Vec3 look = player.m_20154_();
        if (!levelIn.m_5776_()) {
            Mk2ProjectileEntity bladeProjectile = new Mk2ProjectileEntity((EntityType<? extends AbstractArrow>)((EntityType)ModEntityTypes.MK2_PROJECTILE_ENTITY.get()), (LivingEntity)player, levelIn);
            bladeProjectile.m_6686_(look.m_7096_(), look.m_7098_(), look.m_7094_(), 2.5f, 0.0f);
            bladeProjectile.m_20242_(true);
            levelIn.m_7967_((Entity)bladeProjectile);
        }
        levelIn.m_5594_(null, pos, (SoundEvent)ModSoundEvents.VOID_PROJECTILE_SHOT.get(), SoundSource.PLAYERS, 0.3f, 0.8f + levelIn.m_213780_().m_188501_() * 0.05f);
    }

    private static void getTierData(ItemStack tool, List<Component> tooltipIn) {
        CompoundTag tag = tool.m_41783_();
        if (tool.m_41783_() != null && tool.m_41783_().m_128441_("flatlights.curr_cores")) {
            MutableComponent tierName;
            int cores = tag.m_128451_("flatlights.curr_cores");
            int tier = tag.m_128451_("flatlights.tier");
            switch (tier) {
                case 1: {
                    MutableComponent mutableComponent = Component.m_237113_((String)"Dormant").m_130940_(ChatFormatting.GRAY);
                    break;
                }
                case 2: {
                    MutableComponent mutableComponent = Component.m_237113_((String)"Awakened").m_130940_(ChatFormatting.WHITE);
                    break;
                }
                case 3: {
                    MutableComponent mutableComponent = Component.m_237113_((String)"Ascended").m_130940_(ChatFormatting.YELLOW);
                    break;
                }
                case 4: {
                    MutableComponent mutableComponent = Component.m_237113_((String)"Exalted").m_130940_(ChatFormatting.GOLD);
                    break;
                }
                case 5: {
                    MutableComponent mutableComponent = Component.m_237113_((String)"Sacred").m_130940_(ChatFormatting.RED);
                    break;
                }
                case 6: {
                    MutableComponent mutableComponent = Component.m_237113_((String)"Divine").m_130940_(ChatFormatting.LIGHT_PURPLE);
                    break;
                }
                case 7: {
                    MutableComponent mutableComponent = Component.m_237113_((String)"Primordial").m_130940_(ChatFormatting.DARK_PURPLE);
                    break;
                }
                default: {
                    MutableComponent mutableComponent = tierName = Component.m_237113_((String)"Unknown").m_130940_(ChatFormatting.BLACK).m_130940_(ChatFormatting.OBFUSCATED);
                }
            }
            if (cores > 0) {
                TooltipHelper.labelBrackets(tooltipIn, "Tier", null, (Component)tierName);
            }
        }
    }

    private static void getSwordState(ItemStack tool, List<Component> tooltipIn) {
        CompoundTag tag = tool.m_41783_();
        MutableComponent activeState = Component.m_237113_((String)"Deactivated").m_130940_(ChatFormatting.DARK_RED);
        if (tag != null && PrismaticBladeMk2.hasBladeTags(tag)) {
            int tier = tag.m_128451_("flatlights.tier") > 0 ? tag.m_128451_("flatlights.tier") : 1;
            int totalDmg = tag.m_128451_("flatlights.total_cores") > 0 ? tag.m_128451_("flatlights.total_cores") : 1;
            int mode = tag.m_128451_("flatlights.mode");
            DecimalFormat formatting = new DecimalFormat("#.##");
            formatting.setRoundingMode(RoundingMode.FLOOR);
            if (mode == 1) {
                float calculatedDmg = (float)totalDmg * ((float)tier / 7.0f);
                activeState = Component.m_237113_((String)"Annihilation").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)" | Increases damage of hits by ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)formatting.format(calculatedDmg)).m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)" damage").m_130940_(ChatFormatting.WHITE));
            } else if (mode == 2) {
                float projectileDmg = PrismaticBladeMk2.calcProjectileDmg(tag);
                activeState = Component.m_237113_((String)"Soul Sword").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)" | Swings launch a projectile dealing ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)formatting.format(projectileDmg)).m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)" damage per hit").m_130940_(ChatFormatting.WHITE));
            } else if (mode == 3) {
                activeState = Component.m_237113_((String)"Spear").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)" | Perform a leaping attack").m_130940_(ChatFormatting.WHITE));
            }
        }
        TooltipHelper.labelBrackets(tooltipIn, "Mode", null, (Component)activeState);
    }

    private static void getCoreData(ItemStack tool, List<Component> tooltipIn) {
        CompoundTag tag = tool.m_41783_();
        MutableComponent data = Component.m_237119_();
        if (tool.m_41783_() != null && tool.m_41783_().m_128441_("flatlights.curr_cores")) {
            int cores = tag.m_128451_("flatlights.curr_cores");
            int tier = tag.m_128451_("flatlights.tier");
            Object totalCoresForLevelup = "/" + tier * 1000;
            MutableComponent coresText = Component.m_237113_((String)String.valueOf(cores)).m_130940_(ChatFormatting.RED);
            if (tier >= 7) {
                totalCoresForLevelup = "";
            }
            if (cores >= tier * 1000 && tier < 7) {
                coresText = Component.m_237113_((String)String.valueOf(cores)).m_130940_(ChatFormatting.GREEN);
            }
            if (cores > 0) {
                data = coresText.m_6881_().m_7220_((Component)Component.m_237113_((String)totalCoresForLevelup).m_130940_(ChatFormatting.WHITE));
            }
            TooltipHelper.labelBrackets(tooltipIn, "Cores", null, (Component)data);
        }
    }

    public static boolean hasBladeTags(CompoundTag tag) {
        return tag.m_128441_("flatlights.mode") && tag.m_128441_("flatlights.curr_cores") && tag.m_128441_("flatlights.total_cores") && tag.m_128441_("flatlights.tier");
    }

    public static CompoundTag putFreshTags(CompoundTag tag) {
        tag.m_128405_("flatlights.mode", 0);
        tag.m_128405_("flatlights.curr_cores", 0);
        tag.m_128405_("flatlights.total_cores", 0);
        tag.m_128405_("flatlights.tier", 1);
        return tag;
    }

    public static boolean hasCoreTracker(Player player) {
        CompoundTag persistent = MiscUtils.getPersistent(player);
        return persistent != null && persistent.m_128441_("flatlights.core_tracker") && persistent.m_128451_("flatlights.core_tracker") >= 0;
    }

    public static int getPlayerCores(Player player) {
        CompoundTag persistent = MiscUtils.getPersistent(player);
        if (persistent != null && persistent.m_128441_("flatlights.core_tracker")) {
            return persistent.m_128451_("flatlights.core_tracker");
        }
        return -1;
    }

    public static void increasePlayerCores(Player player, Integer amount) {
        CompoundTag persistent = MiscUtils.getPersistent(player);
        if (persistent != null && PrismaticBladeMk2.getPlayerCores(player) >= 0) {
            persistent.m_128405_("flatlights.core_tracker", PrismaticBladeMk2.getPlayerCores(player) + amount);
        }
    }

    public static void setPlayerCores(Player player, Integer total) {
        CompoundTag persistent = MiscUtils.getPersistent(player);
        if (persistent != null && PrismaticBladeMk2.getPlayerCores(player) >= 0) {
            persistent.m_128405_("flatlights.core_tracker", total.intValue());
        }
    }

    public static float calcProjectileDmg(Player shooter) {
        CompoundTag tag = shooter.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof PrismaticBladeMk2 ? shooter.m_21120_(InteractionHand.MAIN_HAND).m_41783_() : null;
        int projectileBonus = tag != null && tag.m_128441_("flatlights.total_cores") && tag.m_128451_("flatlights.total_cores") > 0 ? tag.m_128451_("flatlights.total_cores") : 1;
        int tier = tag != null && tag.m_128441_("flatlights.tier") ? tag.m_128451_("flatlights.tier") + 1 : 1;
        return (float)projectileBonus * ((float)tier / 7.0f) / 2.0f;
    }

    public static float calcProjectileDmg(CompoundTag tag) {
        int projectileBonus = tag != null && tag.m_128441_("flatlights.total_cores") && tag.m_128451_("flatlights.total_cores") > 0 ? tag.m_128451_("flatlights.total_cores") : 1;
        int tier = tag != null && tag.m_128441_("flatlights.tier") ? tag.m_128451_("flatlights.tier") + 1 : 1;
        return (float)projectileBonus * ((float)tier / 7.0f) / 2.0f;
    }
}

