/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;

public class ChestCheckCondition
implements LootItemCondition {
    public static final LootItemConditionType GENERIC_STRUCTURE_CHEST = new LootItemConditionType((net.minecraft.world.level.storage.loot.Serializer)new Serializer());
    private final LocationPredicate predicate;
    private final BlockPos offset;

    private ChestCheckCondition(LocationPredicate locationPredicate, BlockPos blockPos) {
        this.predicate = locationPredicate;
        this.offset = blockPos;
    }

    public LootItemConditionType m_7940_() {
        return GENERIC_STRUCTURE_CHEST;
    }

    public boolean test(LootContext pContext) {
        Vec3 vector3d = (Vec3)pContext.m_78953_(LootContextParams.f_81460_);
        if (vector3d == null) {
            return false;
        }
        if (pContext.getQueriedLootTableId().equals((Object)BuiltInLootTables.f_78759_)) {
            return false;
        }
        BlockPos chestPos = new BlockPos((int)vector3d.f_82479_, (int)vector3d.f_82480_, (int)vector3d.f_82481_);
        BlockEntity chestTile = pContext.m_78952_().m_7702_(chestPos);
        if (chestTile != null) {
            // empty if block
        }
        boolean isChest = chestTile instanceof RandomizableContainerBlockEntity && !(chestTile instanceof DispenserBlockEntity) && !(chestTile instanceof HopperBlockEntity);
        return isChest && this.predicate.m_52617_(pContext.m_78952_(), vector3d.m_7096_() + (double)this.offset.m_123341_(), vector3d.m_7098_() + (double)this.offset.m_123342_(), vector3d.m_7094_() + (double)this.offset.m_123343_());
    }

    public static LootItemCondition.Builder checkLocation(LocationPredicate.Builder pLocationPredicateBuilder) {
        return () -> new ChestCheckCondition(pLocationPredicateBuilder.m_52658_(), BlockPos.f_121853_);
    }

    public static LootItemCondition.Builder checkLocation(LocationPredicate.Builder pLocationPredicateBuilder, BlockPos pOffset) {
        return () -> new ChestCheckCondition(pLocationPredicateBuilder.m_52658_(), pOffset);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<ChestCheckCondition> {
        public void serialize(JsonObject jsonObject, ChestCheckCondition instance, JsonSerializationContext context) {
            jsonObject.add("predicate", instance.predicate.m_52616_());
            if (instance.offset.m_123341_() != 0) {
                jsonObject.addProperty("offsetX", (Number)instance.offset.m_123341_());
            }
            if (instance.offset.m_123342_() != 0) {
                jsonObject.addProperty("offsetY", (Number)instance.offset.m_123342_());
            }
            if (instance.offset.m_123343_() != 0) {
                jsonObject.addProperty("offsetZ", (Number)instance.offset.m_123343_());
            }
        }

        public ChestCheckCondition deserialize(JsonObject jsonObject, JsonDeserializationContext context) {
            LocationPredicate locationpredicate = LocationPredicate.m_52629_((JsonElement)jsonObject.get("predicate"));
            int i = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"offsetX", (int)0);
            int j = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"offsetY", (int)0);
            int k = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"offsetZ", (int)0);
            return new ChestCheckCondition(locationpredicate, new BlockPos(i, j, k));
        }
    }
}

