/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.uberhelixx.flatlights.common.loot.LootTableModifier;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class CurioStructureAdditionModifier
extends LootModifier {
    public double firstRoll;
    public double secondRoll;
    public double thirdRoll;
    public double bonusRollChance;
    public int bonusRollCount;
    public static final Supplier<Codec<CurioStructureAdditionModifier>> CODEC = () -> RecordCodecBuilder.create(instance -> instance.group((App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(lm -> lm.conditions), (App)Codec.DOUBLE.fieldOf("first_roll").forGetter(d -> d.firstRoll), (App)Codec.DOUBLE.fieldOf("second_roll").forGetter(d -> d.secondRoll), (App)Codec.DOUBLE.fieldOf("third_roll").forGetter(d -> d.thirdRoll), (App)Codec.DOUBLE.fieldOf("bonus_roll_chance").forGetter(d -> d.bonusRollChance), (App)Codec.INT.fieldOf("bonus_roll_count").forGetter(d -> d.bonusRollCount)).apply((Applicative)instance, CurioStructureAdditionModifier::new));

    public CurioStructureAdditionModifier(LootItemCondition[] conditionsIn, double firstRoll, double secondRoll, double thirdRoll, double bonusRollChance, int bonusRollCount) {
        super(conditionsIn);
        this.firstRoll = firstRoll;
        this.secondRoll = secondRoll;
        this.thirdRoll = thirdRoll;
        this.bonusRollChance = bonusRollChance;
        this.bonusRollCount = bonusRollCount;
    }

    protected CurioStructureAdditionModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
        this.firstRoll = 0.85;
        this.secondRoll = 0.5;
        this.thirdRoll = 0.3;
        this.bonusRollChance = 0.0;
        this.bonusRollCount = 0;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> objectArrayList, LootContext lootContext) {
        ResourceLocation queriedLootTable = lootContext.getQueriedLootTableId();
        ResourceLocation dimID = lootContext.m_78952_().m_46472_().m_135782_();
        if (queriedLootTable.equals((Object)BuiltInLootTables.f_78763_) || queriedLootTable.equals((Object)BuiltInLootTables.f_78762_) || queriedLootTable.equals((Object)BuiltInLootTables.f_78761_)) {
            List<ItemStack> additionalItems = LootTableModifier.getLootTableRoll(this, 0.1f);
        } else if (dimID.equals((Object)Level.f_46429_.m_135782_())) {
            List<ItemStack> additionalItems = LootTableModifier.getLootTableRoll(this, 0.15f);
        } else if (dimID.equals((Object)Level.f_46430_.m_135782_())) {
            List<ItemStack> additionalItems = LootTableModifier.getLootTableRoll(this, 0.25f);
        } else {
            List<ItemStack> additionalItems = LootTableModifier.getLootTableRoll(this, 0.0f);
        }
        return objectArrayList;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

