/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.network.packets;

import com.uberhelixx.flatlights.util.MiscUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class PacketAirstrafeMovement {
    private float forwardVal;
    private float strafeVal;
    private boolean jumpVal;
    private boolean sneakVal;

    public PacketAirstrafeMovement() {
    }

    public PacketAirstrafeMovement(float forward, float strafe, boolean jump, boolean sneak) {
        this.forwardVal = forward;
        this.strafeVal = strafe;
        this.jumpVal = jump;
        this.sneakVal = sneak;
    }

    public static void encode(PacketAirstrafeMovement msg, FriendlyByteBuf buf) {
        buf.writeFloat(msg.forwardVal);
        buf.writeFloat(msg.strafeVal);
        buf.writeBoolean(msg.jumpVal);
        buf.writeBoolean(msg.sneakVal);
    }

    public static PacketAirstrafeMovement decode(FriendlyByteBuf buf) {
        return new PacketAirstrafeMovement(buf.readFloat(), buf.readFloat(), buf.readBoolean(), buf.readBoolean());
    }

    public static void handle(PacketAirstrafeMovement msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isServer()) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null) {
                    PacketAirstrafeMovement.processStrafes(msg.forwardVal, msg.strafeVal, (Player)player);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }

    public static void processStrafes(float forwardStrafe, float sideStrafe, Player player) {
        float moveIncrease = 0.1f;
        double side = 0.0;
        double forward = 0.0;
        Vec3 multVec = new Vec3(0.0, 0.0, 0.0);
        if (forwardStrafe > 0.0f) {
            forward = moveIncrease * -1.0f;
            multVec = multVec.m_82520_(0.0, 0.0, forward);
            MiscUtils.infoLog("[Strafe Packet] Pressed Forward.");
        } else if (forwardStrafe < 0.0f) {
            forward = moveIncrease * 1.0f;
            multVec = multVec.m_82520_(0.0, 0.0, forward);
            MiscUtils.infoLog("[Strafe Packet] Pressed Backward.");
        }
        if (sideStrafe > 0.0f) {
            side = moveIncrease * -1.0f;
            multVec = multVec.m_82520_(side, 0.0, 0.0);
            MiscUtils.infoLog("[Strafe Packet] Pressed Left.");
        } else if (sideStrafe < 0.0f) {
            side = moveIncrease * 1.0f;
            multVec = multVec.m_82520_(side, 0.0, 0.0);
            MiscUtils.infoLog("[Strafe Packet] Pressed Right.");
        }
        multVec = multVec.m_82524_((float)player.m_20154_().f_82480_);
        MiscUtils.infoLog("[multVec] " + multVec);
        player.m_246865_(multVec);
    }
}

