/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.network.packets;

import com.uberhelixx.flatlights.common.item.curio.BaseCurio;
import com.uberhelixx.flatlights.common.item.curio.CurioUtils;
import com.uberhelixx.flatlights.util.MiscUtils;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class PacketCurioToggle {
    public static void encode(PacketCurioToggle msg, FriendlyByteBuf buf) {
    }

    public static PacketCurioToggle decode(FriendlyByteBuf buf) {
        return new PacketCurioToggle();
    }

    public static void handle(PacketCurioToggle msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isServer()) {
            ctx.get().enqueueWork(() -> {
                ItemStack stack;
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null && (stack = PacketCurioToggle.getCurio((Player)player)) != null && !stack.m_41619_()) {
                    CurioUtils.toggleSetEffect(stack, (Player)player);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }

    public static ItemStack getCurio(Player playerIn) {
        ItemStack hand = playerIn.m_21120_(InteractionHand.MAIN_HAND);
        ICuriosItemHandler curioInv = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)playerIn).orElse(null);
        if (curioInv != null) {
            CompoundTag tag;
            Optional slotResult = curioInv.findCurio("flatlights.curios.cube", 0);
            if (slotResult.isPresent()) {
                ItemStack curio = ((SlotResult)slotResult.get()).stack();
                CompoundTag tag2 = curio.m_41783_();
                if (tag2 != null && !tag2.m_128456_() && tag2.m_128441_("flatlights.curioSetToggle")) {
                    MiscUtils.infoLog("[PacketCurioToggle] Returning worn curio.");
                    return curio;
                }
            } else if (hand.m_41720_() instanceof BaseCurio && (tag = hand.m_41783_()) != null && !tag.m_128456_() && tag.m_128441_("flatlights.curioSetToggle")) {
                MiscUtils.infoLog("[PacketCurioToggle] Returning held curio.");
                return hand;
            }
        }
        MiscUtils.infoLog("[PacketCurioToggle] Returning null from no curios inventory.");
        return null;
    }
}

