/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.common.network.packets;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketWriteNbt {
    public CompoundTag tagToWrite;
    public ItemStack playerItem;

    public PacketWriteNbt() {
    }

    public PacketWriteNbt(CompoundTag tag, ItemStack itemIn) {
        this.tagToWrite = tag;
        this.playerItem = itemIn;
    }

    public static void encode(PacketWriteNbt msg, FriendlyByteBuf buf) {
        buf.m_130079_(msg.tagToWrite);
        buf.writeItemStack(msg.playerItem, false);
    }

    public static PacketWriteNbt decode(FriendlyByteBuf buf) {
        return new PacketWriteNbt(buf.m_130260_(), buf.m_130267_());
    }

    public static void handle(PacketWriteNbt msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isServer()) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null && msg.tagToWrite != null) {
                    ItemStack item = msg.playerItem;
                    item.m_41751_(msg.tagToWrite);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

