/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.datagen;

import com.uberhelixx.flatlights.datagen.ModAdvancementProvider;
import com.uberhelixx.flatlights.datagen.ModBlockStateProvider;
import com.uberhelixx.flatlights.datagen.ModBlockTagsProvider;
import com.uberhelixx.flatlights.datagen.ModItemModelProvider;
import com.uberhelixx.flatlights.datagen.ModItemTagsProvider;
import com.uberhelixx.flatlights.datagen.ModLootTableProvider;
import com.uberhelixx.flatlights.datagen.ModRecipeProvider;
import com.uberhelixx.flatlights.util.MiscUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="flatlights", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        MiscUtils.infoLog("Generating block tags...");
        ModBlockTagsProvider blockTagGenerator = (ModBlockTagsProvider)generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagsProvider(packOutput, lookupProvider, existingFileHelper));
        MiscUtils.infoLog("Finished generating block tags.");
        MiscUtils.infoLog("Generating item tags...");
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(packOutput, lookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
        MiscUtils.infoLog("Finished generating item tags.");
        MiscUtils.infoLog("Generating loot tables...");
        generator.addProvider(event.includeServer(), (DataProvider)new ModLootTableProvider(packOutput));
        MiscUtils.infoLog("Finished generating loot tables.");
        MiscUtils.infoLog("Generating recipes...");
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput));
        MiscUtils.infoLog("Finished generating recipes.");
        MiscUtils.infoLog("Generating advancements...");
        generator.addProvider(event.includeClient(), (DataProvider)new ForgeAdvancementProvider(packOutput, lookupProvider, existingFileHelper, List.of(new ModAdvancementProvider())));
        MiscUtils.infoLog("Finished generating advancements.");
    }
}

