/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.datagen;

import com.uberhelixx.flatlights.FlatLights;
import com.uberhelixx.flatlights.common.block.ModBlocks;
import com.uberhelixx.flatlights.common.block.PlateBlock;
import com.uberhelixx.flatlights.common.block.WireGlassBlock;
import com.uberhelixx.flatlights.common.block.blackout.BlackoutFlatBlock;
import com.uberhelixx.flatlights.common.block.light.FlatBlock;
import com.uberhelixx.flatlights.common.block.light.HorizontalEdgeBlock;
import com.uberhelixx.flatlights.common.block.light.PillarLightBlock;
import com.uberhelixx.flatlights.common.block.light.SlabLightBlock;
import com.uberhelixx.flatlights.common.block.light.VerticalEdgeBlock;
import com.uberhelixx.flatlights.util.MiscUtils;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "flatlights", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (RegistryObject blockRegistryObject : ModBlocks.BLOCKS.getEntries()) {
            String filePath = blockRegistryObject.getId().m_135815_();
            MiscUtils.infoLog("File path is " + filePath);
            Block block = (Block)blockRegistryObject.get();
            if (block instanceof FlatBlock && !(block instanceof BlackoutFlatBlock)) {
                this.makeFlatblock(block, filePath);
            }
            if (block instanceof BlackoutFlatBlock) {
                this.makeBlackoutFlatblock(block, filePath);
            }
            if (block instanceof PlateBlock) {
                this.makePlateBlock(block, filePath);
            }
            if (block instanceof SlabLightBlock) {
                this.makePanel(block, filePath);
            }
            if (block instanceof PillarLightBlock) {
                this.makePillar(block, filePath);
            }
            if (block instanceof HorizontalEdgeBlock) {
                this.makeEdgeH(block, filePath);
            }
            if (block instanceof VerticalEdgeBlock) {
                this.makeEdgeV(block, filePath);
            }
            if (!(block instanceof WireGlassBlock)) continue;
            this.makeWireGlassBlock(block, filePath);
        }
    }

    private void makeFlatblock(Block block, String filePath) {
        this.simpleBlock(block, (ModelFile)this.models().getExistingFile(this.modLoc("block/flatblock/" + filePath)));
    }

    private void makeBlackoutFlatblock(Block block, String filePath) {
        this.simpleBlock(block, (ModelFile)this.models().cubeAll(filePath, this.modLoc("block/blackout/" + filePath)));
    }

    private void makePlateBlock(Block block, String filePath) {
        if (filePath.contains("_large")) {
            if (filePath.contains("_hexblock")) {
                this.simpleBlock(block, (ModelFile)this.models().cubeAll(filePath, this.modLoc("block/large_hexblock/" + filePath)));
            } else if (filePath.contains("_tiles")) {
                this.simpleBlock(block, (ModelFile)this.models().cubeAll(filePath, this.modLoc("block/large_tiles/" + filePath)));
            }
        } else if (filePath.contains("_hexblock")) {
            this.simpleBlock(block, (ModelFile)this.models().cubeAll(filePath, this.modLoc("block/hexblock/" + filePath)));
        } else if (filePath.contains("_tiles")) {
            this.simpleBlock(block, (ModelFile)this.models().cubeAll(filePath, this.modLoc("block/tiles/" + filePath)));
        }
        FlatLights.LOGGER.error("[BlockStateProvider] Issue generating plate block with file path: " + filePath);
    }

    private void rotationStates(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(facing == Direction.DOWN ? 180 : (facing.m_122434_().m_122479_() ? 90 : 0)).rotationY(facing.m_122434_().m_122478_() ? 0 : ((int)facing.m_122435_() + angleOffset) % 360 + 180).build();
        }, new Property[]{BlockStateProperties.f_61362_});
    }

    private void makePanel(Block block, String filePath) {
        this.rotationStates(block, $ -> this.models().getExistingFile(this.modLoc("block/panel/" + filePath)), 0);
    }

    private void makePillar(Block block, String filePath) {
        this.rotationStates(block, $ -> this.models().getExistingFile(this.modLoc("block/pillar/" + filePath)), 0);
    }

    private void multipartEdgesH(Block block, String filePath) {
        ModelFile.ExistingModelFile edgeModel = this.models().getExistingFile(this.modLoc("block/horizontal_edge/" + filePath));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile((ModelFile)edgeModel).addModel()).useOr().nestedGroup().condition((Property)HorizontalEdgeBlock.PLACED_TOP, (Comparable[])new Boolean[]{false}).condition((Property)HorizontalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{2}).end().nestedGroup().condition((Property)HorizontalEdgeBlock.PLACED_TOP, (Comparable[])new Boolean[]{false}).condition((Property)HorizontalEdgeBlock.NORTH_ADJ, (Comparable[])new Boolean[]{true}).end().end().part().modelFile((ModelFile)edgeModel).rotationY(180).addModel()).useOr().nestedGroup().condition((Property)HorizontalEdgeBlock.PLACED_TOP, (Comparable[])new Boolean[]{false}).condition((Property)HorizontalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{0}).end().nestedGroup().condition((Property)HorizontalEdgeBlock.PLACED_TOP, (Comparable[])new Boolean[]{false}).condition((Property)HorizontalEdgeBlock.SOUTH_ADJ, (Comparable[])new Boolean[]{true}).end().end().part().modelFile((ModelFile)edgeModel).rotationY(270).addModel()).useOr().nestedGroup().condition((Property)HorizontalEdgeBlock.PLACED_TOP, (Comparable[])new Boolean[]{false}).condition((Property)HorizontalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{1}).end().nestedGroup().condition((Property)HorizontalEdgeBlock.PLACED_TOP, (Comparable[])new Boolean[]{false}).condition((Property)HorizontalEdgeBlock.WEST_ADJ, (Comparable[])new Boolean[]{true}).end().end().part().modelFile((ModelFile)edgeModel).rotationY(90).addModel()).useOr().nestedGroup().condition((Property)HorizontalEdgeBlock.PLACED_TOP, (Comparable[])new Boolean[]{false}).condition((Property)HorizontalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{3}).end().nestedGroup().condition((Property)HorizontalEdgeBlock.PLACED_TOP, (Comparable[])new Boolean[]{false}).condition((Property)HorizontalEdgeBlock.EAST_ADJ, (Comparable[])new Boolean[]{true}).end().end().part().modelFile((ModelFile)edgeModel).rotationX(180).rotationY(180).addModel()).useOr().nestedGroup().condition((Property)HorizontalEdgeBlock.PLACED_TOP, (Comparable[])new Boolean[]{true}).condition((Property)HorizontalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{2}).end().nestedGroup().condition((Property)HorizontalEdgeBlock.PLACED_TOP, (Comparable[])new Boolean[]{true}).condition((Property)HorizontalEdgeBlock.NORTH_ADJ, (Comparable[])new Boolean[]{true}).end().end().part().modelFile((ModelFile)edgeModel).rotationX(180).addModel()).useOr().nestedGroup().condition((Property)HorizontalEdgeBlock.PLACED_TOP, (Comparable[])new Boolean[]{true}).condition((Property)HorizontalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{0}).end().nestedGroup().condition((Property)HorizontalEdgeBlock.PLACED_TOP, (Comparable[])new Boolean[]{true}).condition((Property)HorizontalEdgeBlock.SOUTH_ADJ, (Comparable[])new Boolean[]{true}).end().end().part().modelFile((ModelFile)edgeModel).rotationX(180).rotationY(90).addModel()).useOr().nestedGroup().condition((Property)HorizontalEdgeBlock.PLACED_TOP, (Comparable[])new Boolean[]{true}).condition((Property)HorizontalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{1}).end().nestedGroup().condition((Property)HorizontalEdgeBlock.PLACED_TOP, (Comparable[])new Boolean[]{true}).condition((Property)HorizontalEdgeBlock.WEST_ADJ, (Comparable[])new Boolean[]{true}).end().end().part().modelFile((ModelFile)edgeModel).rotationX(180).rotationY(270).addModel()).useOr().nestedGroup().condition((Property)HorizontalEdgeBlock.PLACED_TOP, (Comparable[])new Boolean[]{true}).condition((Property)HorizontalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{3}).end().nestedGroup().condition((Property)HorizontalEdgeBlock.PLACED_TOP, (Comparable[])new Boolean[]{true}).condition((Property)HorizontalEdgeBlock.EAST_ADJ, (Comparable[])new Boolean[]{true}).end().end();
    }

    private void makeEdgeH(Block block, String filePath) {
        this.multipartEdgesH(block, filePath);
    }

    private void multipartEdgesV(Block block, String filePath) {
        ModelFile.ExistingModelFile edgeModelH = this.models().getExistingFile(this.modLoc("block/horizontal_edge/" + filePath.replace("vertical", "horizontal")));
        ModelFile.ExistingModelFile edgeModelV = this.models().getExistingFile(this.modLoc("block/vertical_edge/" + filePath));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile((ModelFile)edgeModelH).addModel()).useOr().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{2}).condition((Property)VerticalEdgeBlock.DOWN_ADJ, (Comparable[])new Boolean[]{true}).end().end().part().modelFile((ModelFile)edgeModelH).rotationY(180).addModel()).useOr().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{0}).condition((Property)VerticalEdgeBlock.DOWN_ADJ, (Comparable[])new Boolean[]{true}).end().end().part().modelFile((ModelFile)edgeModelH).rotationY(270).addModel()).useOr().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{1}).condition((Property)VerticalEdgeBlock.DOWN_ADJ, (Comparable[])new Boolean[]{true}).end().end().part().modelFile((ModelFile)edgeModelH).rotationY(90).addModel()).useOr().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{3}).condition((Property)VerticalEdgeBlock.DOWN_ADJ, (Comparable[])new Boolean[]{true}).end().end().part().modelFile((ModelFile)edgeModelH).rotationX(180).rotationY(180).addModel()).useOr().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{2}).condition((Property)VerticalEdgeBlock.UP_ADJ, (Comparable[])new Boolean[]{true}).end().end().part().modelFile((ModelFile)edgeModelH).rotationX(180).addModel()).useOr().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{0}).condition((Property)VerticalEdgeBlock.UP_ADJ, (Comparable[])new Boolean[]{true}).end().end().part().modelFile((ModelFile)edgeModelH).rotationX(180).rotationY(90).addModel()).useOr().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{1}).condition((Property)VerticalEdgeBlock.UP_ADJ, (Comparable[])new Boolean[]{true}).end().end().part().modelFile((ModelFile)edgeModelH).rotationX(180).rotationY(270).addModel()).useOr().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{3}).condition((Property)VerticalEdgeBlock.UP_ADJ, (Comparable[])new Boolean[]{true}).end().end().part().modelFile((ModelFile)edgeModelV).addModel()).useOr().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{2}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.UP_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.DOWN_ADJ, (Comparable[])new Boolean[]{false}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{2}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{true}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{false}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{2}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{true}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{2}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.UP_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.DOWN_ADJ, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{2}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.UP_ADJ, (Comparable[])new Boolean[]{true}).condition((Property)VerticalEdgeBlock.DOWN_ADJ, (Comparable[])new Boolean[]{false}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{1}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{1}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{true}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{true}).end().end().part().modelFile((ModelFile)edgeModelV).rotationY(90).addModel()).useOr().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{3}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.UP_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.DOWN_ADJ, (Comparable[])new Boolean[]{false}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{3}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{true}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{false}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{3}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{true}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{3}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.UP_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.DOWN_ADJ, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{3}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.UP_ADJ, (Comparable[])new Boolean[]{true}).condition((Property)VerticalEdgeBlock.DOWN_ADJ, (Comparable[])new Boolean[]{false}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{2}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{2}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{true}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{true}).end().end().part().modelFile((ModelFile)edgeModelV).rotationY(180).addModel()).useOr().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{0}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.UP_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.DOWN_ADJ, (Comparable[])new Boolean[]{false}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{0}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{true}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{false}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{0}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{true}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{0}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.UP_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.DOWN_ADJ, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{0}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.UP_ADJ, (Comparable[])new Boolean[]{true}).condition((Property)VerticalEdgeBlock.DOWN_ADJ, (Comparable[])new Boolean[]{false}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{3}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{3}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{true}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{true}).end().end().part().modelFile((ModelFile)edgeModelV).rotationY(270).addModel()).useOr().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{1}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.UP_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.DOWN_ADJ, (Comparable[])new Boolean[]{false}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{1}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{true}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{false}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{1}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{true}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{1}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.UP_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.DOWN_ADJ, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{1}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.UP_ADJ, (Comparable[])new Boolean[]{true}).condition((Property)VerticalEdgeBlock.DOWN_ADJ, (Comparable[])new Boolean[]{false}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{0}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{false}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{true}).end().nestedGroup().condition((Property)VerticalEdgeBlock.FACING_INDEX, (Comparable[])new Integer[]{0}).condition((Property)VerticalEdgeBlock.LEFT_ADJ, (Comparable[])new Boolean[]{true}).condition((Property)VerticalEdgeBlock.RIGHT_ADJ, (Comparable[])new Boolean[]{true}).end().end();
    }

    private void makeEdgeV(Block block, String filePath) {
        this.multipartEdgesV(block, filePath);
    }

    private void makeWireGlassBlock(Block block, String filePath) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cubeAll(filePath, this.modLoc("block/glass/" + filePath))).renderType("translucent"));
    }
}

