/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.datagen;

import com.uberhelixx.flatlights.common.block.ModBlocks;
import com.uberhelixx.flatlights.common.block.PlateBlock;
import com.uberhelixx.flatlights.common.block.WireGlassBlock;
import com.uberhelixx.flatlights.common.block.blackout.BlackoutFlatBlock;
import com.uberhelixx.flatlights.common.block.light.FlatBlock;
import com.uberhelixx.flatlights.common.block.light.HorizontalEdgeBlock;
import com.uberhelixx.flatlights.common.block.light.PillarLightBlock;
import com.uberhelixx.flatlights.common.block.light.SlabLightBlock;
import com.uberhelixx.flatlights.common.block.light.VerticalEdgeBlock;
import com.uberhelixx.flatlights.common.item.ModItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "flatlights", existingFileHelper);
    }

    protected void registerModels() {
        String filePath;
        for (RegistryObject blockRegistryObject : ModBlocks.BLOCKS.getEntries()) {
            filePath = blockRegistryObject.getId().m_135815_();
            Block block = (Block)blockRegistryObject.get();
            if (block instanceof FlatBlock && !(block instanceof BlackoutFlatBlock) && !filePath.endsWith("_blackout")) {
                this.makeFlatblockModel(filePath);
            }
            if (block instanceof BlackoutFlatBlock || block instanceof PlateBlock || block instanceof WireGlassBlock) {
                this.withExistingParent(filePath, this.modLoc("block/" + filePath));
            }
            if (block instanceof SlabLightBlock) {
                this.makePanelModel(filePath);
            }
            if (block instanceof PillarLightBlock) {
                this.makePillarModel(filePath);
            }
            if (block instanceof HorizontalEdgeBlock) {
                this.makeEdgeHModel(filePath);
            }
            if (!(block instanceof VerticalEdgeBlock)) continue;
            this.makeEdgeVModel(filePath);
        }
        for (RegistryObject itemRegistryObject : ModItems.ITEMS.getEntries()) {
            filePath = itemRegistryObject.getId().m_135815_();
            this.singleTexture(filePath, this.mcLoc("item/generated"), "layer0", this.modLoc("item/" + filePath));
        }
        for (RegistryObject itemRegistryObject : ModItems.TOGGLE_ITEMS.getEntries()) {
            filePath = itemRegistryObject.getId().m_135815_();
            this.makeToggleItemModel(filePath);
        }
    }

    private void makeFlatblockModel(String filePath) {
        this.withExistingParent(filePath, this.modLoc("block/flatblock/" + filePath));
    }

    private void makePanelModel(String filePath) {
        this.withExistingParent(filePath, this.modLoc("block/panel/" + filePath));
    }

    private void makePillarModel(String filePath) {
        this.withExistingParent(filePath, this.modLoc("block/pillar/" + filePath));
    }

    private void makeEdgeHModel(String filePath) {
        this.withExistingParent(filePath, this.modLoc("block/horizontal_edge/" + filePath));
    }

    private void makeEdgeVModel(String filePath) {
        this.withExistingParent(filePath, this.modLoc("block/vertical_edge/" + filePath));
    }

    private void makeToggleItemModel(String filePath) {
        ResourceLocation enabledModelPath = this.modLoc("item/" + filePath + "_active");
        ResourceLocation defaultModelPath = this.modLoc("item/" + filePath);
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(filePath)).parent((ModelFile)this.getExistingFile(this.mcLoc("item/handheld")))).texture("layer0", defaultModelPath)).override().predicate(ResourceLocation.m_214293_((String)"flatlights", (String)"mode"), 1.0f).model((ModelFile)this.singleTexture(filePath + "_active", this.mcLoc("item/handheld"), "layer0", enabledModelPath)).end();
    }
}

