/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.startup;

import com.uberhelixx.flatlights.FlatLights;
import com.uberhelixx.flatlights.client.ModKeybinds;
import com.uberhelixx.flatlights.client.renderer.BombProjectileRenderer;
import com.uberhelixx.flatlights.client.renderer.ChairEntityRenderer;
import com.uberhelixx.flatlights.client.renderer.GravityLiftRenderer;
import com.uberhelixx.flatlights.client.renderer.Mk2ProjectileRenderer;
import com.uberhelixx.flatlights.client.renderer.PortableBlackHoleRenderer;
import com.uberhelixx.flatlights.client.renderer.player.DragonSphereRenderer;
import com.uberhelixx.flatlights.client.screen.LightStorageScreen;
import com.uberhelixx.flatlights.client.screen.ModMenuTypes;
import com.uberhelixx.flatlights.client.screen.PlatingMachineScreen;
import com.uberhelixx.flatlights.client.screen.SpectralizerScreen;
import com.uberhelixx.flatlights.common.entity.ModEntityTypes;
import com.uberhelixx.flatlights.common.item.ModItems;
import com.uberhelixx.flatlights.common.item.curio.ModCurios;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="flatlights", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetup {
    public static void doClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)ModItems.PRISMATIC_SWORD.get()), (ResourceLocation)new ResourceLocation("flatlights", "mode"), (stack, level, living, id) -> {
                float bombMode = 0.0f;
                if (stack.m_41783_() != null && stack.m_41783_().m_128441_("flatlights.mode") && stack.m_41783_().m_128471_("flatlights.mode")) {
                    bombMode = 1.0f;
                }
                return bombMode;
            });
            for (RegistryObject entry : ModCurios.CURIOS.getEntries()) {
                ItemProperties.register((Item)((Item)entry.get()), (ResourceLocation)new ResourceLocation("flatlights", "tier"), (stack, level, living, id) -> {
                    float curioTier = 0.0f;
                    if (stack.m_41783_() != null && stack.m_41783_().m_128441_("flatlights.curiotier")) {
                        curioTier = stack.m_41783_().m_128457_("flatlights.curiotier");
                    }
                    return curioTier;
                });
            }
            ItemProperties.register((Item)((Item)ModItems.PRISMATIC_BLADEMK2.get()), (ResourceLocation)new ResourceLocation("flatlights", "mode"), (stack, world, living, id) -> {
                float mk2Mode = 0.0f;
                if (stack.m_41783_() != null && stack.m_41783_().m_128441_("flatlights.mode") && stack.m_41783_().m_128451_("flatlights.mode") == 3) {
                    mk2Mode = 1.0f;
                }
                return mk2Mode;
            });
        });
        FlatLights.LOGGER.info("[Client Setup] Registering screens");
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.PLATING_MACHINE_MENU.get()), PlatingMachineScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.LIGHT_STORAGE_MENU.get()), LightStorageScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.SPECTRALIZER_MENU.get()), SpectralizerScreen::new);
    }

    @SubscribeEvent
    public static void registerEntities(EntityRenderersEvent.RegisterRenderers event) {
        FlatLights.LOGGER.info("[Client Setup] Registering entity renderers");
        event.registerEntityRenderer((EntityType)ModEntityTypes.BOMB_PROJECTILE.get(), BombProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.PORTABLE_BLACK_HOLE_ENTITY.get(), PortableBlackHoleRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.PORTABLE_BLACK_HOLE_PROJECTILE_ENTITY.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.GRAVITY_LIFT_ENTITY.get(), GravityLiftRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.GRAVITY_LIFT_PROJECTILE_ENTITY.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.CHAIR_ENTITY.get(), ChairEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.MK2_PROJECTILE_ENTITY.get(), Mk2ProjectileRenderer::new);
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterAdditional event) {
        FlatLights.LOGGER.info("[Client Setup] Registering model renderers");
        event.register(BombProjectileRenderer.BOMB_MODEL);
        event.register(PortableBlackHoleRenderer.SPHERE_MODEL);
        event.register(GravityLiftRenderer.LIFT_BASE_MODEL);
        event.register(new ResourceLocation("flatlights", "block/motivational_chair/motivational_chair_wrapper"));
        event.register(Mk2ProjectileRenderer.MK2_PROJECTILE_MODEL);
        event.register(DragonSphereRenderer.INNER_SPHERE_MODEL);
        event.register(DragonSphereRenderer.OUTER_SPHERE_MODEL);
    }

    @SubscribeEvent
    public static void registerKeybinds(RegisterKeyMappingsEvent event) {
        event.register(ModKeybinds.INSTANCE.CURIO_TOGGLE);
        event.register(ModKeybinds.INSTANCE.MODE_CYCLE);
    }
}

