/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.startup.registry;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="flatlights", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModDamageTypes {
    public static final ResourceKey<DamageType> QUANTUM = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("flatlights:quantum"));
    public static final ResourceKey<DamageType> ENTANGLED = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("flatlights:entangled"));
    public static final ResourceKey<DamageType> PHYSICAL = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("flatlights:physical"));
    public static final ResourceKey<DamageType> BLEED = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("flatlights:bleed"));

    public static CustomEntityDamageSource causeQuantumDamage(@Nullable Entity source) {
        Holder.Reference holder = source.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(QUANTUM);
        return new CustomEntityDamageSource((Holder<DamageType>)holder, source);
    }

    public static CustomEntityDamageSource causeEntangledDamage(@Nullable Entity source) {
        Holder.Reference holder = source.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(ENTANGLED);
        return new CustomEntityDamageSource((Holder<DamageType>)holder, source);
    }

    public static CustomEntityDamageSource causePhysicalDamage(@Nullable Entity source) {
        Holder.Reference holder = source.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(PHYSICAL);
        return new CustomEntityDamageSource((Holder<DamageType>)holder, source);
    }

    public static CustomEntityDamageSource causeBleedDamage(@Nullable Entity source) {
        Holder.Reference holder = source.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(BLEED);
        return new CustomEntityDamageSource((Holder<DamageType>)holder, source);
    }

    public static CustomIndirectEntityDamageSource causeIndirectQuantumDamage(Entity source, @Nullable Entity trueSource) {
        Holder.Reference holder = trueSource.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(QUANTUM);
        return new CustomIndirectEntityDamageSource((Holder<DamageType>)holder, source, trueSource);
    }

    public static CustomIndirectEntityDamageSource causeIndirectEntangledDamage(Entity source, @Nullable Entity trueSource) {
        Holder.Reference holder = trueSource.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(ENTANGLED);
        return new CustomIndirectEntityDamageSource((Holder<DamageType>)holder, source, trueSource);
    }

    public static CustomIndirectEntityDamageSource causeIndirectPhysicalDamage(Entity source, @Nullable Entity trueSource) {
        Holder.Reference holder = trueSource.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(PHYSICAL);
        return new CustomIndirectEntityDamageSource((Holder<DamageType>)holder, source, trueSource);
    }

    public static CustomIndirectEntityDamageSource causeIndirectBleedDamage(Entity source, @Nullable Entity trueSource) {
        Holder.Reference holder = trueSource.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(BLEED);
        return new CustomIndirectEntityDamageSource((Holder<DamageType>)holder, source, trueSource);
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeServer(), output -> new ModDamageTypeTagsProvider(event.getGenerator().getPackOutput(), event.getLookupProvider(), "flatlights", event.getExistingFileHelper()));
    }

    public static class CustomEntityDamageSource
    extends DamageSource {
        public CustomEntityDamageSource(Holder<DamageType> damageTypeIn, @Nullable Entity damageSourceEntityIn) {
            super(damageTypeIn, damageSourceEntityIn);
        }
    }

    public static class CustomIndirectEntityDamageSource
    extends DamageSource {
        public CustomIndirectEntityDamageSource(Holder<DamageType> damageTypeIn, Entity source, @Nullable Entity trueSource) {
            super(damageTypeIn, source, trueSource);
        }
    }

    public static class ModDamageTypeTagsProvider
    extends DamageTypeTagsProvider {
        public ModDamageTypeTagsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(packOutput, lookupProvider, modId, existingFileHelper);
        }

        public void m_6577_(HolderLookup.Provider pProvider) {
            this.m_206424_(DamageTypeTags.f_268490_).m_255204_(QUANTUM);
            this.m_206424_(DamageTypeTags.f_268490_).m_255204_(ENTANGLED);
            this.m_206424_(DamageTypeTags.f_268437_).m_255204_(ENTANGLED);
            this.m_206424_(DamageTypeTags.f_268490_).m_255204_(BLEED);
            this.m_206424_(DamageTypeTags.f_268437_).m_255204_(BLEED);
        }
    }
}

