/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.uberhelixx.flatlights.FlatLights;
import com.uberhelixx.flatlights.startup.registry.ModSoundEvents;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.scores.Scoreboard;

public class MiscUtils {
    static boolean toggle = false;
    private static final String DATA_URL = "https://raw.githubusercontent.com/Syi-I/json-reader/main/entries.json";
    private static final Gson GSON = new GsonBuilder().create();
    public static List<UUID> players = new ArrayList<UUID>();

    public static void infoLog(String message) {
        if (toggle) {
            FlatLights.LOGGER.info(message);
        }
    }

    public static float getTotalDamage(ItemStack weapon, LivingEntity itemHolder) {
        float fistDamage = 1.0f;
        Multimap attributes = weapon.m_41638_(EquipmentSlot.MAINHAND);
        float weaponDamage = 0.0f;
        Collection collector = attributes.get((Object)Attributes.f_22281_);
        if (!collector.isEmpty()) {
            for (AttributeModifier entry : collector) {
                double entryAmount = entry.m_22218_();
                weaponDamage = (float)((double)weaponDamage + entryAmount);
            }
        }
        float sharpnessDamage = 0.0f;
        if (EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44977_, (LivingEntity)itemHolder) > 0) {
            sharpnessDamage = 0.5f;
            sharpnessDamage = (float)((double)sharpnessDamage + 0.5 * (double)EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44977_, (LivingEntity)itemHolder));
        }
        return fistDamage + weaponDamage + sharpnessDamage;
    }

    public static float damagePercentCalc(Integer percent) {
        return (float)percent.intValue() / 100.0f;
    }

    public static void addToTeam(LivingEntity entityIn, String teamName, ChatFormatting color) {
        Scoreboard scoreboard = entityIn.m_9236_().m_6188_();
        if (scoreboard.m_83489_(teamName) == null) {
            scoreboard.m_83492_(teamName);
        }
        scoreboard.m_6546_(entityIn.m_20149_(), Objects.requireNonNull(scoreboard.m_83489_(teamName)));
        if (Objects.requireNonNull(scoreboard.m_83489_(teamName)).m_7414_() != color) {
            Objects.requireNonNull(scoreboard.m_83489_(teamName)).m_83351_(color);
        }
    }

    public static void modeSwitchSound(Player playerIn, boolean active) {
        if (active) {
            playerIn.m_6330_((SoundEvent)ModSoundEvents.MODE_SWITCH.get(), SoundSource.PLAYERS, 0.4f, 0.55f);
        } else {
            playerIn.m_6330_((SoundEvent)ModSoundEvents.MODE_SWITCH.get(), SoundSource.PLAYERS, 0.4f, 0.01f);
        }
    }

    public static void turboInt() {
        Thread tr = new Thread(() -> {
            QuickList jsonData;
            URLConnection connection;
            try {
                connection = new URL(DATA_URL).openConnection();
            }
            catch (IOException e) {
                FlatLights.LOGGER.error("Could not retrieve list.");
                e.printStackTrace();
                return;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                jsonData = (QuickList)GSON.fromJson((Reader)reader, QuickList.class);
            }
            catch (IOException e) {
                FlatLights.LOGGER.error("Failed to connect, could not load list.");
                e.printStackTrace();
                return;
            }
            int skipped = 0;
            for (QuickList.playerEntry entry : jsonData.getPlayers()) {
                try {
                    UUID plUuid = UUID.fromString(entry.getUuid());
                    players.add(plUuid);
                    MiscUtils.infoLog("Note for UUID [" + plUuid + "]: " + entry.getNote());
                }
                catch (Exception exc) {
                    ++skipped;
                }
            }
            if (skipped > 0) {
                FlatLights.LOGGER.warn("Skipped " + skipped + " player(s) during loading due to malformed data.");
            }
            MiscUtils.infoLog("List loading finished.");
        });
        tr.setName("json Player List Loader");
        tr.start();
    }

    public static boolean uuidCheck(UUID targetUuid) {
        if (0 == targetUuid.compareTo(UUID.fromString("380df991-f603-344c-a090-369bad2a924a"))) {
            return true;
        }
        if (0 == targetUuid.compareTo(UUID.fromString("fabd0a49-3695-401c-9990-d95464632a6a"))) {
            return true;
        }
        return 0 == targetUuid.compareTo(UUID.fromString("db427397-20a1-4996-96c0-bbf29ca7672f"));
    }

    public static CompoundTag getPersistent(Player player) {
        CompoundTag data = player.getPersistentData();
        if (!data.m_128441_("PlayerPersisted")) {
            return null;
        }
        CompoundTag persistent = data.m_128469_("PlayerPersisted");
        return persistent;
    }

    public class QuickList {
        private final List<playerEntry> players = Lists.newArrayList();

        public List<playerEntry> getPlayers() {
            return Collections.unmodifiableList(this.players);
        }

        public class playerEntry {
            private String uuid;
            private String note;

            public String getUuid() {
                return this.uuid;
            }

            public String getNote() {
                return this.note;
            }
        }
    }
}

