/*
 * Decompiled with CFR 0.152.
 */
package com.uberhelixx.flatlights.util;

import com.uberhelixx.flatlights.client.particle.BasicColorParticleConstructor;
import com.uberhelixx.flatlights.client.particle.BasicColorParticleOptions;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ParticleHelper {
    public static ParticleOptions constructSimpleSpark(Color color, float diameter, int lifetime, float scaleModifier) {
        return new BasicColorParticleOptions(BasicColorParticleConstructor.builder().color(color.getRGB()).diameter(diameter).lifetime(lifetime).scaleModifier(scaleModifier).roll(0.5f).build());
    }

    public static void createBall(ParticleOptions particle, Vec3 vec, Level level, int density, float speed) {
        if (!level.m_5776_()) {
            return;
        }
        for (int i = -density; i <= density; ++i) {
            for (int j = -density; j <= density; ++j) {
                for (int k = -density; k <= density; ++k) {
                    double d3 = (double)j + (level.f_46441_.m_188500_() - level.f_46441_.m_188500_()) * 0.5;
                    double d4 = (double)i + (level.f_46441_.m_188500_() - level.f_46441_.m_188500_()) * 0.5;
                    double d5 = (double)k + (level.f_46441_.m_188500_() - level.f_46441_.m_188500_()) * 0.5;
                    double d6 = (double)Mth.m_14116_((float)((float)(d3 * d3 + d4 * d4 + d5 * d5))) / (double)speed + level.f_46441_.m_188583_() * 0.05;
                    level.m_7106_(particle, vec.m_7096_(), vec.m_7098_(), vec.m_7094_(), d3 / d6, d4 / d6, d5 / d6);
                    if (i == -density || i == density || j == -density || j == density) continue;
                    k += density * 2 - 1;
                }
            }
        }
    }

    public static void createCyl(ParticleOptions particle, Vec3 center, Level level, double radius, float step) {
        int offset = 16;
        double len = (float)(Math.PI * 2 * radius);
        int num = (int)(len / (double)step);
        for (int i = 0; i < num; ++i) {
            int tries;
            double angle = Math.toRadians((double)(360.0f / (float)num * (float)i) + 360.0 * ((len / (double)step - (double)num) / (double)num / len));
            double extraX = radius * Math.sin(angle) + center.m_7096_();
            double extraZ = radius * Math.cos(angle) + center.m_7094_();
            double extraY = center.m_7098_() + 0.5;
            boolean foundPos = false;
            for (tries = 0; tries < offset * 2; ++tries) {
                Vec3 vec = new Vec3(extraX, extraY, extraZ);
                BlockPos pos = new BlockPos((int)vec.f_82479_, (int)vec.f_82480_, (int)vec.f_82481_);
                BlockState state = level.m_8055_(pos);
                VoxelShape shape = state.m_60812_((BlockGetter)level, pos);
                Block block = state.m_60734_();
                if (block instanceof LiquidBlock) {
                    LiquidBlock liquid = (LiquidBlock)block;
                    AABB aabb = new AABB(pos);
                    aabb.m_82400_(-0.5);
                    shape = Shapes.m_83144_();
                }
                if (shape.m_83281_()) {
                    if (!foundPos) {
                        extraY -= 1.0;
                        continue;
                    }
                } else {
                    foundPos = true;
                }
                if (shape.m_83281_()) break;
                AABB aabb = shape.m_83215_();
                if (!aabb.m_82338_(pos).m_82390_(vec)) {
                    if (!(aabb.f_82292_ >= 1.0)) break;
                    extraY += 1.0;
                    continue;
                }
                extraY += (double)step;
            }
            if (tries >= offset * 2) continue;
            level.m_7106_(particle, extraX, extraY + (double)0.1f, extraZ, 0.0, 0.0, 0.0);
        }
    }

    public static void createCylinder(ParticleOptions particle, Level level, int rings, Vec3 motion, double length, Vec3 center, double radius, float step) {
        double len = (float)(Math.PI * 2 * radius);
        int num = (int)(len / (double)step);
        for (int i = 0; i < num; ++i) {
            double angle = Math.toRadians((double)(360.0f / (float)num * (float)i) + 360.0 * ((len / (double)step - (double)num) / (double)num / len));
            double extraX = radius * Math.sin(angle) + center.m_7096_();
            double extraZ = radius * Math.cos(angle) + center.m_7094_();
            double extraY = center.m_7098_() + 0.5;
            Vec3 start = new Vec3(extraX, extraY, extraZ);
            Vec3 end = new Vec3(extraX + motion.m_7096_() * length, extraY + motion.m_7098_() * length, extraZ + motion.m_7094_() * length);
            ParticleHelper.createLine(particle, level, start, end, rings, motion);
        }
    }

    public static void createLine(ParticleOptions particle, Level level, Vec3 start, Vec3 end, int amount, Vec3 motion) {
        Vec3 delta = end.m_82546_(start);
        Vec3 dir = delta.m_82541_();
        for (int i = 0; i < amount; ++i) {
            double progress = (double)i * delta.m_82553_() / (double)amount;
            level.m_7106_(particle, start.f_82479_ + dir.f_82479_ * progress, start.f_82480_ + dir.f_82480_ * progress, start.f_82481_ + dir.f_82481_ * progress, motion.f_82479_, motion.f_82480_, motion.f_82481_);
        }
    }

    public static void createLine(ParticleOptions particle, Level level, Vec3 start, Vec3 end, int amount) {
        ParticleHelper.createLine(particle, level, start, end, amount, Vec3.f_82478_);
    }
}

