/*
 * Decompiled with CFR 0.152.
 */
package de.fabenet.createnj.item;

import com.google.common.collect.Iterables;
import de.fabenet.createnj.client.model.Modelbrass_exoskeleton;
import de.fabenet.createnj.init.CreateNjModItems;
import de.fabenet.createnj.procedures.ExoskeletenTickEventProcedure;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public abstract class NetheriteExoskeletonItem
extends ArmorItem {
    public static Holder<ArmorMaterial> ARMOR_MATERIAL = null;

    @SubscribeEvent
    public static void registerArmorMaterial(RegisterEvent event) {
        event.register(Registries.ARMOR_MATERIAL, registerHelper -> {
            ArmorMaterial armorMaterial = new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
                map.put(ArmorItem.Type.BOOTS, 2);
                map.put(ArmorItem.Type.LEGGINGS, 5);
                map.put(ArmorItem.Type.CHESTPLATE, 8);
                map.put(ArmorItem.Type.HELMET, 2);
                map.put(ArmorItem.Type.BODY, 8);
            }), 15, (Holder)DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ResourceLocation.parse((String)"item.armor.equip_netherite")), () -> Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.NETHERITE_INGOT)}), List.of(new ArmorMaterial.Layer(ResourceLocation.parse((String)"create_nj:netherite_"))), 3.0f, 0.1f);
            registerHelper.register(ResourceLocation.parse((String)"create_nj:netherite_exoskeleton"), (Object)armorMaterial);
            ARMOR_MATERIAL = BuiltInRegistries.ARMOR_MATERIAL.wrapAsHolder((Object)armorMaterial);
        });
    }

    @SubscribeEvent
    public static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            @OnlyIn(value=Dist.CLIENT)
            public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("body", new Modelbrass_exoskeleton<T>((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)Modelbrass_exoskeleton.LAYER_LOCATION)).body, "right_arm", new Modelbrass_exoskeleton<T>((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)Modelbrass_exoskeleton.LAYER_LOCATION)).leftArm, "left_arm", new Modelbrass_exoskeleton<T>((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)Modelbrass_exoskeleton.LAYER_LOCATION)).rightArm, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                armorModel.crouching = living.isShiftKeyDown();
                armorModel.riding = defaultModel.riding;
                armorModel.young = living.isBaby();
                return armorModel;
            }
        }, new Item[]{(Item)CreateNjModItems.NETHERITE_EXOSKELETON_CHESTPLATE.get()});
    }

    public NetheriteExoskeletonItem(ArmorItem.Type type, Item.Properties properties) {
        super(ARMOR_MATERIAL, type, properties);
    }

    public static class Chestplate
    extends NetheriteExoskeletonItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties().durability(ArmorItem.Type.CHESTPLATE.getDurability(25)).fireResistant());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
            CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            double fuel = 0.0;
            double water = 0.0;
            if (customData != null) {
                CompoundTag tag = customData.copyTag();
                fuel = tag.getDouble("tagFuel");
                water = tag.getDouble("tagWater");
            }
            String tagFuel = String.format("%.1f", fuel);
            String tagWater = String.format("%.1f", water);
            if (Screen.hasShiftDown()) {
                list.add((Component)Component.literal((String)"\u00a78Hold [\u00a7fShift\u00a78] for Summary"));
                list.add((Component)Component.literal((String)("\u00a77Fuel: \u00a78" + tagFuel + "/6400.0")));
                list.add((Component)Component.literal((String)("\u00a77Water: \u00a78" + tagWater + "/6400.0")));
                list.add((Component)Component.literal((String)" "));
                list.add((Component)Component.literal((String)"\u00a75Allows the wielder to \u00a7dboost his"));
                list.add((Component)Component.literal((String)"\u00a7dphysical abilities\u00a75! You can destroy"));
                list.add((Component)Component.literal((String)"\u00a75enemies with bare hands and dig "));
                list.add((Component)Component.literal((String)"\u00a75much faster thanks to this next-gen"));
                list.add((Component)Component.literal((String)"\u00a75mechanism. It needs \u00a7dwater\u00a75 and \u00a7dfuel\u00a75 to"));
                list.add((Component)Component.literal((String)"\u00a75operate, put it in your water by"));
                list.add((Component)Component.literal((String)"\u00a75pressing Q (coal, wood, water bucket...)"));
                list.add((Component)Component.literal((String)" "));
                list.add((Component)Component.literal((String)"\u00a77When Worn"));
                list.add((Component)Component.literal((String)"\u00a75 Provide a \u00a7dHaste II\u00a75 and a \u00a7dStrength II\u00a75 effect,"));
                list.add((Component)Component.literal((String)"\u00a75 slowly consuming \u00a7dfuel and water"));
            } else {
                list.add((Component)Component.literal((String)"\u00a78Hold [\u00a77Shift\u00a78] for Summary"));
                list.add((Component)Component.literal((String)("\u00a77Fuel: \u00a78" + tagFuel + "/6400.0")));
                list.add((Component)Component.literal((String)("\u00a77Water: \u00a78" + tagWater + "/6400.0")));
            }
            super.appendHoverText(stack, context, list, flag);
        }

        public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
            CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            double tagRotate = 0.0;
            if (data != null) {
                tagRotate = data.copyTag().getDouble("tagRotate");
            }
            if (tagRotate == 2.0) {
                return ResourceLocation.parse((String)"create_nj:textures/entities/brass_exoskeleton_2.png");
            }
            if (tagRotate == 3.0) {
                return ResourceLocation.parse((String)"create_nj:textures/entities/brass_exoskeleton_3.png");
            }
            if (tagRotate == 4.0) {
                return ResourceLocation.parse((String)"create_nj:textures/entities/brass_exoskeleton_4.png");
            }
            if (tagRotate == 5.0) {
                return ResourceLocation.parse((String)"create_nj:textures/entities/brass_exoskeleton_5.png");
            }
            if (tagRotate == 6.0) {
                return ResourceLocation.parse((String)"create_nj:textures/entities/brass_exoskeleton_6.png");
            }
            if (tagRotate == 7.0) {
                return ResourceLocation.parse((String)"create_nj:textures/entities/brass_exoskeleton_7.png");
            }
            if (tagRotate == 8.0) {
                return ResourceLocation.parse((String)"create_nj:textures/entities/brass_exoskeleton_8.png");
            }
            return ResourceLocation.parse((String)"create_nj:textures/entities/brass_exoskeleton_1.png");
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                ExoskeletenTickEventProcedure.execute((LevelAccessor)world, entity, itemstack);
            }
        }
    }
}

