/*
 * Decompiled with CFR 0.152.
 */
package net.themcbrothers.sharedadvancements;

import java.lang.reflect.Method;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.themcbrothers.sharedadvancements.Constants;
import net.themcbrothers.sharedadvancements.platform.Services;

public class CommonClass {
    private static boolean skipEvent;
    private static Method serverGetterMethod;

    public static void init() {
        Constants.LOG.info("Initializing {} for {}", (Object)"Shared Advancements", (Object)Services.PLATFORM.getPlatformName());
    }

    public static void progressAdvancement(ServerPlayer player, String criterionName, AdvancementHolder advancement) {
        CommonClass.handle(player, (serverPlayer, server) -> serverPlayer.getAdvancements().award(advancement, criterionName));
    }

    public static void playerJoin(ServerPlayer player) {
        CommonClass.handle(player, (serverPlayer, server) -> CommonClass.syncCriteria(player, serverPlayer, server));
    }

    private static void handle(ServerPlayer player, BiConsumer<ServerPlayer, MinecraftServer> callback) {
        if (skipEvent || !Services.CONFIG.enabled()) {
            return;
        }
        boolean broadcast = Services.CONFIG.broadcast();
        MinecraftServer server = CommonClass.getServer(player);
        PlayerTeam team = player.getTeam();
        if (server != null && (broadcast || team != null)) {
            skipEvent = true;
            server.getPlayerList().getPlayers().stream().filter(serverPlayer -> !serverPlayer.equals((Object)player)).filter(arg_0 -> CommonClass.lambda$handle$3(broadcast, (Team)team, arg_0)).forEach(serverPlayer -> callback.accept((ServerPlayer)serverPlayer, server));
            skipEvent = false;
        }
    }

    private static void syncCriteria(ServerPlayer first, ServerPlayer second, MinecraftServer server) {
        for (AdvancementHolder advancement : server.getAdvancements().getAllAdvancements()) {
            List firstCompleted = (List)first.getAdvancements().getOrStartProgress(advancement).getCompletedCriteria();
            List secondCompleted = (List)second.getAdvancements().getOrStartProgress(advancement).getCompletedCriteria();
            for (String criterion : advancement.value().criteria().keySet()) {
                if (firstCompleted.contains(criterion) && !secondCompleted.contains(criterion)) {
                    second.getAdvancements().award(advancement, criterion);
                    continue;
                }
                if (firstCompleted.contains(criterion) || !secondCompleted.contains(criterion)) continue;
                first.getAdvancements().award(advancement, criterion);
            }
        }
    }

    private static Method findServerGetter(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            if (method.getParameterCount() != 0 || method.getReturnType() != MinecraftServer.class) continue;
            Constants.LOG.info("Server getter method: {}#{}", (Object)clazz.getName(), (Object)method.getName());
            return method;
        }
        return null;
    }

    private static MinecraftServer getServer(ServerPlayer player) {
        try {
            ServerPlayer target = serverGetterMethod.getDeclaringClass() == Entity.class ? player : player.level();
            return (MinecraftServer)serverGetterMethod.invoke((Object)target, new Object[0]);
        }
        catch (Exception e) {
            Constants.LOG.error("Could not get Minecraft Server!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ boolean lambda$handle$3(boolean broadcast, Team team, ServerPlayer serverPlayer) {
        return broadcast || team.getPlayers().contains(serverPlayer.getScoreboardName());
    }

    static {
        serverGetterMethod = CommonClass.findServerGetter(Entity.class);
        if (serverGetterMethod == null) {
            serverGetterMethod = CommonClass.findServerGetter(ServerLevel.class);
        }
        if (serverGetterMethod == null) {
            throw new RuntimeException("Cannot find server getter method");
        }
    }
}

