/*
 * Decompiled with CFR 0.152.
 */
package net.themcbrothers.sharedadvancements;

import java.lang.reflect.Method;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8779;
import net.minecraft.server.MinecraftServer;
import net.themcbrothers.sharedadvancements.Constants;
import net.themcbrothers.sharedadvancements.platform.Services;

public class CommonClass {
    private static boolean skipEvent;
    private static Method serverGetterMethod;

    public static void init() {
        Constants.LOG.info("Initializing {} for {}", (Object)"Shared Advancements", (Object)Services.PLATFORM.getPlatformName());
    }

    public static void progressAdvancement(class_3222 player, String criterionName, class_8779 advancement) {
        CommonClass.handle(player, (serverPlayer, server) -> serverPlayer.method_14236().method_12878(advancement, criterionName));
    }

    public static void playerJoin(class_3222 player) {
        CommonClass.handle(player, (serverPlayer, server) -> CommonClass.syncCriteria(player, serverPlayer, server));
    }

    private static void handle(class_3222 player, BiConsumer<class_3222, MinecraftServer> callback) {
        if (skipEvent || !Services.CONFIG.enabled()) {
            return;
        }
        boolean broadcast = Services.CONFIG.broadcast();
        MinecraftServer server = CommonClass.getServer(player);
        class_268 team = player.method_5781();
        if (server != null && (broadcast || team != null)) {
            skipEvent = true;
            server.method_3760().method_14571().stream().filter(serverPlayer -> !serverPlayer.equals((Object)player)).filter(arg_0 -> CommonClass.lambda$handle$3(broadcast, (class_270)team, arg_0)).forEach(serverPlayer -> callback.accept((class_3222)serverPlayer, server));
            skipEvent = false;
        }
    }

    private static void syncCriteria(class_3222 first, class_3222 second, MinecraftServer server) {
        for (class_8779 advancement : server.method_3851().method_12893()) {
            List firstCompleted = (List)first.method_14236().method_12882(advancement).method_734();
            List secondCompleted = (List)second.method_14236().method_12882(advancement).method_734();
            for (String criterion : advancement.comp_1920().comp_1915().keySet()) {
                if (firstCompleted.contains(criterion) && !secondCompleted.contains(criterion)) {
                    second.method_14236().method_12878(advancement, criterion);
                    continue;
                }
                if (firstCompleted.contains(criterion) || !secondCompleted.contains(criterion)) continue;
                first.method_14236().method_12878(advancement, criterion);
            }
        }
    }

    private static Method findServerGetter(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            if (method.getParameterCount() != 0 || method.getReturnType() != MinecraftServer.class) continue;
            Constants.LOG.info("Server getter method: {}#{}", (Object)clazz.getName(), (Object)method.getName());
            return method;
        }
        return null;
    }

    private static MinecraftServer getServer(class_3222 player) {
        try {
            class_3222 target = serverGetterMethod.getDeclaringClass() == class_1297.class ? player : player.method_51469();
            return (MinecraftServer)serverGetterMethod.invoke((Object)target, new Object[0]);
        }
        catch (Exception e) {
            Constants.LOG.error("Could not get Minecraft Server!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ boolean lambda$handle$3(boolean broadcast, class_270 team, class_3222 serverPlayer) {
        return broadcast || team.method_1204().contains(serverPlayer.method_5820());
    }

    static {
        serverGetterMethod = CommonClass.findServerGetter(class_1297.class);
        if (serverGetterMethod == null) {
            serverGetterMethod = CommonClass.findServerGetter(class_3218.class);
        }
        if (serverGetterMethod == null) {
            throw new RuntimeException("Cannot find server getter method");
        }
    }
}

